/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.reflections8.Configuration;
import org.reflections8.Reflections;
import org.reflections8.ReflectionsException;
import org.reflections8.adapters.JavaReflectionAdapter;
import org.reflections8.adapters.JavassistAdapter;
import org.reflections8.adapters.MetadataAdapter;
import org.reflections8.scanners.Scanner;
import org.reflections8.scanners.SubTypesScanner;
import org.reflections8.scanners.TypeAnnotationsScanner;
import org.reflections8.serializers.Serializer;
import org.reflections8.serializers.XmlSerializer;
import org.reflections8.util.ClasspathHelper;
import org.reflections8.util.FilterBuilder;

public class ConfigurationBuilder
implements Configuration {
    private Set<Scanner> scanners;
    private Set<URL> urls;
    protected MetadataAdapter metadataAdapter;
    private Optional<Predicate<String>> inputsFilter = Optional.empty();
    private Serializer serializer;
    private Optional<ExecutorService> executorService = Optional.empty();
    private Optional<ClassLoader[]> classLoaders = Optional.empty();
    private boolean expandSuperTypes = true;

    public ConfigurationBuilder() {
        this.scanners = new HashSet<Scanner>();
        this.scanners.add(new TypeAnnotationsScanner());
        this.scanners.add(new SubTypesScanner());
        this.urls = new HashSet<URL>();
    }

    /*
     * WARNING - void declaration
     */
    public static ConfigurationBuilder build(Object ... params) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ArrayList<Object> parameters2 = new ArrayList<Object>();
        if (params != null) {
            void var5_7;
            Object[] objectArray = params;
            int n = objectArray.length;
            boolean bl = false;
            while (var5_7 < n) {
                Object param = objectArray[var5_7];
                if (param != null) {
                    if (param.getClass().isArray()) {
                        for (Object p : (Object[])param) {
                            if (p == null) continue;
                            parameters2.add(p);
                        }
                    } else if (param instanceof Iterable) {
                        for (Object e : (Iterable)param) {
                            if (e == null) continue;
                            parameters2.add(e);
                        }
                    } else {
                        parameters2.add(param);
                    }
                }
                ++var5_7;
            }
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (Object e : parameters2) {
            if (!(e instanceof ClassLoader)) continue;
            loaders.add((ClassLoader)e);
        }
        ClassLoader[] classLoaders = loaders.isEmpty() ? null : loaders.toArray(new ClassLoader[loaders.size()]);
        FilterBuilder filterBuilder = new FilterBuilder();
        ArrayList<Scanner> scanners = new ArrayList<Scanner>();
        for (Object e : parameters2) {
            if (e instanceof String) {
                builder.addUrls(ClasspathHelper.forPackage((String)e, classLoaders));
                filterBuilder.includePackage((String)e);
                continue;
            }
            if (e instanceof Class) {
                if (Scanner.class.isAssignableFrom((Class)e)) {
                    try {
                        builder.addScanners((Scanner)((Class)e).newInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                builder.addUrls(ClasspathHelper.forClass((Class)e, classLoaders));
                filterBuilder.includePackage((Class)e);
                continue;
            }
            if (e instanceof Scanner) {
                scanners.add((Scanner)e);
                continue;
            }
            if (e instanceof URL) {
                builder.addUrls((URL)e);
                continue;
            }
            if (e instanceof ClassLoader) continue;
            if (e instanceof Predicate) {
                filterBuilder.add((Predicate)e);
                continue;
            }
            if (e instanceof ExecutorService) {
                builder.setExecutorService((ExecutorService)e);
                continue;
            }
            if (!Reflections.log.isPresent()) continue;
            throw new ReflectionsException("could not use param " + e);
        }
        if (builder.getUrls().isEmpty()) {
            if (classLoaders != null) {
                builder.addUrls(ClasspathHelper.forClassLoader(classLoaders));
            } else {
                builder.addUrls(ClasspathHelper.forClassLoader());
            }
        }
        builder.filterInputsBy(filterBuilder);
        if (!scanners.isEmpty()) {
            builder.setScanners(scanners.toArray(new Scanner[scanners.size()]));
        }
        if (!loaders.isEmpty()) {
            builder.addClassLoaders(loaders);
        }
        return builder;
    }

    public ConfigurationBuilder forPackages(String ... packages2) {
        for (String pkg : packages2) {
            this.addUrls(ClasspathHelper.forPackage(pkg, new ClassLoader[0]));
        }
        return this;
    }

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        HashSet<Scanner> set = new HashSet<Scanner>();
        set.addAll(Arrays.asList(scanners));
        this.scanners.addAll(set);
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> urls2) {
        this.urls = new HashSet<URL>(urls2);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls2) {
        this.urls = new HashSet<URL>(Arrays.asList(urls2));
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls2) {
        this.urls.addAll(urls2);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls2) {
        this.urls.addAll(Arrays.asList(urls2));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable e) {
            if (Reflections.log.isPresent()) {
                Reflections.log.get().warn("could not create JavassistAdapter, using JavaReflectionAdapter", e);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    public Optional<Predicate<String>> getInputsFilter() {
        return this.inputsFilter;
    }

    public void setInputsFilter(Predicate<String> inputsFilter) {
        this.inputsFilter = Optional.of(inputsFilter);
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = Optional.of(inputsFilter);
        return this;
    }

    @Override
    public Optional<ExecutorService> getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = Optional.of(executorService);
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public Optional<ClassLoader[]> getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public boolean shouldExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public ConfigurationBuilder setExpandSuperTypes(boolean expandSuperTypes) {
        this.expandSuperTypes = expandSuperTypes;
        return this;
    }

    public void setClassLoaders(Optional<ClassLoader[]> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        if (this.classLoaders.isPresent()) {
            ClassLoader[] existing = this.classLoaders.get();
            int existingLength = existing.length;
            ClassLoader[] tmpArray = Arrays.copyOf(existing, existingLength + classLoaders.length);
            System.arraycopy(classLoaders, 0, tmpArray, existingLength, classLoaders.length);
            this.classLoaders = Optional.of(tmpArray);
        } else {
            this.classLoaders = Optional.of(classLoaders);
        }
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }
}

