/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.serializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.reflections8.Reflections;
import org.reflections8.serializers.Serializer;
import org.reflections8.util.HashSetMultimap;
import org.reflections8.util.SetMultimap;
import org.reflections8.util.Utils;

public class JsonSerializer
implements Serializer {
    private Gson gson;

    @Override
    public Reflections read(InputStream inputStream2) {
        return this.getGson().fromJson((Reader)new InputStreamReader(inputStream2, Charset.forName("UTF-8")), Reflections.class);
    }

    @Override
    public File save(Reflections reflections, String filename) {
        try {
            File file = Utils.prepareFile(filename);
            Files.write(file.toPath(), this.toString(reflections).getBytes(Charset.defaultCharset()), new OpenOption[0]);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString(Reflections reflections) {
        return this.getGson().toJson(reflections);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)SetMultimap.class), new com.google.gson.JsonSerializer<SetMultimap>(){

                @Override
                public JsonElement serialize(SetMultimap multimap, Type type2, JsonSerializationContext jsonSerializationContext) {
                    return jsonSerializationContext.serialize(multimap.asMap());
                }
            }).registerTypeAdapter((Type)((Object)SetMultimap.class), new JsonDeserializer<SetMultimap>(){

                @Override
                public SetMultimap deserialize(JsonElement jsonElement, Type type2, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    HashSetMultimap<String, String> map2 = new HashSetMultimap<String, String>(new Supplier<Set<String>>(){

                        @Override
                        public Set<String> get() {
                            return new HashSet<String>();
                        }
                    });
                    for (Map.Entry<String, JsonElement> entry : ((JsonObject)jsonElement).entrySet()) {
                        for (JsonElement element : (JsonArray)entry.getValue()) {
                            map2.putSingle(entry.getKey(), element.getAsString());
                        }
                    }
                    return map2;
                }
            }).setPrettyPrinting().create();
        }
        return this.gson;
    }
}

