/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.resourcepacks.hub;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.plugins.discord.DiscordPlugin;
import net.runelite.client.plugins.resourcepacks.ResourcePacksConfig;
import net.runelite.client.plugins.resourcepacks.ResourcePacksManager;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePackManifest;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePacksClient;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePacksHubItem;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResourcePacksHubPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ResourcePacksHubPanel.class);
    public static final Pattern SPACES = Pattern.compile(" +");
    public static final Splitter SPLITTER = Splitter.on(" ").trimResults().omitEmptyStrings();
    private final ResourcePacksManager resourcePacksManager;
    private final ResourcePacksClient resourcePacksClient;
    private final ScheduledExecutorService executor;
    private final ResourcePacksConfig config;
    private final IconTextField searchBar;
    public final JComboBox currentHubPackComboBox;
    private final JLabel refreshing;
    private final JPanel mainPanel;
    private static final ImageIcon DISCORD_ICON;
    private static final int BOTTOM_LINE_HEIGHT = 24;
    private static final int DISCORD_ICON_SIZE = 18;
    private List<ResourcePacksHubItem> packs = null;
    private boolean ignoreSelected = false;

    @Inject
    ResourcePacksHubPanel(ResourcePacksManager resourcePacksManager, ResourcePacksClient resourcePacksClient, ScheduledExecutorService executor, ResourcePacksConfig config) {
        super(false);
        this.resourcePacksManager = resourcePacksManager;
        this.resourcePacksClient = resourcePacksClient;
        this.executor = executor;
        this.config = config;
        String refresh = "this could just be a lambda, but no, it has to be abstracted";
        this.getInputMap(1).put(KeyStroke.getKeyStroke(116, 0), refresh);
        this.getActionMap().put(refresh, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourcePacksHubPanel.this.reloadResourcePackList();
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ResourcePacksHubPanel.this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ResourcePacksHubPanel.this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ResourcePacksHubPanel.this.filter();
            }
        });
        JButton discordButton = new JButton();
        discordButton.setIcon(DISCORD_ICON);
        discordButton.setBackground(ColorScheme.DARK_GRAY_COLOR);
        discordButton.addActionListener(ev -> LinkBrowser.browse("https://discord.gg/DsDhUz4NNN"));
        discordButton.setToolTipText("Hang out with pack creators and ask for any help");
        discordButton.addChangeListener(ev -> {
            if (discordButton.getModel().isPressed()) {
                discordButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            } else if (discordButton.getModel().isRollover()) {
                discordButton.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            } else {
                discordButton.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        this.currentHubPackComboBox = new JComboBox();
        this.currentHubPackComboBox.setPrototypeDisplayValue("XXXXXXXXXXX");
        this.currentHubPackComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1 && !this.ignoreSelected) {
                if (e.getItem() instanceof ResourcePackManifest) {
                    ResourcePackManifest resourcePackManifest = (ResourcePackManifest)e.getItem();
                    resourcePacksManager.setSelectedHubPack(resourcePackManifest.getInternalName());
                } else {
                    resourcePacksManager.setSelectedHubPack("None");
                }
            }
        });
        JLabel currentHubPackLabel = new JLabel("Selected pack: ");
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 7, 15, 7));
        this.mainPanel.setLayout(new DynamicGridLayout(0, 1, 0, 5));
        this.mainPanel.setAlignmentX(0.0f);
        this.refreshing = new JLabel("Loading...");
        this.refreshing.setHorizontalAlignment(0);
        JPanel mainPanelWrapper = new JPanel();
        mainPanelWrapper.setLayout(new BorderLayout());
        mainPanelWrapper.add((Component)this.mainPanel, "North");
        mainPanelWrapper.add((Component)this.refreshing, "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(28672, 28672));
        scrollPane.setViewportView(mainPanelWrapper);
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchBar, 24, 24, 24).addComponent(discordButton, 24, 24, 24)).addGap(5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(currentHubPackLabel).addComponent(this.currentHubPackComboBox)).addGap(10).addComponent(scrollPane));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(7).addComponent(this.searchBar).addGap(3).addComponent(discordButton, 0, 24, 24).addGap(7)).addGroup(layout.createSequentialGroup().addGap(7).addComponent(currentHubPackLabel).addComponent(this.currentHubPackComboBox).addGap(7)).addComponent(scrollPane));
        this.revalidate();
        this.refreshing.setVisible(false);
        this.reloadResourcePackList();
    }

    private void reloadResourcePackList() {
        if (this.refreshing.isVisible()) {
            return;
        }
        this.refreshing.setVisible(true);
        this.mainPanel.removeAll();
        this.executor.submit(() -> {
            List<ResourcePackManifest> manifest;
            try {
                manifest = this.resourcePacksClient.downloadManifest();
            }
            catch (IOException e) {
                log.error("", e);
                SwingUtilities.invokeLater(() -> {
                    this.refreshing.setVisible(false);
                    this.mainPanel.add(new JLabel("Downloading the pack manifest failed"));
                    JButton retry2 = new JButton("Retry");
                    retry2.addActionListener(l -> this.reloadResourcePackList());
                    this.mainPanel.add(retry2);
                });
                return;
            }
            this.reloadResourcePackList(manifest);
        });
    }

    public void reloadResourcePackList(List<ResourcePackManifest> manifest) {
        Map downloadedManifests = manifest.stream().collect(ImmutableMap.toImmutableMap(ResourcePackManifest::getInternalName, Function.identity()));
        try {
            HashMultimap<String, ResourcePackManifest> currentManifests = this.resourcePacksManager.getCurrentManifests();
            HashSet<String> installed = new HashSet<String>(this.resourcePacksManager.getInstalledResourcePacks());
            HashMap<String, ResourcePackManifest> installedPacks = new HashMap<String, ResourcePackManifest>();
            for (String pack : installed) {
                ResourcePackManifest packManifest = (ResourcePackManifest)downloadedManifests.get(pack);
                if (packManifest == null) continue;
                installedPacks.put(pack, packManifest);
            }
            SwingUtilities.invokeLater(() -> {
                this.ignoreSelected = true;
                this.currentHubPackComboBox.removeAllItems();
                this.currentHubPackComboBox.addItem("None");
                installed.forEach(internal -> {
                    ResourcePackManifest toAddManifest = (ResourcePackManifest)installedPacks.get(internal);
                    if (((DefaultComboBoxModel)this.currentHubPackComboBox.getModel()).getIndexOf(toAddManifest) == -1) {
                        this.currentHubPackComboBox.addItem(toAddManifest);
                        if (this.config.selectedHubPack().equals(toAddManifest.getInternalName())) {
                            this.currentHubPackComboBox.setSelectedItem(toAddManifest);
                        }
                    }
                });
                this.ignoreSelected = false;
                ArrayList<ResourcePacksHubItem> list = new ArrayList<ResourcePacksHubItem>();
                for (String id : downloadedManifests.keySet()) {
                    ResourcePacksHubItem resourcePacksHubItem = new ResourcePacksHubItem((ResourcePackManifest)downloadedManifests.get(id), currentManifests.get((Object)id), installed.contains(id), this.executor, this.resourcePacksClient, this.resourcePacksManager);
                    list.add(resourcePacksHubItem);
                }
                this.packs = list;
                this.refreshing.setVisible(false);
                this.filter();
            });
        }
        catch (IOException e) {
            log.error("", e);
        }
    }

    void filter() {
        boolean isSearching;
        if (this.refreshing.isVisible()) {
            return;
        }
        this.mainPanel.removeAll();
        Stream<Object> stream = this.packs.stream();
        String search = this.searchBar.getText();
        boolean bl = isSearching = search != null && !search.trim().isEmpty();
        stream = isSearching ? stream.filter(p -> Text.matchesSearchTerms(SPLITTER.split(search.toLowerCase()), p.keywords)).sorted(Comparator.comparing(p -> p.manifest.getDisplayName())) : stream.sorted(Comparator.comparing(ResourcePacksHubItem::isInstalled).thenComparing(p -> p.manifest.getDisplayName()));
        stream.forEach(this.mainPanel::add);
        this.mainPanel.revalidate();
    }

    @Override
    public void onActivate() {
        this.revalidate();
        this.searchBar.setText("");
        this.reloadResourcePackList();
        this.searchBar.requestFocusInWindow();
    }

    static {
        BufferedImage discordIcon = ImageUtil.resizeImage(ImageUtil.loadImageResource(DiscordPlugin.class, "discord.png"), 18, 18);
        DISCORD_ICON = new ImageIcon(discordIcon);
    }
}

