/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.loottracker.LootTrackerItem;
import net.runelite.client.plugins.loottracker.LootTrackerMapping;
import net.runelite.client.plugins.loottracker.LootTrackerPriceType;
import net.runelite.client.plugins.loottracker.LootTrackerRecord;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.loottracker.LootRecordType;

class LootTrackerBox
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private static final int TITLE_PADDING = 5;
    private final JPanel itemContainer = new JPanel();
    private final JLabel priceLabel = new JLabel();
    private final JLabel subTitleLabel = new JLabel();
    private final JPanel logTitle = new JPanel();
    private final ItemManager itemManager;
    private final String id;
    private final LootRecordType lootRecordType;
    private final LootTrackerPriceType priceType;
    private final boolean showPriceType;
    private int kills;
    private final List<LootTrackerItem> items = new ArrayList<LootTrackerItem>();
    private long totalPrice;
    private final boolean hideIgnoredItems;
    private final BiConsumer<String, Boolean> onItemToggle;

    LootTrackerBox(ItemManager itemManager, String id, LootRecordType lootRecordType, @Nullable String subtitle, boolean hideIgnoredItems, LootTrackerPriceType priceType, boolean showPriceType, BiConsumer<String, Boolean> onItemToggle, BiConsumer<String, Boolean> onEventToggle, boolean eventIgnored) {
        this.id = id;
        this.lootRecordType = lootRecordType;
        this.itemManager = itemManager;
        this.onItemToggle = onItemToggle;
        this.hideIgnoredItems = hideIgnoredItems;
        this.priceType = priceType;
        this.showPriceType = showPriceType;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.logTitle.setLayout(new BoxLayout(this.logTitle, 0));
        this.logTitle.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.logTitle.setBackground(eventIgnored ? ColorScheme.DARKER_GRAY_HOVER_COLOR : ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel titleLabel = new JLabel();
        String[][] colorCodesAndValues = new String[][]{{"@pur@", "#A10081"}, {"@red@", "#FF0000"}, {"@gre@", "#65280"}, {"@blu@", "#0000FF"}, {"@bl2@", "#0F0085"}, {"@bl3@", "#00AFFF"}, {"@yel@", "#FFFF00"}, {"@cya@", "#00FFFF"}, {"@mag@", "#FF00FF"}, {"@whi@", "#FFFFFF"}, {"@lre@", "#FF9040"}, {"@dre@", "#800000"}, {"@bla@", "#000000"}, {"@or0@", "#A67711"}, {"@or1@", "#FFB000"}, {"@or2@", "#FF7000"}, {"@or3@", "#FF3000"}, {"@or4@", "#FF9933"}, {"@gr0@", "#148200"}, {"@gr1@", "#C0FF00"}, {"@gr2@", "#80FF00"}, {"@gr3@", "#40FF00"}, {"@OR0@", "#A67711"}, {"@PUR@", "#A10081"}, {"@RED@", "#FF0000"}, {"@GRE@", "#65280"}, {"@BLU@", "#0000FF"}, {"@YEL@", "#FFFF00"}, {"@CYA@", "#00FFFF"}, {"@MAG@", "#FF00FF"}, {"@WHI@", "#FFFFFF"}, {"@LRE@", "#FF9040"}, {"@DRE@", "#800000"}, {"@BLA@", "#000000"}, {"@OR1@", "#FFB000"}, {"@OR2@", "#FF7000"}, {"@OR3@", "#FF3000"}, {"@GR1@", "#C0FF00"}, {"@GR2@", "#80FF00"}, {"@GR3@", "#40FF00"}};
        boolean colorFound = false;
        String name = id;
        for (String[] colorCodeAndValue : colorCodesAndValues) {
            String colorCode = colorCodeAndValue[0];
            String colorValue = colorCodeAndValue[1];
            if (!id.contains(colorCode)) continue;
            titleLabel.setForeground(Color.decode(colorValue));
            name = id.replace(colorCode, "");
            colorFound = true;
            break;
        }
        if (!colorFound) {
            titleLabel.setForeground(Color.WHITE);
        }
        titleLabel.setText(Text.removeTags(name));
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setMinimumSize(new Dimension(1, titleLabel.getPreferredSize().height));
        this.logTitle.add(titleLabel);
        this.subTitleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.subTitleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        if (!Strings.isNullOrEmpty(subtitle)) {
            this.subTitleLabel.setText(subtitle);
        }
        this.logTitle.add(Box.createRigidArea(new Dimension(5, 0)));
        this.logTitle.add(this.subTitleLabel);
        this.logTitle.add(Box.createHorizontalGlue());
        this.logTitle.add(Box.createRigidArea(new Dimension(5, 0)));
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.logTitle.add(this.priceLabel);
        this.add((Component)this.logTitle, "North");
        this.add((Component)this.itemContainer, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setComponentPopupMenu(popupMenu);
        JMenuItem toggle = new JMenuItem(eventIgnored ? "Include loot" : "Hide loot");
        toggle.addActionListener(e -> onEventToggle.accept(id, !eventIgnored));
        popupMenu.add(toggle);
    }

    private int getTotalKills() {
        return this.kills;
    }

    boolean matches(LootTrackerRecord record) {
        return record.getTitle().equals(this.id) && record.getType() == this.lootRecordType;
    }

    boolean matches(String id, LootRecordType type2) {
        if (id == null) {
            return true;
        }
        return this.id.equals(id) && this.lootRecordType == type2;
    }

    void addKill(LootTrackerRecord record) {
        if (!this.matches(record)) {
            throw new IllegalArgumentException(record.toString());
        }
        this.kills += record.getKills();
        block0: for (LootTrackerItem item : record.getItems()) {
            int mappedItemId = LootTrackerMapping.map(item.getId(), item.getName());
            for (int idx = 0; idx < this.items.size(); ++idx) {
                LootTrackerItem i = this.items.get(idx);
                if (mappedItemId != i.getId()) continue;
                this.items.set(idx, new LootTrackerItem(i.getId(), i.getName(), i.getQuantity() + item.getQuantity(), i.getGePrice(), i.getHaPrice(), i.isIgnored()));
                continue block0;
            }
            LootTrackerItem mappedItem = mappedItemId == item.getId() ? item : new LootTrackerItem(mappedItemId, item.getName(), item.getQuantity(), item.getGePrice(), item.getHaPrice(), item.isIgnored());
            this.items.add(mappedItem);
        }
    }

    void rebuild() {
        this.buildItems();
        String priceTypeString = " ";
        if (this.showPriceType) {
            String string2 = priceTypeString = this.priceType == LootTrackerPriceType.HIGH_ALCHEMY ? "HA: " : "GE: ";
        }
        if (this.priceType == LootTrackerPriceType.HIGH_ALCHEMY) {
            this.priceLabel.setText(priceTypeString + QuantityFormatter.quantityToStackSize(this.totalPrice) + " gp");
            this.priceLabel.setToolTipText(QuantityFormatter.formatNumber(this.totalPrice) + " gp");
        } else {
            this.priceLabel.setText(priceTypeString + QuantityFormatter.quantityToStackSize(this.totalPrice) + " nomad");
            this.priceLabel.setToolTipText(QuantityFormatter.formatNumber(this.totalPrice) + " nomad");
        }
        long kills = this.getTotalKills();
        if (kills > 1L) {
            this.subTitleLabel.setText("x " + kills);
            this.subTitleLabel.setToolTipText(QuantityFormatter.formatNumber(this.totalPrice / kills) + " gp (average)");
        }
        this.validate();
        this.repaint();
    }

    void collapse() {
        if (!this.isCollapsed()) {
            this.itemContainer.setVisible(false);
            this.applyDimmer(false, this.logTitle);
        }
    }

    void expand() {
        if (this.isCollapsed()) {
            this.itemContainer.setVisible(true);
            this.applyDimmer(true, this.logTitle);
        }
    }

    boolean isCollapsed() {
        return !this.itemContainer.isVisible();
    }

    private void applyDimmer(boolean brighten, JPanel panel) {
        for (Component component : panel.getComponents()) {
            Color color = component.getForeground();
            component.setForeground(brighten ? color.brighter() : color.darker());
        }
    }

    private void buildItems() {
        boolean isHidden;
        this.totalPrice = 0L;
        List<LootTrackerItem> items = this.items;
        if (this.hideIgnoredItems) {
            items = items.stream().filter(item -> !item.isIgnored()).collect(Collectors.toList());
        }
        this.setVisible(!(isHidden = items.isEmpty()));
        if (isHidden) {
            return;
        }
        ToLongFunction<LootTrackerItem> getPrice = this.priceType == LootTrackerPriceType.HIGH_ALCHEMY ? LootTrackerItem::getTotalHaPrice : LootTrackerItem::getTotalGePrice;
        this.totalPrice = items.stream().mapToLong(getPrice).sum();
        items.sort(Comparator.comparingLong(getPrice).reversed());
        int rowSize = (items.size() % 5 == 0 ? 0 : 1) + items.size() / 5;
        this.itemContainer.removeAll();
        this.itemContainer.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (int i = 0; i < rowSize * 5; ++i) {
            JPanel slotContainer = new JPanel();
            slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (i < items.size()) {
                LootTrackerItem item2 = items.get(i);
                JLabel imageLabel = new JLabel();
                imageLabel.setToolTipText(LootTrackerBox.buildToolTip(item2));
                imageLabel.setVerticalAlignment(0);
                imageLabel.setHorizontalAlignment(0);
                AsyncBufferedImage itemImage = this.itemManager.getImage(item2.getId(), item2.getQuantity(), item2.getQuantity() > 1);
                if (item2.isIgnored()) {
                    Runnable addTransparency = () -> {
                        BufferedImage transparentImage = ImageUtil.alphaOffset((Image)itemImage, 0.3f);
                        imageLabel.setIcon(new ImageIcon(transparentImage));
                    };
                    itemImage.onLoaded(addTransparency);
                    addTransparency.run();
                } else {
                    itemImage.addTo(imageLabel);
                }
                slotContainer.add(imageLabel);
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
                slotContainer.setComponentPopupMenu(popupMenu);
                JMenuItem toggle = new JMenuItem("Toggle item");
                toggle.addActionListener(e -> {
                    item2.setIgnored(!item2.isIgnored());
                    this.onItemToggle.accept(item2.getName(), item2.isIgnored());
                });
                popupMenu.add(toggle);
            }
            this.itemContainer.add(slotContainer);
        }
        this.itemContainer.repaint();
    }

    private static String buildToolTip(LootTrackerItem item) {
        String name = item.getName();
        int quantity = item.getQuantity();
        long gePrice = item.getTotalGePrice();
        long haPrice = item.getTotalHaPrice();
        String ignoredLabel = item.isIgnored() ? " - Ignored" : "";
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(name).append(" x ").append(QuantityFormatter.formatNumber(quantity)).append(ignoredLabel);
        if (item.getId() == 995) {
            sb.append("</html>");
            return sb.toString();
        }
        sb.append("<br>nomad: ").append(QuantityFormatter.quantityToStackSize(gePrice));
        if (quantity > 1) {
            sb.append(" (").append(QuantityFormatter.quantityToStackSize(item.getGePrice())).append(" ea)");
        }
        if (item.getId() == 13204) {
            sb.append("</html>");
            return sb.toString();
        }
        sb.append("<br>HA: ").append(QuantityFormatter.quantityToStackSize(haPrice));
        if (quantity > 1) {
            sb.append(" (").append(QuantityFormatter.quantityToStackSize(item.getHaPrice())).append(" ea)");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private static String replace(String text, String replace, String replaceWith) {
        if (text.contains(replace)) {
            return text.replaceAll(replace, replaceWith);
        }
        return text;
    }

    public static String handleOldSyntax(String text) {
        if (text.contains("@")) {
            text = text.replace("@pur@", "<span style='color: #A10081;'>");
            text = text.replace("@red@", "<span style='color: #FF0000;'>");
            text = text.replace("@gre@", "<span style='color: #65280;'>");
            text = text.replace("@blu@", "<span style='color: #0000FF;'>");
            text = text.replace("@bl2@", "<span style='color: #0F0085;'>");
            text = text.replace("@bl3@", "<span style='color: #00AFFF;'>");
            text = text.replace("@yel@", "<span style='color: #FFFF00;'>");
            text = text.replace("@cya@", "<span style='color: #00FFFF;'>");
            text = text.replace("@mag@", "<span style='color: #FF00FF;'>");
            text = text.replace("@whi@", "<span style='color: #FFFFFF;'>");
            text = text.replace("@lre@", "<span style='color: #FF9040;'>");
            text = text.replace("@dre@", "<span style='color: #800000;'>");
            text = text.replace("@bla@", "<span style='color: #000000;'>");
            text = text.replace("@or0@", "<span style='color: #A67711;'>");
            text = text.replace("@or1@", "<span style='color: #FFB000;'>");
            text = text.replace("@or2@", "<span style='color: #FF7000;'>");
            text = text.replace("@or3@", "<span style='color: #FF3000;'>");
            text = text.replace("@or4@", "<span style='color: #FF9933;'>");
            text = text.replace("@gr0@", "<span style='color: #148200;'>");
            text = text.replace("@gr1@", "<span style='color: #C0FF00;'>");
            text = text.replace("@gr2@", "<span style='color: #80FF00;'>");
            text = text.replace("@gr3@", "<span style='color: #40FF00;'>");
            text = text.replace("@OR0@", "<span style='color: #A67711;'>");
            text = text.replace("@PUR@", "<span style='color: #A10081;'>");
            text = text.replace("@RED@", "<span style='color: #FF0000;'>");
            text = text.replace("@GRE@", "<span style='color: #65280;'>");
            text = text.replace("@BLU@", "<span style='color: #0000FF;'>");
            text = text.replace("@YEL@", "<span style='color: #FFFF00;'>");
            text = text.replace("@CYA@", "<span style='color: #00FFFF;'>");
            text = text.replace("@MAG@", "<span style='color: #FF00FF;'>");
            text = text.replace("@WHI@", "<span style='color: #FFFFFF;'>");
            text = text.replace("@LRE@", "<span style='color: #FF9040;'>");
            text = text.replace("@DRE@", "<span style='color: #800000;'>");
            text = text.replace("@BLA@", "<span style='color: #000000;'>");
            text = text.replace("@OR1@", "<span style='color: #FFB000;'>");
            text = text.replace("@OR2@", "<span style='color: #FF7000;'>");
            text = text.replace("@OR3@", "<span style='color: #FF3000;'>");
            text = text.replace("@GR1@", "<span style='color: #C0FF00;'>");
            text = text.replace("@GR2@", "<span style='color: #80FF00;'>");
            text = text.replace("@GR3@", "<span style='color: #40FF00;'>");
        }
        return text;
    }

    String getId() {
        return this.id;
    }

    public List<LootTrackerItem> getItems() {
        return this.items;
    }
}

