/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.keyremapping;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.VarClientInt;
import net.runelite.api.VarClientStr;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.keyremapping.KeyRemappingConfig;
import net.runelite.client.plugins.keyremapping.KeyRemappingListener;

@PluginDescriptor(name="Key Remapping", description="Allows use of WASD keys for camera movement with 'Press Enter to Chat', and remapping number keys to F-keys", tags={"enter", "chat", "wasd", "camera"}, enabledByDefault=false)
public class KeyRemappingPlugin
extends Plugin {
    private static final String PRESS_ENTER_TO_CHAT = "Press Enter to Chat...";
    private static final String SCRIPT_EVENT_SET_CHATBOX_INPUT = "setChatboxInput";
    private static final String SCRIPT_EVENT_BLOCK_CHAT_INPUT = "blockChatInput";
    public static KeyRemappingPlugin instance;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeyManager keyManager;
    @Inject
    private KeyRemappingListener inputListener;
    private boolean typing;

    @Override
    protected void startUp() throws Exception {
        this.typing = false;
        this.keyManager.registerKeyListener(this.inputListener);
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.lockChat();
                this.client.setVar(VarClientStr.CHATBOX_TYPED_TEXT, "");
            }
        });
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.unlockChat();
            }
        });
        this.keyManager.unregisterKeyListener(this.inputListener);
    }

    @Provides
    KeyRemappingConfig getConfig(ConfigManager configManager) {
        return configManager.getConfig(KeyRemappingConfig.class);
    }

    boolean chatboxFocused() {
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent == null || chatboxParent.getOnKeyListener() == null) {
            return false;
        }
        Widget worldMapSearch = this.client.getWidget(WidgetInfo.WORLD_MAP_SEARCH);
        return worldMapSearch == null || this.client.getVar(VarClientInt.WORLD_MAP_SEARCH_FOCUSED) != 1;
    }

    boolean isDialogOpen() {
        return this.client.getChatboxInterface() != null;
    }

    boolean isOptionsDialogOpen() {
        return this.client.getChatboxInterface() != null;
    }

    private boolean isHidden(WidgetInfo widgetInfo) {
        Widget w = this.client.getWidget(widgetInfo);
        return w == null || w.isSelfHidden();
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        switch (scriptCallbackEvent.getEventName()) {
            case "setChatboxInput": {
                Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
                if (chatboxInput == null || this.typing) break;
                this.setChatboxWidgetInput(chatboxInput, PRESS_ENTER_TO_CHAT);
                break;
            }
            case "blockChatInput": {
                if (this.typing) break;
                int[] intStack = this.client.getIntStack();
                int intStackSize = this.client.getIntStackSize();
                intStack[intStackSize - 1] = 1;
            }
        }
    }

    void lockChat() {
        this.client.setChatboxLocked(true);
    }

    void unlockChat() {
        this.client.setChatboxLocked(false);
    }

    private void setChatboxWidgetInput(Widget widget, String input) {
        String text = widget.getText();
        int idx = text.indexOf(58);
        if (idx != -1) {
            String newText = text.substring(0, idx) + ": " + input;
            widget.setText(newText);
        }
    }

    boolean isTyping() {
        return this.typing;
    }

    void setTyping(boolean typing) {
        this.typing = typing;
    }
}

