/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils.buffer;

import java.nio.IntBuffer;
import org.lwjgl.system.MemoryUtil;

public class GpuIntBuffer {
    private IntBuffer buffer;

    public GpuIntBuffer() {
        this(65536);
    }

    public GpuIntBuffer(int initialCapacity) {
        this.buffer = MemoryUtil.memAllocInt(initialCapacity);
    }

    public void destroy() {
        if (this.buffer != null) {
            MemoryUtil.memFree(this.buffer);
        }
        this.buffer = null;
    }

    public void put(int x, int y, int z) {
        this.buffer.put(x).put(y).put(z);
    }

    public void put(int x, int y, int z, int w) {
        this.buffer.put(x).put(y).put(z).put(w);
    }

    public void put(int[] ints) {
        this.buffer.put(ints);
    }

    public void put(IntBuffer buffer) {
        this.buffer.put(buffer);
    }

    public int position() {
        return this.buffer.position();
    }

    public void flip() {
        this.buffer.flip();
    }

    public void clear() {
        this.buffer.clear();
    }

    public GpuIntBuffer ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity *= 2) - position < size) {
            }
            IntBuffer newB = MemoryUtil.memAllocInt(capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            MemoryUtil.memFree(this.buffer);
            this.buffer = newB;
        }
        return this;
    }

    public IntBuffer getBuffer() {
        return this.buffer;
    }
}

