/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.grandexchange;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Type;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuEntry;
import net.runelite.api.WorldType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.Notifier;
import net.runelite.client.account.SessionManager;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grandexchange.GrandExchangeConfig;
import net.runelite.client.plugins.grandexchange.GrandExchangeInputListener;
import net.runelite.client.plugins.grandexchange.GrandExchangePanel;
import net.runelite.client.plugins.grandexchange.SavedOffer;
import net.runelite.client.plugins.grandexchange.Trade;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.OSType;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.ge.GrandExchangeTrade;
import org.apache.commons.text.similarity.FuzzyScore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Grand Exchange", description="Provide additional and/or easier access to Grand Exchange information", tags={"external", "integration", "notifications", "panel", "prices", "trade"})
public class GrandExchangePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GrandExchangePlugin.class);
    @VisibleForTesting
    static final int GE_SLOTS = 8;
    private static final int GE_LOGIN_BURST_WINDOW = 2;
    private static final int GE_MAX_EXAMINE_LEN = 100;
    private static final String BUY_LIMIT_GE_TEXT = "Buy limit: ";
    private static final String BUY_LIMIT_KEY = "buylimit";
    private static final Duration BUY_LIMIT_RESET = Duration.ofHours(4L);
    static final String SEARCH_GRAND_EXCHANGE = "Search Grand Exchange";
    private static final int MAX_RESULT_COUNT = 250;
    private static final FuzzyScore FUZZY = new FuzzyScore(Locale.ENGLISH);
    private static final Color FUZZY_HIGHLIGHT_COLOR = new Color(0x800000);
    private static final int MAX_TRADE_HISTORY = 1024;
    private static final int MAX_TRADE_DAYS = 365;
    private NavigationButton button;
    private GrandExchangePanel panel;
    private boolean hotKeyPressed;
    @Inject
    private GrandExchangeInputListener inputListener;
    @Inject
    private ItemManager itemManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private GrandExchangeConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ScheduledExecutorService scheduledExecutorService;
    private int lastLoginTick;
    private boolean wasFuzzySearch;
    private String machineUuid;
    private long lastAccount;
    private int tradeSeq;

    @VisibleForTesting
    static List<Integer> findFuzzyIndices(String term, String query) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        String termLowerCase = term.toLowerCase();
        String queryLowerCase = query.toLowerCase();
        int termIndex = 0;
        for (int queryIndex = 0; queryIndex < queryLowerCase.length(); ++queryIndex) {
            char queryChar = queryLowerCase.charAt(queryIndex);
            boolean termCharacterMatchFound = false;
            while (termIndex < termLowerCase.length() && !termCharacterMatchFound) {
                char termChar = termLowerCase.charAt(termIndex);
                if (queryChar == termChar) {
                    indices.add(termIndex);
                    termCharacterMatchFound = true;
                }
                ++termIndex;
            }
        }
        return indices;
    }

    private SavedOffer getOffer(int slot) {
        String offer = this.configManager.getRSProfileConfiguration("geoffer", Integer.toString(slot));
        if (offer == null) {
            return null;
        }
        return this.gson.fromJson(offer, SavedOffer.class);
    }

    private void setOffer(int slot, SavedOffer offer) {
        this.configManager.setRSProfileConfiguration("geoffer", Integer.toString(slot), this.gson.toJson(offer));
    }

    private void deleteOffer(int slot) {
        this.configManager.unsetRSProfileConfiguration("geoffer", Integer.toString(slot));
    }

    private synchronized void saveTrade(Trade trade) {
        List trades = new ArrayList<Trade>();
        String history = this.configManager.getRSProfileConfiguration("grandexchange", "tradeHistory");
        Type type2 = new TypeToken<List<Trade>>(){}.getType();
        if (history != null) {
            try {
                List t = (List)this.gson.fromJson(history, type2);
                if (t != null) {
                    trades = t;
                }
            }
            catch (JsonSyntaxException ex) {
                log.warn("error updating saved trades", ex);
            }
        }
        Instant ago = Instant.now().minus(365L, ChronoUnit.DAYS);
        while (!trades.isEmpty() && (trades.size() >= 1024 || ((Trade)trades.get((int)0)).time.isBefore(ago))) {
            trades.remove(0);
        }
        trades.add(trade);
        this.configManager.setRSProfileConfiguration("grandexchange", "tradeHistory", this.gson.toJson(trades, type2));
    }

    @Provides
    GrandExchangeConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(GrandExchangeConfig.class);
    }

    @Override
    protected void startUp() {
        this.panel = this.injector.getInstance(GrandExchangePanel.class);
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), "ge_icon.png");
        this.button = NavigationButton.builder().tooltip("Grand Exchange").icon(icon).priority(3).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.button);
        if (this.config.quickLookup()) {
            this.mouseManager.registerMouseListener(this.inputListener);
            this.keyManager.registerKeyListener(this.inputListener);
        }
        this.lastLoginTick = -1;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            GrandExchangeOffer[] offers = this.client.getGrandExchangeOffers();
            for (int i = 0; i < offers.length; ++i) {
                int slot = i;
                this.clientThread.invokeLater(() -> this.updatePanel(slot, offers[slot]));
                this.updateConfig(i, offers[i]);
            }
        }
    }

    @Override
    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.button);
        this.mouseManager.unregisterMouseListener(this.inputListener);
        this.keyManager.unregisterKeyListener(this.inputListener);
        this.machineUuid = null;
        this.lastAccount = -1L;
        this.tradeSeq = 0;
    }

    void search(String itemName) {
        SwingUtilities.invokeLater(() -> {
            this.panel.showSearch();
            this.clientToolbar.openPanel(this.button);
            this.panel.getSearchPanel().priceLookup(itemName);
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("grandexchange") && event.getKey().equals("quickLookup")) {
            if (this.config.quickLookup()) {
                this.mouseManager.registerMouseListener(this.inputListener);
                this.keyManager.registerKeyListener(this.inputListener);
            } else {
                this.mouseManager.unregisterMouseListener(this.inputListener);
                this.keyManager.unregisterKeyListener(this.inputListener);
            }
        }
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged offerEvent) {
        int slot = offerEvent.getSlot();
        GrandExchangeOffer offer = offerEvent.getOffer();
        if (offer.getState() == GrandExchangeOfferState.EMPTY && this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        log.debug("GE offer updated: state: {}, slot: {}, item: {}, qty: {}, lastLoginTick: {}", new Object[]{offer.getState(), slot, offer.getItemId(), offer.getQuantitySold(), this.lastLoginTick});
        this.updatePanel(slot, offer);
        this.updateLimitTimer(offer);
        this.submitTrade(slot, offer);
        this.updateConfig(slot, offer);
    }

    @VisibleForTesting
    void submitTrade(int slot, GrandExchangeOffer offer) {
        boolean login;
        GrandExchangeOfferState state = offer.getState();
        if (state != GrandExchangeOfferState.CANCELLED_BUY && state != GrandExchangeOfferState.CANCELLED_SELL && state != GrandExchangeOfferState.BUYING && state != GrandExchangeOfferState.SELLING) {
            return;
        }
        SavedOffer savedOffer = this.getOffer(slot);
        boolean bl = login = this.client.getTickCount() <= this.lastLoginTick + 2;
        if (savedOffer == null && (state == GrandExchangeOfferState.BUYING || state == GrandExchangeOfferState.SELLING) && offer.getQuantitySold() == 0) {
            GrandExchangeTrade grandExchangeTrade = new GrandExchangeTrade();
            grandExchangeTrade.setBuy(state == GrandExchangeOfferState.BUYING);
            grandExchangeTrade.setItemId(offer.getItemId());
            grandExchangeTrade.setTotal(offer.getTotalQuantity());
            grandExchangeTrade.setOffer(offer.getPrice());
            grandExchangeTrade.setSlot(slot);
            grandExchangeTrade.setWorldType(this.getGeWorldType());
            grandExchangeTrade.setLogin(login);
            grandExchangeTrade.setSeq(this.tradeSeq++);
            grandExchangeTrade.setResetTime(this.getLimitResetTime(offer.getItemId()));
            log.debug("Submitting new trade: {}", (Object)grandExchangeTrade);
            return;
        }
        if (savedOffer == null || savedOffer.getItemId() != offer.getItemId() || savedOffer.getPrice() != offer.getPrice() || savedOffer.getTotalQuantity() != offer.getTotalQuantity()) {
            return;
        }
        if (savedOffer.getState() == offer.getState() && savedOffer.getQuantitySold() == offer.getQuantitySold()) {
            return;
        }
        if (state == GrandExchangeOfferState.CANCELLED_BUY || state == GrandExchangeOfferState.CANCELLED_SELL) {
            GrandExchangeTrade grandExchangeTrade = new GrandExchangeTrade();
            grandExchangeTrade.setBuy(state == GrandExchangeOfferState.CANCELLED_BUY);
            grandExchangeTrade.setCancel(true);
            grandExchangeTrade.setItemId(offer.getItemId());
            grandExchangeTrade.setQty(offer.getQuantitySold());
            grandExchangeTrade.setTotal(offer.getTotalQuantity());
            grandExchangeTrade.setOffer(offer.getPrice());
            grandExchangeTrade.setSlot(slot);
            grandExchangeTrade.setWorldType(this.getGeWorldType());
            grandExchangeTrade.setLogin(login);
            grandExchangeTrade.setSeq(this.tradeSeq++);
            grandExchangeTrade.setResetTime(this.getLimitResetTime(offer.getItemId()));
            log.debug("Submitting cancelled: {}", (Object)grandExchangeTrade);
            this.saveTrade(grandExchangeTrade);
            return;
        }
        int qty = offer.getQuantitySold() - savedOffer.getQuantitySold();
        if (qty <= 0) {
            return;
        }
        GrandExchangeTrade grandExchangeTrade = new GrandExchangeTrade();
        grandExchangeTrade.setBuy(state == GrandExchangeOfferState.BUYING);
        grandExchangeTrade.setItemId(offer.getItemId());
        grandExchangeTrade.setQty(offer.getQuantitySold());
        grandExchangeTrade.setDqty(qty);
        grandExchangeTrade.setTotal(offer.getTotalQuantity());
        grandExchangeTrade.setOffer(offer.getPrice());
        grandExchangeTrade.setSlot(slot);
        grandExchangeTrade.setWorldType(this.getGeWorldType());
        grandExchangeTrade.setLogin(login);
        grandExchangeTrade.setSeq(this.tradeSeq++);
        grandExchangeTrade.setResetTime(this.getLimitResetTime(offer.getItemId()));
        this.saveTrade(grandExchangeTrade);
    }

    private void saveTrade(GrandExchangeTrade trade) {
        if (trade.getQty() > 0 && (trade.isCancel() || trade.getQty() == trade.getTotal())) {
            Trade t = new Trade();
            t.setBuy(trade.isBuy());
            t.setItemId(trade.getItemId());
            t.setQuantity(trade.getQty());
            t.setPrice(trade.getSpent() / trade.getQty());
            t.setTime(Instant.now());
            log.debug("Saving trade: {}", (Object)t);
            this.scheduledExecutorService.execute(() -> this.saveTrade(t));
        }
    }

    private net.runelite.http.api.worlds.WorldType getGeWorldType() {
        EnumSet<WorldType> worldTypes = this.client.getWorldType();
        if (worldTypes.contains((Object)WorldType.SEASONAL)) {
            return net.runelite.http.api.worlds.WorldType.SEASONAL;
        }
        if (worldTypes.contains((Object)WorldType.TOURNAMENT_WORLD)) {
            return net.runelite.http.api.worlds.WorldType.TOURNAMENT;
        }
        if (worldTypes.contains((Object)WorldType.DEADMAN)) {
            return net.runelite.http.api.worlds.WorldType.DEADMAN;
        }
        return net.runelite.http.api.worlds.WorldType.MEMBERS;
    }

    private void updatePanel(int slot, GrandExchangeOffer offer) {
        ItemComposition offerItem = this.itemManager.getItemComposition(offer.getItemId());
        boolean shouldStack = offerItem.isStackable() || offer.getTotalQuantity() > 1;
        AsyncBufferedImage itemImage = this.itemManager.getImage(offer.getItemId(), offer.getTotalQuantity(), shouldStack);
        SwingUtilities.invokeLater(() -> this.panel.getOffersPanel().updateOffer(offerItem, itemImage, offer, slot));
    }

    private void updateConfig(int slot, GrandExchangeOffer offer) {
        if (offer.getState() == GrandExchangeOfferState.EMPTY) {
            this.deleteOffer(slot);
        } else {
            SavedOffer savedOffer = new SavedOffer();
            savedOffer.setItemId(offer.getItemId());
            savedOffer.setQuantitySold(offer.getQuantitySold());
            savedOffer.setTotalQuantity(offer.getTotalQuantity());
            savedOffer.setPrice(offer.getPrice());
            savedOffer.setState(offer.getState());
            this.setOffer(slot, savedOffer);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = Text.removeTags(event.getMessage());
        if (message.startsWith("Grand Exchange:") && this.config.enableNotifications()) {
            this.notifier.notify(message);
        } else if (message.startsWith("Grand Exchange: Finished") && this.config.notifyOnOfferComplete()) {
            this.notifier.notify(message);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOGIN_SCREEN: {
                this.panel.getOffersPanel().resetOffers();
                break;
            }
            case LOGGING_IN: 
            case HOPPING: 
            case CONNECTION_LOST: {
                this.lastLoginTick = this.client.getTickCount();
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.hotKeyPressed) {
            return;
        }
        MenuEntry[] entries2 = this.client.getMenuEntries();
        MenuEntry menuEntry = entries2[entries2.length - 1];
        int widgetId = menuEntry.getParam1();
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.setHotKeyPressed(false);
        }
    }

    private void setGeTitle() {
        GrandExchangeOffer[] offers;
        if (!this.config.showTotal()) {
            return;
        }
        long total = 0L;
        for (GrandExchangeOffer offer : offers = this.client.getGrandExchangeOffers()) {
            if (offer == null) continue;
            total += (long)(offer.getPrice() * offer.getTotalQuantity());
        }
        if (total == 0L) {
            return;
        }
        StringBuilder titleBuilder = new StringBuilder(" (");
        if (this.config.showExact()) {
            titleBuilder.append(QuantityFormatter.formatNumber(total));
        } else {
            titleBuilder.append(QuantityFormatter.quantityToStackSize(total));
        }
        titleBuilder.append(')');
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int n = stringStackSize - 1;
        stringStack[n] = stringStack[n] + titleBuilder.toString();
    }

    private void setLimitResetTime(int itemId) {
        Instant lastDateTime = (Instant)this.configManager.getRSProfileConfiguration("grandexchange", "buylimit." + itemId, (Type)((Object)Instant.class));
        if (lastDateTime == null || lastDateTime.isBefore(Instant.now())) {
            this.configManager.setRSProfileConfiguration("grandexchange", "buylimit." + itemId, Instant.now().plus(BUY_LIMIT_RESET));
        }
    }

    private Instant getLimitResetTime(int itemId) {
        Instant lastDateTime = (Instant)this.configManager.getRSProfileConfiguration("grandexchange", "buylimit." + itemId, (Type)((Object)Instant.class));
        if (lastDateTime == null) {
            return null;
        }
        if (lastDateTime.isBefore(Instant.now())) {
            this.configManager.unsetRSProfileConfiguration("grandexchange", "buylimit." + itemId);
            return null;
        }
        return lastDateTime;
    }

    private void updateLimitTimer(GrandExchangeOffer offer) {
        if (offer.getState() == GrandExchangeOfferState.BOUGHT || offer.getQuantitySold() > 0 && offer.getState() == GrandExchangeOfferState.BUYING) {
            this.setLimitResetTime(offer.getItemId());
        }
    }

    private static String shortenExamine(String examine) {
        int from = 0;
        while (true) {
            int idx;
            if ((idx = examine.indexOf(32, from)) == -1) {
                return examine;
            }
            if (idx > 100 && from > 0) break;
            from = idx + 1;
        }
        return examine.substring(0, from - 1) + "...";
    }

    void openGeLink(String name, int itemId) {
        String url = this.runeLiteConfig.useWikiItemPrices() ? "https://prices.runescape.wiki/osrs/item/" + itemId : "https://services.runescape.com/m=itemdb_oldschool/" + name.replaceAll(" ", "+") + "/viewitem?obj=" + itemId;
        LinkBrowser.browse(url);
    }

    private String getMachineUuid() {
        long accountHash = this.client.getAccountHash();
        if (this.lastAccount == accountHash) {
            return this.machineUuid;
        }
        this.lastAccount = accountHash;
        try {
            Hasher hasher = Hashing.sha256().newHasher();
            Runtime runtime = Runtime.getRuntime();
            hasher.putByte((byte)OSType.getOSType().ordinal());
            hasher.putByte((byte)runtime.availableProcessors());
            hasher.putUnencodedChars(System.getProperty("os.arch", ""));
            hasher.putUnencodedChars(System.getProperty("os.version", ""));
            hasher.putUnencodedChars(System.getProperty("user.name", ""));
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (hardwareAddress == null) continue;
                hasher.putBytes(hardwareAddress);
            }
            hasher.putLong(accountHash);
            this.machineUuid = hasher.hash().toString();
            this.tradeSeq = 0;
            return this.machineUuid;
        }
        catch (SocketException ex) {
            log.debug("unable to generate machine id", ex);
            this.machineUuid = null;
            this.tradeSeq = 0;
            return null;
        }
    }

    void setPanel(GrandExchangePanel panel) {
        this.panel = panel;
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }
}

