/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.camerasmoothing;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.BeforeRender;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.camerasmoothing.CameraSmoothingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Camera Smoothing", enabledByDefault=false)
public class CameraSmoothingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CameraSmoothingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CameraSmoothingConfig config;
    @Inject
    private ClientThread clientThread;
    private final int HALF_ROTATION = 1024;
    private final int FULL_ROTATION = 2048;
    private final int PITCH_INDEX = 0;
    private final int YAW_INDEX = 1;
    private final int SCROLL_INDEX = 2;
    private int[] deltaCamera = new int[3];
    private int[] previousCamera = new int[3];

    private int lerp(int x, int y, float alpha) {
        return x + (int)((float)(y - x) * alpha);
    }

    private int getSmallestAngle(int x, int y) {
        return this.mod(y - x + 1024, 2048) - 1024;
    }

    public int mod(int a, int n) {
        return (int)((double)a - Math.floor((float)a / (float)n) * (double)n);
    }

    private void applySmoothingToAngle(int index) {
        int newDeltaAngle = this.getSmallestAngle(this.previousCamera[index], index == 1 ? this.client.getMapAngle() : 0);
        int n = index;
        this.deltaCamera[n] = this.deltaCamera[n] + newDeltaAngle;
        int deltaChange = this.lerp(this.deltaCamera[index], 0, (float)this.config.smoothness() / 100.0f);
        int changed = this.previousCamera[index] + deltaChange;
        int n2 = index;
        this.deltaCamera[n2] = this.deltaCamera[n2] - deltaChange;
        if (index == 1) {
            this.client.setCameraYawTarget(changed);
        }
        int n3 = index;
        this.previousCamera[n3] = this.previousCamera[n3] + deltaChange;
    }

    private void setZoom(int amount) {
        this.client.set3dZoom(amount);
    }

    private void applySmoothingToZoom(int index) {
        int newZoom = this.client.get3dZoom() - this.previousCamera[index];
        int n = index;
        this.deltaCamera[n] = this.deltaCamera[n] + newZoom;
        int deltaChange = this.lerp(this.deltaCamera[index], 0, Math.max(0.0f, Math.min(1.0f, (float)this.config.smoothness() / 100.0f)));
        int changed = this.previousCamera[index] + deltaChange;
        int n2 = index;
        this.deltaCamera[n2] = this.deltaCamera[n2] - deltaChange;
        if (index == 2) {
            this.setZoom(changed);
        }
        int n3 = index;
        this.previousCamera[n3] = this.previousCamera[n3] + deltaChange;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged ev) {
        if (ev.getKey().equals("smoothRotation")) {
            if (this.config.smoothRotation()) {
                this.previousCamera[1] = this.client.getMapAngle();
            }
        } else if (ev.getKey().equals("smoothZoom") && this.config.smoothZoom()) {
            this.previousCamera[2] = this.client.get3dZoom();
        }
    }

    @Subscribe
    public void onBeforeRender(BeforeRender render2) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.config.smoothRotation()) {
            this.applySmoothingToAngle(1);
        }
        if (this.config.smoothZoom()) {
            this.applySmoothingToZoom(2);
        }
    }

    @Provides
    CameraSmoothingConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(CameraSmoothingConfig.class);
    }
}

