/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.animationtransmog.effect;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DatabaseManager {
    OkHttpClient client;

    public DatabaseManager(OkHttpClient client) {
        this.client = client;
    }

    public void getSettings(String playerName, final Consumer<HashMap<String, String>> callback) {
        final HashMap newSettings = new HashMap();
        Request request = new Request.Builder().url("https://runelite-animation-transmog-default-rtdb.firebaseio.com/players/" + playerName.replace(" ", "+") + ".json").addHeader("Content-Type", "application/json").build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                e.printStackTrace();
            }

            @Override
            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                ResponseBody body = response.body();
                if (body == null) {
                    return;
                }
                String bodyString = body.string();
                if (!bodyString.equals("null")) {
                    String[] responseStringList;
                    String responseString = bodyString.substring(1, bodyString.length() - 1);
                    for (String keyVal : responseStringList = responseString.split(",")) {
                        String[] keyValList = keyVal.split(":");
                        String key = keyValList[0].substring(1, keyValList[0].length() - 1);
                        String value = keyValList[1].substring(1, keyValList[1].length() - 1);
                        if (key.equals("lastUpdated")) continue;
                        newSettings.put(key, value);
                    }
                }
                body.close();
                callback.accept(newSettings);
            }
        });
    }

    public void setSettings(String playerName, HashMap<String, String> newSettings) {
        StringBuilder result2 = new StringBuilder();
        result2.append("{");
        for (Map.Entry<String, String> entry : newSettings.entrySet()) {
            result2.append('\"').append(entry.getKey()).append('\"').append(":").append('\"').append(entry.getValue()).append('\"').append(",");
        }
        result2.append('\"').append("lastUpdated").append('\"').append(":").append('\"').append(new Timestamp(System.currentTimeMillis()).toInstant()).append('\"').append("}");
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, result2.toString());
        Request request = new Request.Builder().url("https://runelite-animation-transmog-default-rtdb.firebaseio.com/players/" + playerName.replace(" ", "+") + ".json?print=silent").put(body).addHeader("Content-Type", "application/json").build();
        this.client.newCall(request).enqueue(new Callback(){

            @Override
            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                e.printStackTrace();
            }

            @Override
            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                response.close();
            }
        });
    }
}

