/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.List;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderOptimized;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.KotlinMetadataFinder;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeserializedPackageFragmentProvider
implements PackageFragmentProviderOptimized {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final KotlinMetadataFinder finder;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    protected DeserializationComponents components;
    @NotNull
    private final MemoizedFunctionToNullable<FqName, PackageFragmentDescriptor> fragments;

    public AbstractDeserializedPackageFragmentProvider(@NotNull StorageManager storageManager, @NotNull KotlinMetadataFinder finder, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(finder, "finder");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        this.storageManager = storageManager;
        this.finder = finder;
        this.moduleDescriptor = moduleDescriptor;
        this.fragments = this.storageManager.createMemoizedFunctionWithNullableValues((Function1)new Function1<FqName, PackageFragmentDescriptor>(this){
            final /* synthetic */ AbstractDeserializedPackageFragmentProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final PackageFragmentDescriptor invoke(@NotNull FqName fqName2) {
                DeserializedPackageFragment deserializedPackageFragment;
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                DeserializedPackageFragment deserializedPackageFragment2 = this.this$0.findPackage(fqName2);
                if (deserializedPackageFragment2 == null) {
                    deserializedPackageFragment = null;
                } else {
                    DeserializedPackageFragment deserializedPackageFragment3 = deserializedPackageFragment2;
                    AbstractDeserializedPackageFragmentProvider abstractDeserializedPackageFragmentProvider = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    DeserializedPackageFragment $this$invoke_u24lambda_u2d0 = deserializedPackageFragment3;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u2d0.initialize(abstractDeserializedPackageFragmentProvider.getComponents());
                    deserializedPackageFragment = deserializedPackageFragment3;
                }
                return deserializedPackageFragment;
            }
        });
    }

    @NotNull
    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    protected final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    @NotNull
    protected final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    protected final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents != null) {
            return deserializationComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        throw null;
    }

    protected final void setComponents(@NotNull DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter(deserializationComponents, "<set-?>");
        this.components = deserializationComponents;
    }

    @Nullable
    protected abstract DeserializedPackageFragment findPackage(@NotNull FqName var1);

    @Override
    public void collectPackageFragments(@NotNull FqName fqName2, @NotNull Collection<PackageFragmentDescriptor> packageFragments2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(packageFragments2, "packageFragments");
        CollectionsKt.addIfNotNull(packageFragments2, this.fragments.invoke(fqName2));
    }

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return kotlin.collections.CollectionsKt.listOfNotNull(this.fragments.invoke(fqName2));
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return SetsKt.emptySet();
    }
}

