/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableAmb<T>
extends Observable<T> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;

    public ObservableAmb(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count2 = 0;
        if (sources == null) {
            sources = new ObservableSource[8];
            try {
                for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                    if (observableSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                        return;
                    }
                    if (count2 == sources.length) {
                        ObservableSource[] b = new ObservableSource[count2 + (count2 >> 2)];
                        System.arraycopy(sources, 0, b, 0, count2);
                        sources = b;
                    }
                    sources[count2++] = observableSource;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, observer);
                return;
            }
        } else {
            count2 = sources.length;
        }
        if (count2 == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        if (count2 == 1) {
            sources[0].subscribe(observer);
            return;
        }
        AmbCoordinator<? extends T> ac = new AmbCoordinator<T>(observer, count2);
        ac.subscribe(sources);
    }

    static final class AmbInnerObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T> {
        private static final long serialVersionUID = -1185974347409665484L;
        final AmbCoordinator<T> parent;
        final int index;
        final Observer<? super T> downstream;
        boolean won;

        AmbInnerObserver(AmbCoordinator<T> parent, int index, Observer<? super T> downstream) {
            this.parent = parent;
            this.index = index;
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onNext(T t) {
            if (this.won) {
                this.downstream.onNext(t);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onNext(t);
            } else {
                ((Disposable)this.get()).dispose();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.won) {
                this.downstream.onError(t);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.won) {
                this.downstream.onComplete();
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.downstream.onComplete();
            }
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class AmbCoordinator<T>
    implements Disposable {
        final Observer<? super T> downstream;
        final AmbInnerObserver<T>[] observers;
        final AtomicInteger winner = new AtomicInteger();

        AmbCoordinator(Observer<? super T> actual, int count2) {
            this.downstream = actual;
            this.observers = new AmbInnerObserver[count2];
        }

        public void subscribe(ObservableSource<? extends T>[] sources) {
            int i;
            AmbInnerObserver<T>[] as = this.observers;
            int len = as.length;
            for (i = 0; i < len; ++i) {
                as[i] = new AmbInnerObserver<T>(this, i + 1, this.downstream);
            }
            this.winner.lazySet(0);
            this.downstream.onSubscribe(this);
            for (i = 0; i < len; ++i) {
                if (this.winner.get() != 0) {
                    return;
                }
                sources[i].subscribe(as[i]);
            }
        }

        public boolean win(int index) {
            int w = this.winner.get();
            if (w == 0 && this.winner.compareAndSet(0, index)) {
                AmbInnerObserver<T>[] a = this.observers;
                int n = a.length;
                for (int i = 0; i < n; ++i) {
                    if (i + 1 == index) continue;
                    a[i].dispose();
                }
                return true;
            }
            return false;
        }

        @Override
        public void dispose() {
            if (this.winner.get() != -1) {
                this.winner.lazySet(-1);
                for (AmbInnerObserver<T> a : this.observers) {
                    a.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.winner.get() == -1;
        }
    }
}

