/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache;

import com.displee.cache.CacheLibrary;
import com.displee.cache.ProgressListener;
import com.displee.cache.index.Index;
import com.displee.cache.index.Index255;
import com.displee.cache.index.Index317;
import com.displee.cache.index.ReferenceTable;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.ArchiveSector;
import com.displee.cache.index.archive.file.File;
import com.displee.compress.CompressionType;
import com.displee.io.Buffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0001QB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\b\u0002\u0010&\u001a\u00020\u0005JX\u0010$\u001a\u00020\u00182\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020\u00172\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u00052\b\b\u0002\u0010.\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u0005H\u0007J0\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\b\b\u0002\u00102\u001a\u00020\u00172\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J.\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00032\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J.\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00172\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J&\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J.\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J\u0006\u00105\u001a\u00020#J\u000e\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0017J\b\u00108\u001a\u0004\u0018\u00010\u0018J\u000e\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0005J*\u0010;\u001a\u0002002\b\b\u0002\u0010<\u001a\u00020\u00052\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010>H\u0007J\u000e\u0010%\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u0017J\u0011\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00180@\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020#H\u0002J\u0006\u0010C\u001a\u00020\u0005J\u0006\u0010D\u001a\u00020\u0005J\u0006\u0010E\u001a\u00020\u0005J\b\u0010F\u001a\u0004\u0018\u00010\u0018J\b\u0010G\u001a\u00020#H\u0002J\b\u0010H\u001a\u00020#H\u0002J,\u0010I\u001a\u00020J2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J4\u0010I\u001a\u00020K2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J4\u0010I\u001a\u00020K2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J,\u0010I\u001a\u00020J2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J4\u0010I\u001a\u00020K2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0007J\u000e\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020#J\u0018\u0010P\u001a\u0004\u0018\u00010J2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0017J \u0010P\u001a\u0004\u0018\u00010K2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0017J \u0010P\u001a\u0004\u0018\u00010K2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0003J\u0018\u0010P\u001a\u0004\u0018\u00010J2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0003J \u0010P\u001a\u0004\u0018\u00010K2\u0006\u0010%\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\u0006\u0010:\u001a\u00020#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/displee/cache/CacheLibrary;", "", "path", "", "clearDataAfterUpdate", "", "listener", "Lcom/displee/cache/ProgressListener;", "(Ljava/lang/String;ZLcom/displee/cache/ProgressListener;)V", "getClearDataAfterUpdate", "()Z", "closed", "getClosed", "setClosed", "(Z)V", "index255", "Lcom/displee/cache/index/Index255;", "getIndex255", "()Lcom/displee/cache/index/Index255;", "setIndex255", "(Lcom/displee/cache/index/Index255;)V", "indices", "Ljava/util/SortedMap;", "", "Lcom/displee/cache/index/Index;", "mainFile", "Ljava/io/RandomAccessFile;", "getMainFile", "()Ljava/io/RandomAccessFile;", "setMainFile", "(Ljava/io/RandomAccessFile;)V", "getPath", "()Ljava/lang/String;", "rs3", "close", "", "createIndex", "index", "writeReferenceTable", "compressionType", "Lcom/displee/compress/CompressionType;", "version", "revision", "named", "whirlpool", "flag4", "flag8", "data", "", "archive", "file", "xtea", "", "deleteLastIndex", "exists", "id", "first", "fixCrcs", "update", "generateUkeys", "writeWhirlpool", "exponent", "Ljava/math/BigInteger;", "modulus", "", "()[Lcom/displee/cache/index/Index;", "init", "is317", "isOSRS", "isRS3", "last", "load", "load317", "put", "Lcom/displee/cache/index/archive/Archive;", "Lcom/displee/cache/index/archive/file/File;", "rebuild", "directory", "Ljava/io/File;", "reload", "remove", "Companion", "rs-cache-library"})
public class CacheLibrary {
    @NotNull
    public RandomAccessFile mainFile;
    private final SortedMap<Integer, Index> indices;
    @Nullable
    private Index255 index255;
    private boolean rs3;
    private boolean closed;
    @NotNull
    private final String path;
    private final boolean clearDataAfterUpdate;
    private final ProgressListener listener;
    @NotNull
    public static final String CACHE_FILE_NAME = "main_file_cache";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RandomAccessFile getMainFile() {
        RandomAccessFile randomAccessFile = this.mainFile;
        if (randomAccessFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mainFile");
        }
        return randomAccessFile;
    }

    public final void setMainFile(@NotNull RandomAccessFile randomAccessFile) {
        Intrinsics.checkParameterIsNotNull(randomAccessFile, "<set-?>");
        this.mainFile = randomAccessFile;
    }

    @Nullable
    public final Index255 getIndex255() {
        return this.index255;
    }

    public final void setIndex255(@Nullable Index255 index255) {
        this.index255 = index255;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    private final void init() {
        java.io.File mainFile317 = new java.io.File(this.path, "main_file_cache.dat");
        java.io.File index255 = new java.io.File(this.path, "main_file_cache.idx255");
        if (mainFile317.exists() && !index255.exists()) {
            this.load317();
        } else {
            this.load();
        }
    }

    public final void reload() {
        this.indices.clear();
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private final void load() throws IOException {
        Index255 index255;
        java.io.File main = new java.io.File(this.path, "main_file_cache.dat2");
        if (!main.exists()) {
            ProgressListener progressListener = this.listener;
            if (progressListener != null) {
                progressListener.notify(-1.0, "Error, main file could not be found");
            }
            throw (Throwable)new FileNotFoundException("File[path=" + main.getAbsolutePath() + "] could not be found.");
        }
        this.mainFile = new RandomAccessFile(main, "rw");
        java.io.File index255File = new java.io.File(this.path, "main_file_cache.idx255");
        if (!index255File.exists()) {
            ProgressListener progressListener = this.listener;
            if (progressListener != null) {
                progressListener.notify(-1.0, "Error, checksum file could not be found.");
            }
            throw (Throwable)new FileNotFoundException("File[path=" + index255File.getAbsolutePath() + "] could not be found.");
        }
        this.index255 = index255 = new Index255(this, new RandomAccessFile(index255File, "rw"));
        ProgressListener progressListener = this.listener;
        if (progressListener != null) {
            progressListener.notify(0.0, "Reading indices...");
        }
        int indicesLength = (int)index255.getRaf().length() / 6;
        this.rs3 = indicesLength > 39;
        int n = 0;
        int n2 = indicesLength;
        while (n < n2) {
            void i;
            block12: {
                java.io.File file = new java.io.File(this.path, "main_file_cache.idx" + (int)i);
                double progress = (double)i / ((double)indicesLength - 1.0);
                if (!file.exists()) {
                    ProgressListener progressListener2 = this.listener;
                    if (progressListener2 != null) {
                        progressListener2.notify(progress, "Could not load index " + (int)i + ", missing idx file.");
                    }
                } else {
                    try {
                        ((Map)this.indices).put((int)i, new Index(this, (int)i, new RandomAccessFile(file, "rw")));
                        ProgressListener progressListener3 = this.listener;
                        if (progressListener3 != null) {
                            progressListener3.notify(progress, "Loaded index " + (int)i + '.');
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ProgressListener progressListener4 = this.listener;
                        if (progressListener4 == null) break block12;
                        progressListener4.notify(progress, "Failed to load index " + (int)i + '.');
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void load317() throws IOException {
        java.io.File main = new java.io.File(this.path, "main_file_cache.dat");
        if (!main.exists()) {
            ProgressListener progressListener = this.listener;
            if (progressListener != null) {
                progressListener.notify(-1.0, "Error, main file could not be found");
            }
            throw (Throwable)new FileNotFoundException("File[path=" + main.getAbsolutePath() + "] could not be found.");
        }
        this.mainFile = new RandomAccessFile(main, "rw");
        java.io.File[] indexFiles2 = new java.io.File(this.path).listFiles(load317.indexFiles.1.INSTANCE);
        int n = indexFiles2 != null ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string2 = "Files are null. Check your cache path.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ProgressListener progressListener = this.listener;
        if (progressListener != null) {
            progressListener.notify(0.0, "Reading indices...");
        }
        n = 0;
        n2 = indexFiles2.length;
        while (n < n2) {
            void i;
            block9: {
                java.io.File file = new java.io.File(this.path, "main_file_cache.idx" + (int)i);
                double progress = (double)i / ((double)indexFiles2.length - 1.0);
                if (file.exists()) {
                    try {
                        ((Map)this.indices).put((int)i, new Index317(this, (int)i, new RandomAccessFile(file, "rw")));
                        ProgressListener progressListener2 = this.listener;
                        if (progressListener2 != null) {
                            progressListener2.notify(progress, "Loaded index " + (int)i + " .");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ProgressListener progressListener3 = this.listener;
                        if (progressListener3 == null) break block9;
                        progressListener3.notify(progress, "Failed to load index " + (int)i + '.');
                    }
                }
            }
            ++i;
        }
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4, boolean flag8, boolean writeReferenceTable) {
        Intrinsics.checkParameterIsNotNull((Object)compressionType, "compressionType");
        int id = this.indices.size();
        RandomAccessFile raf = new RandomAccessFile(new java.io.File(this.path, "main_file_cache.idx" + id), "rw");
        Index index = this.is317() ? (Index)new Index317(this, id, raf) : new Index(this, id, raf);
        boolean bl = false;
        boolean bl2 = false;
        Index it = index;
        boolean bl3 = false;
        ((Map)this.indices).put(id, it);
        Index index2 = index;
        if (!writeReferenceTable) {
            return index2;
        }
        index2.setVersion(version);
        index2.setRevision(revision);
        index2.setCompressionType(compressionType);
        if (named) {
            index2.flagMask(1);
        }
        if (whirlpool) {
            index2.flagMask(2);
        }
        if (this.isRS3()) {
            if (flag4) {
                index2.flagMask(4);
            }
            if (flag8) {
                index2.flagMask(8);
            }
        }
        index2.flag();
        boolean bl4 = Index.update$default(index2, null, 1, null);
        bl = false;
        bl2 = false;
        bl2 = false;
        boolean bl5 = false;
        if (!bl4) {
            boolean bl6 = false;
            String string2 = "Check failed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return index2;
    }

    public static /* synthetic */ Index createIndex$default(CacheLibrary cacheLibrary, CompressionType compressionType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createIndex");
        }
        if ((n3 & 1) != 0) {
            compressionType = CompressionType.GZIP;
        }
        if ((n3 & 2) != 0) {
            n = 6;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x40) != 0) {
            bl4 = false;
        }
        if ((n3 & 0x80) != 0) {
            bl5 = true;
        }
        return cacheLibrary.createIndex(compressionType, n, n2, bl, bl2, bl3, bl4, bl5);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4, boolean flag8) {
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, flag4, flag8, false, 128, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool, boolean flag4) {
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, flag4, false, false, 192, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named, boolean whirlpool) {
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, whirlpool, false, false, false, 224, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision, boolean named) {
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, named, false, false, false, false, 240, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version, int revision) {
        return CacheLibrary.createIndex$default(this, compressionType, version, revision, false, false, false, false, false, 248, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType, int version) {
        return CacheLibrary.createIndex$default(this, compressionType, version, 0, false, false, false, false, false, 252, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex(@NotNull CompressionType compressionType) {
        return CacheLibrary.createIndex$default(this, compressionType, 0, 0, false, false, false, false, false, 254, null);
    }

    @JvmOverloads
    @NotNull
    public final Index createIndex() {
        return CacheLibrary.createIndex$default(this, null, 0, 0, false, false, false, false, false, 255, null);
    }

    @NotNull
    public final Index createIndex(@NotNull Index index, boolean writeReferenceTable) {
        Intrinsics.checkParameterIsNotNull(index, "index");
        return this.createIndex(index.getCompressionType(), index.getVersion(), index.getRevision(), index.isNamed(), index.hasWhirlpool(), index.hasFlag4(), index.hasFlag8(), writeReferenceTable);
    }

    public static /* synthetic */ Index createIndex$default(CacheLibrary cacheLibrary, Index index, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createIndex");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return cacheLibrary.createIndex(index, bl);
    }

    public final boolean exists(int id) {
        return this.indices.containsKey(id);
    }

    @NotNull
    public final Index index(int id) {
        Index index = (Index)this.indices.get(id);
        boolean bl = false;
        boolean bl2 = false;
        if (index == null) {
            boolean bl3 = false;
            String string2 = "Index " + id + " doesn't exist. Please use the {@link exists(int) exists} function to verify whether an index exists.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return index;
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, int file, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return Archive.add$default(ReferenceTable.add$default((ReferenceTable)this.index(index), archive, 0, xtea, false, 10, null), file, data2, 0, false, 12, null);
    }

    public static /* synthetic */ File put$default(CacheLibrary cacheLibrary, int n, int n2, int n3, byte[] byArray, int[] nArray, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n4 & 0x10) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, n2, n3, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, int file, @NotNull byte[] data2) {
        return CacheLibrary.put$default(this, index, archive, file, data2, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, int archive, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Archive currentArchive = ReferenceTable.add$default((ReferenceTable)this.index(index), archive, -1, xtea, false, 8, null);
        Archive.add$default(currentArchive, 0, data2, 0, false, 12, null);
        return currentArchive;
    }

    public static /* synthetic */ Archive put$default(CacheLibrary cacheLibrary, int n, int n2, byte[] byArray, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n3 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, n2, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, int archive, @NotNull byte[] data2) {
        return CacheLibrary.put$default(this, index, archive, data2, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, @NotNull String file, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return Archive.add$default(ReferenceTable.add$default((ReferenceTable)this.index(index), archive, 0, xtea, false, 10, null), file, data2, false, 4, null);
    }

    public static /* synthetic */ File put$default(CacheLibrary cacheLibrary, int n, int n2, String string2, byte[] byArray, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n3 & 0x10) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, n2, string2, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, int archive, @NotNull String file, @NotNull byte[] data2) {
        return CacheLibrary.put$default(this, index, archive, file, data2, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, @NotNull String archive, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Archive currentArchive = this.index(index).add(archive, xtea);
        Archive.add$default(currentArchive, 0, data2, 0, false, 12, null);
        return currentArchive;
    }

    public static /* synthetic */ Archive put$default(CacheLibrary cacheLibrary, int n, String string2, byte[] byArray, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, string2, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final Archive put(int index, @NotNull String archive, @NotNull byte[] data2) {
        return CacheLibrary.put$default(this, index, archive, data2, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, @NotNull String archive, @NotNull String file, @NotNull byte[] data2, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return Archive.add$default(this.index(index).add(archive, xtea), file, data2, false, 4, null);
    }

    public static /* synthetic */ File put$default(CacheLibrary cacheLibrary, int n, String string2, String string3, byte[] byArray, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n2 & 0x10) != 0) {
            nArray = null;
        }
        return cacheLibrary.put(n, string2, string3, byArray, nArray);
    }

    @JvmOverloads
    @NotNull
    public final File put(int index, @NotNull String archive, @NotNull String file, @NotNull byte[] data2) {
        return CacheLibrary.put$default(this, index, archive, file, data2, null, 16, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, int file, @Nullable int[] xtea) {
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, int n2, int n3, int[] nArray, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        if ((n4 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, n2, n3, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, int file) {
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive) {
        return CacheLibrary.data$default(this, index, archive, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, @NotNull String file, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, int n2, String string2, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n3 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, n2, string2, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, int archive, @NotNull String file) {
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, int file, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, String string2, int n2, int[] nArray, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n3 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, string2, n2, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, int file) {
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, @NotNull String file, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Comparable<Archive> comparable = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, xtea, false, 4, null);
        return comparable != null && (comparable = ((Archive)comparable).file(file)) != null ? ((File)comparable).getData() : null;
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, String string2, String string3, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n2 & 8) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, string2, string3, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, @NotNull String file) {
        return CacheLibrary.data$default(this, index, archive, file, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive, @Nullable int[] xtea) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        return this.data(index, archive, 0, xtea);
    }

    public static /* synthetic */ byte[] data$default(CacheLibrary cacheLibrary, int n, String string2, int[] nArray, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: data");
        }
        if ((n2 & 4) != 0) {
            nArray = null;
        }
        return cacheLibrary.data(n, string2, nArray);
    }

    @JvmOverloads
    @Nullable
    public final byte[] data(int index, @NotNull String archive) {
        return CacheLibrary.data$default(this, index, archive, null, 4, null);
    }

    @Nullable
    public final File remove(int index, int archive, int file) {
        Archive archive2 = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, false, 2, null);
        return archive2 != null ? archive2.remove(file) : null;
    }

    @Nullable
    public final File remove(int index, int archive, @NotNull String file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Archive archive2 = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, false, 2, null);
        return archive2 != null ? archive2.remove(file) : null;
    }

    @Nullable
    public final File remove(int index, @NotNull String archive, @NotNull String file) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Archive archive2 = ReferenceTable.archive$default((ReferenceTable)this.index(index), archive, false, 2, null);
        return archive2 != null ? archive2.remove(file) : null;
    }

    @Nullable
    public final Archive remove(int index, int archive) {
        return this.index(index).remove(archive);
    }

    @Nullable
    public final Archive remove(int index, @NotNull String archive) {
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        return this.index(index).remove(archive);
    }

    public final void update() {
        for (Index index : this.indices.values()) {
            Archive[] archiveArray = index.flaggedArchives();
            boolean bl = false;
            if (archiveArray.length == 0 && !index.flagged()) continue;
            Index.update$default(index, null, 1, null);
        }
    }

    public final void deleteLastIndex() throws RuntimeException {
        if (this.is317()) {
            throw (Throwable)new UnsupportedOperationException("317 not supported to remove indices yet.");
        }
        int id = this.indices.size() - 1;
        Index index = (Index)this.indices.get(id);
        if (index == null) {
            return;
        }
        Index index2 = index;
        index2.close();
        java.io.File file = new java.io.File(this.path, "main_file_cache.idx" + id);
        if (!file.exists() || !file.delete()) {
            throw (Throwable)new RuntimeException("Failed to remove the random access file of the argued index[id=" + id + ", file exists=" + file.exists() + ']');
        }
        Object object = this.index255;
        if (object != null && (object = ((Index)object).getRaf()) != null) {
            ((RandomAccessFile)object).setLength((long)id * (long)6);
        }
        this.indices.remove(id);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys(boolean writeWhirlpool, @Nullable BigInteger exponent, @Nullable BigInteger modulus) {
        OutputBuffer buffer = new OutputBuffer(6 + this.indices.size() * 72);
        if (writeWhirlpool) {
            buffer.writeByte(this.indices.size());
        }
        byte[] emptyWhirlpool = new byte[64];
        for (Index index : this.indices()) {
            buffer.writeInt(index.getCrc()).writeInt(index.getRevision());
            if (!writeWhirlpool) continue;
            byte[] byArray = index.getWhirlpool();
            if (byArray == null) {
                byArray = emptyWhirlpool;
            }
            buffer.writeBytes(byArray);
        }
        if (writeWhirlpool) {
            byte[] indexData = Buffer.array$default(buffer, 0, 0, 3, null);
            OutputBuffer whirlpoolBuffer = new OutputBuffer(65).writeByte(0).writeBytes(OtherExtKt.generateWhirlpool(indexData, 5, indexData.length - 5));
            if (exponent != null && modulus != null) {
                buffer.writeBytes(Buffer.Companion.cryptRSA(Buffer.array$default(whirlpoolBuffer, 0, 0, 3, null), exponent, modulus));
            }
        }
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    public static /* synthetic */ byte[] generateUkeys$default(CacheLibrary cacheLibrary, boolean bl, BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateUkeys");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bigInteger = null;
        }
        if ((n & 4) != 0) {
            bigInteger2 = null;
        }
        return cacheLibrary.generateUkeys(bl, bigInteger, bigInteger2);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys(boolean writeWhirlpool, @Nullable BigInteger exponent) {
        return CacheLibrary.generateUkeys$default(this, writeWhirlpool, exponent, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys(boolean writeWhirlpool) {
        return CacheLibrary.generateUkeys$default(this, writeWhirlpool, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] generateUkeys() {
        return CacheLibrary.generateUkeys$default(this, false, null, null, 7, null);
    }

    public final void rebuild(@NotNull java.io.File directory) {
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        new java.io.File(directory.getPath()).mkdirs();
        if (this.is317()) {
            new java.io.File(directory.getPath(), "main_file_cache.dat").createNewFile();
        } else {
            new java.io.File(directory.getPath(), "main_file_cache.idx255").createNewFile();
            new java.io.File(directory.getPath(), "main_file_cache.dat2").createNewFile();
        }
        int indicesSize = this.indices.values().size();
        String string2 = directory.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string2, "directory.path");
        CacheLibrary newLibrary = new CacheLibrary(string2, false, null, 6, null);
        for (Index index : this.indices.values()) {
            int id = index.getId();
            String string3 = "\rBuilding index " + id + '/' + indicesSize + "...";
            boolean bl = false;
            System.out.print((Object)string3);
            Index255 index255 = this.index255;
            ArchiveSector archiveSector = index255 != null ? index255.readArchiveSector(id) : null;
            boolean writeReferenceTable = true;
            if (!this.is317() && archiveSector == null) {
                writeReferenceTable = false;
            }
            Index index2 = index;
            Intrinsics.checkExpressionValueIsNotNull(index2, "index");
            Index newIndex = newLibrary.createIndex(index2, writeReferenceTable);
            for (int i : index.archiveIds()) {
                Object object = index.readArchiveSector(i);
                if (object == null) continue;
                byte[] byArray = ((ArchiveSector)object).getData();
                object = byArray;
                if (byArray == null) {
                    continue;
                }
                Object data2 = object;
                newIndex.writeArchiveSector(i, (byte[])data2);
            }
            if (archiveSector == null) continue;
            Index255 index2552 = newLibrary.index255;
            if (index2552 == null) continue;
            index2552.writeArchiveSector(id, archiveSector.getData());
        }
        newLibrary.close();
        String string4 = "\rFinished building " + indicesSize + " indices.";
        boolean bl = false;
        System.out.println((Object)string4);
    }

    public final void fixCrcs(boolean update2) {
        Collection<Index> collection = this.indices.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "indices.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            int[] nArray = it.archiveIds();
            boolean bl2 = false;
            if (nArray.length == 0) continue;
            it.fixCRCs(update2);
        }
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        RandomAccessFile randomAccessFile = this.mainFile;
        if (randomAccessFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mainFile");
        }
        randomAccessFile.close();
        Index255 index255 = this.index255;
        if (index255 != null) {
            index255.close();
        }
        Collection<Index> collection = this.indices.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "indices.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            it.close();
        }
        this.closed = true;
    }

    @Nullable
    public final Index first() {
        if (this.indices.isEmpty()) {
            return null;
        }
        return (Index)this.indices.get(this.indices.firstKey());
    }

    @Nullable
    public final Index last() {
        if (this.indices.isEmpty()) {
            return null;
        }
        return (Index)this.indices.get(this.indices.lastKey());
    }

    public final boolean is317() {
        return this.index255 == null;
    }

    public final boolean isOSRS() {
        Index index = this.index(2);
        return index.getRevision() >= 300 && this.indices.size() <= 23;
    }

    public final boolean isRS3() {
        return this.rs3;
    }

    @NotNull
    public final Index[] indices() {
        Collection<Index> collection = this.indices.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "indices.values");
        Collection<Index> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Index> thisCollection$iv = $this$toTypedArray$iv;
        Index[] indexArray = thisCollection$iv.toArray(new Index[0]);
        if (indexArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return indexArray;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final boolean getClearDataAfterUpdate() {
        return this.clearDataAfterUpdate;
    }

    public CacheLibrary(@NotNull String path, boolean clearDataAfterUpdate, @Nullable ProgressListener listener) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.path = path;
        this.clearDataAfterUpdate = clearDataAfterUpdate;
        this.listener = listener;
        this.indices = new TreeMap();
        this.init();
    }

    public /* synthetic */ CacheLibrary(String string2, boolean bl, ProgressListener progressListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            progressListener = null;
        }
        this(string2, bl, progressListener);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate, @Nullable ProgressListener listener) {
        return Companion.create(path, clearDataAfterUpdate, listener);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate) {
        return com.displee.cache.CacheLibrary$Companion.create$default(Companion, path, clearDataAfterUpdate, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CacheLibrary create(@NotNull String path) {
        return com.displee.cache.CacheLibrary$Companion.create$default(Companion, path, false, null, 6, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/displee/cache/CacheLibrary$Companion;", "", "()V", "CACHE_FILE_NAME", "", "create", "Lcom/displee/cache/CacheLibrary;", "path", "clearDataAfterUpdate", "", "listener", "Lcom/displee/cache/ProgressListener;", "rs-cache-library"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate, @Nullable ProgressListener listener) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            return new CacheLibrary(path, clearDataAfterUpdate, listener);
        }

        public static /* synthetic */ CacheLibrary create$default(Companion companion, String string2, boolean bl, ProgressListener progressListener, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                progressListener = null;
            }
            return companion.create(string2, bl, progressListener);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CacheLibrary create(@NotNull String path, boolean clearDataAfterUpdate) {
            return com.displee.cache.CacheLibrary$Companion.create$default(this, path, clearDataAfterUpdate, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CacheLibrary create(@NotNull String path) {
            return com.displee.cache.CacheLibrary$Companion.create$default(this, path, false, null, 6, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

