/*
 * Decompiled with CFR 0.152.
 */
package com.client.utilities;

import com.client.Rasterizer3D;
import java.awt.Color;
import org.apache.commons.lang3.ArrayUtils;

public class ColourUtils {
    public static int getAlpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int getARGB(int rgb) {
        return ColourUtils.getRGB(ColourUtils.getRed(rgb), ColourUtils.getGreen(rgb), ColourUtils.getBlue(rgb));
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getRGB(int argb) {
        return (ColourUtils.getRed(argb) & 0xFF) << 16 | (ColourUtils.getGreen(argb) & 0xFF) << 8 | (ColourUtils.getBlue(argb) & 0xFF) << 0;
    }

    public static int getRGB(int red, int green, int blue) {
        return ColourUtils.getRGB(255, red, green, blue);
    }

    public static int getRGB(int alpha, int red, int green, int blue) {
        return alpha << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
    }

    public static int stripAlpha(int rgb) {
        return rgb & 0xFFFFFF;
    }

    public static int addAlpha(int rgb, int alpha) {
        return ColourUtils.getRGB(alpha, ColourUtils.getRed(rgb), ColourUtils.getGreen(rgb), ColourUtils.getBlue(rgb));
    }

    public static final int toHsl(int hue, int saturation, int luminance) {
        if (luminance > 179) {
            saturation /= 2;
        }
        if (luminance > 192) {
            saturation /= 2;
        }
        if (luminance > 217) {
            saturation /= 2;
        }
        if (luminance > 243) {
            saturation /= 2;
        }
        return (hue / 4 << 10) + (saturation / 32 << 7) + luminance / 2;
    }

    public static final int checkedLight(int colour, int light) {
        if (colour == -2) {
            return 12345678;
        }
        if (colour == -1) {
            if (light < 0) {
                light = 0;
            } else if (light > 127) {
                light = 127;
            }
            return 127 - light;
        }
        if ((light = light * (colour & 0x7F) / 128) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (colour & 0xFF80) + light;
    }

    public static int exponent(int colour, double exponent) {
        int alpha = colour >> 24 & 0xFF;
        double r = (double)(colour >> 16 & 0xFF) / 256.0;
        double g2 = (double)(colour >> 8 & 0xFF) / 256.0;
        double b = (double)(colour & 0xFF) / 256.0;
        r = Math.pow(r, exponent);
        g2 = Math.pow(g2, exponent);
        b = Math.pow(b, exponent);
        int newR = (int)(r * 256.0);
        int newG = (int)(g2 * 256.0);
        int newB = (int)(b * 256.0);
        return (alpha << 24) + (newR << 16) + (newG << 8) + newB;
    }

    public static int adjustBrightness(int colour, double brightness) {
        if (brightness == 1.0) {
            brightness = 0.9999;
        }
        int alpha = colour >> 24 & 0xFF;
        double r = colour >> 16 & 0xFF;
        double g2 = colour >> 8 & 0xFF;
        double b = colour & 0xFF;
        int newR = (int)(r *= brightness);
        int newG = (int)(g2 *= brightness);
        int newB = (int)(b *= brightness);
        return (alpha << 24) + (newR << 16) + (newG << 8) + newB;
    }

    public static int rgbIndex(int rgb) {
        return ArrayUtils.indexOf(Rasterizer3D.hslToRgb, rgb);
    }

    public static int RGB_to_RS2HSB(int colour) {
        int red = colour >> 16 & 0xFF;
        int green = colour >> 8 & 0xFF;
        int blue = colour & 0xFF;
        float[] HSB = Color.RGBtoHSB(red, green, blue, null);
        float hue = HSB[0];
        float saturation = HSB[1];
        float brightness = HSB[2];
        int encode_hue = (int)(hue * 63.0f);
        int encode_saturation = (int)(saturation * 7.0f);
        int encode_brightness = (int)(brightness * 127.0f);
        return (encode_hue << 10) + (encode_saturation << 7) + encode_brightness;
    }

    public static int RS2HSB_to_RGB(int RS2HSB) {
        int decode_hue = RS2HSB >> 10 & 0x3F;
        int decode_saturation = RS2HSB >> 7 & 7;
        int decode_brightness = RS2HSB & 0x7F;
        return Color.HSBtoRGB((float)decode_hue / 63.0f, (float)decode_saturation / 7.0f, (float)decode_brightness / 127.0f);
    }

    public static int[] getARGB(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = ColourUtils.addAlpha(pixels[i], 254);
        }
        return pixels;
    }
}

