/*
 * Decompiled with CFR 0.152.
 */
package com.client.util;

import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private long cachedTime = System.nanoTime();

    private Stopwatch() {
    }

    public static Stopwatch start() {
        return new Stopwatch();
    }

    public String toString() {
        return String.format("STOPWATCH[elapsed=%d]", this.elapsedTime());
    }

    public Stopwatch reset() {
        this.cachedTime = System.nanoTime();
        return this;
    }

    public Stopwatch reset(int delay, TimeUnit unit) {
        this.cachedTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(delay, unit);
        return this;
    }

    public long elapsedTime(TimeUnit unit) {
        return unit.convert(System.nanoTime() - this.cachedTime, TimeUnit.NANOSECONDS);
    }

    public long elapsedTime() {
        return this.elapsedTime(TimeUnit.MILLISECONDS);
    }

    public boolean elapsed(long time, TimeUnit unit) {
        return this.elapsedTime(unit) >= time;
    }

    public boolean elapsed(long time) {
        return this.elapsed(time, TimeUnit.MILLISECONDS);
    }
}

