/*
 * Decompiled with CFR 0.152.
 */
package com.client.skillorbs;

import com.client.Client;
import com.client.Rasterizer2D;
import com.client.Skills;
import com.client.Sprite;
import com.client.utilities.SecondsTimer;
import java.text.NumberFormat;

public class SkillOrb {
    private final int skill;
    private final Sprite icon;
    private SecondsTimer showTimer = new SecondsTimer();
    private int alpha;

    public SkillOrb(int skill, Sprite icon) {
        this.skill = skill;
        this.icon = icon;
    }

    public void receivedExperience() {
        this.alpha = 255;
        this.showTimer.start(6);
    }

    public void draw(int x, int y) {
        int percentProgress = this.percentage();
        Client.instance.skillOrbs[0].drawAdvancedSprite(x, y, this.alpha);
        Rasterizer2D.setDrawingArea(60 + y, x + 1, x + 30, 45 - (this.currentLevel() >= 99 ? 100 : percentProgress) + 1 + y);
        Client.instance.skillOrbs[1].drawAdvancedSprite(x + 1, 1 + y, this.alpha);
        Rasterizer2D.setDrawingArea((this.currentLevel() >= 99 ? 100 : percentProgress) - 38 + y, x + 30, x + 56, 1 + y);
        Client.instance.skillOrbs[1].drawAdvancedSprite(x + 2, 1 + y, this.alpha);
        Rasterizer2D.defaultDrawingAreaSize();
        this.icon.drawAdvancedSprite(x + 30 - this.icon.myWidth / 2, 28 - this.icon.myHeight / 2 + y, this.alpha);
    }

    public void drawTooltip() {
        int percentProgress = this.percentage();
        NumberFormat nf = NumberFormat.getInstance();
        int mouse_Y = Client.instance.getMouseX();
        int mouseY = Client.instance.getMouseY();
        Rasterizer2D.drawBoxOutline(mouse_Y, mouseY + 5, 122, 82, 5321753);
        Rasterizer2D.drawTransparentBox(mouse_Y + 1, mouseY + 6, 122, 83, 6579315, 90);
        Client.instance.newSmallFont.drawBasicString(Skills.SKILL_NAMES[this.skill], mouse_Y + 20 + Client.instance.newSmallFont.getTextWidth(Skills.SKILL_NAMES[this.skill]) - 25, mouseY + 20, 0xFFFFFF, 1);
        Client.instance.newSmallFont.drawBasicString("Level: @gre@" + Client.instance.maximumLevels[this.skill], mouse_Y + 5, mouseY + 35, 0xFFFFFF, 1);
        Client.instance.newSmallFont.drawBasicString("Exp: @gre@" + nf.format(Client.instance.currentExp[this.skill]), mouse_Y + 5, mouseY + 50, 0xFFFFFF, 1);
        Client.instance.newSmallFont.drawBasicString("Exp Left: @gre@" + nf.format(this.remainderExp() < 0 ? 0 : this.remainderExp()), mouse_Y + 5, mouseY + 65, 0xFFFFFF, 1);
        Rasterizer2D.drawBox(mouse_Y + 2, mouseY + 70, 118, 14, 0x666666);
        if (this.currentLevel() < 99) {
            Rasterizer2D.drawBox(mouse_Y + 2, mouseY + 70, percentProgress + 18, 14, Client.getProgressColor(percentProgress));
        } else {
            Rasterizer2D.drawBox(mouse_Y + 2, mouseY + 70, 118, 14, Client.getProgressColor(percentProgress));
        }
        Client.instance.newSmallFont.drawCenteredString(percentProgress + "% ", mouse_Y + 59 + 10, mouseY + 82, 0xFFFFFF, 1);
    }

    private int currentLevel() {
        return Client.instance.maximumLevels[this.skill];
    }

    private int startExp() {
        return Client.getXPForLevel(this.currentLevel());
    }

    private int requiredExp() {
        return Client.getXPForLevel(this.currentLevel() + 1);
    }

    private int obtainedExp() {
        return Client.instance.currentExp[this.skill] - this.startExp();
    }

    private int remainderExp() {
        return this.requiredExp() - (this.startExp() + this.obtainedExp());
    }

    private int percentage() {
        int percent = 0;
        try {
            percent = (int)((double)this.obtainedExp() / (double)(this.requiredExp() - this.startExp()) * 100.0);
            if (percent > 100) {
                percent = 100;
            }
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
        }
        return percent;
    }

    public SecondsTimer getShowTimer() {
        return this.showTimer;
    }

    public int getSkill() {
        return this.skill;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void decrementAlpha() {
        this.alpha -= 5;
    }
}

