/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Rasterizer2D;
import com.client.Sprite;
import com.client.TextDrawingArea;
import com.client.definitions.ItemDefinition;
import com.client.graphics.interfaces.RSInterface;
import java.util.Arrays;

public class Bank
extends RSInterface {
    public static final int EMPTY_CHILD = 41582;
    public static final int BANK_INTERFACE_ID = 5292;
    public static final int SEARCH_CONTAINER = 41583;
    public static final int SEARCH_BUTTON = 59000;
    public static final int TITLE_INTERFACE_ID = 58064;
    public static final int BANK_CONTAINER_HEIGHT = 130;
    public static final int OLD_CONTAINER_INTERFACE_ID = 5382;
    public static final int ITEM_COUNT_INTERFACE_ID = 58061;
    public static final int[] ITEM_CONTAINERS = new int[]{41573, 41574, 41575, 41576, 41577, 41578, 41579, 41580, 41581};
    public static final int[] BANK_TAB_ITEM_DISPLAYS = new int[]{58040, 58041, 58042, 58043, 58044, 58045, 58046, 58047, 58048};
    public static final int[] TAB_INTERFACE_IDS = new int[]{58050, 58051, 58052, 58053, 58054, 58055, 58056, 58057, 58058};
    public static final int[] COLLAPSE_BUTTONS = new int[]{-1, 58053, 58064, 58075, 58086, 58097, 58108, 58119, 58130};
    public static final int[] OPEN_TAB_BUTTONS = new int[]{58042, 58054, 58065, 58076, 58087, 58098, 58109, 58120, 58131};
    public static final int[] TAB_SPRITE_DISPLAYS = new int[]{58031, 58032, 58033, 58034, 58035, 58036, 58037, 58038, 58039};
    public static final Sprite TAB_WITH_PLUS = new Sprite("BankTab/TAB 4");
    public static final Sprite TAB_WITHOUT_PLUS = new Sprite("BankTab/TAB 3");
    public static int[] mainTabChildren = new int[ITEM_CONTAINERS.length];
    public static RSInterface bankScrollable = null;
    public static String searchingBankString = "";

    public static int getCurrentBankTab() {
        return Client.instance.variousSettings[1357];
    }

    public static boolean isBankContainer(RSInterface rsInterface) {
        return rsInterface.id == 41583 || Arrays.stream(ITEM_CONTAINERS).anyMatch(id -> rsInterface.id == id);
    }

    private static boolean moreTabsBelow(int index) {
        return index + 1 < ITEM_CONTAINERS.length && interfaceCache[ITEM_CONTAINERS[index + 1]].getItemContainerRows() > 0;
    }

    public static boolean isSearchingBank() {
        return Client.inputDialogState == 9;
    }

    public static void openBankSearch() {
        Bank.bankScrollable.children[Bank.mainTabChildren[0]] = 41583;
        Client.inputDialogState = 9;
        interfaceCache[41583].resetItems();
    }

    public static void closeBankSearch() {
        interfaceCache[41583].resetItems();
        Client.inputDialogState = 0;
        searchingBankString = "";
    }

    public static void handleButton(int buttonId) {
        for (int index = 1; index < COLLAPSE_BUTTONS.length; ++index) {
            if (buttonId != COLLAPSE_BUTTONS[index]) continue;
            RSInterface tab = interfaceCache[ITEM_CONTAINERS[index]];
            RSInterface main = interfaceCache[ITEM_CONTAINERS[0]];
            if (main.getInventoryContainerFreeSlots() < (long)tab.inventoryItemId.length - tab.getInventoryContainerFreeSlots()) continue;
            RSInterface.addAllItems(tab, main);
            Bank.shiftTabs();
            Bank.openBankTab(0);
        }
        for (int buttonIndex = 0; buttonIndex < OPEN_TAB_BUTTONS.length; ++buttonIndex) {
            if (buttonId != OPEN_TAB_BUTTONS[buttonIndex]) continue;
            Bank.openBankTab(buttonIndex);
        }
        if (buttonId == 59000) {
            if (Bank.bankScrollable.children[mainTabChildren[0]] == 41583) {
                Bank.closeBankSearch();
                Bank.openBankTab(Bank.getCurrentBankTab());
            } else {
                Bank.openBankSearch();
            }
        }
    }

    public static void shiftTabs() {
        for (int tabIndex = 1; tabIndex < ITEM_CONTAINERS.length; ++tabIndex) {
            RSInterface container = interfaceCache[ITEM_CONTAINERS[tabIndex]];
            container.shiftItems();
            if (container.getItemContainerRows() != 0) continue;
            for (int shiftTabIndex = tabIndex; shiftTabIndex < ITEM_CONTAINERS.length; ++shiftTabIndex) {
                if (shiftTabIndex + 1 >= ITEM_CONTAINERS.length) continue;
                container = interfaceCache[ITEM_CONTAINERS[shiftTabIndex]];
                RSInterface shiftLeft = interfaceCache[ITEM_CONTAINERS[shiftTabIndex + 1]];
                container.inventoryItemId = (int[])shiftLeft.inventoryItemId.clone();
                container.inventoryAmounts = (int[])shiftLeft.inventoryAmounts.clone();
            }
        }
    }

    public static void bankUpdates() {
        Bank.shiftTabs();
        boolean newTabDisplayed = false;
        for (int tabIndex = 1; tabIndex < TAB_INTERFACE_IDS.length; ++tabIndex) {
            if (interfaceCache[ITEM_CONTAINERS[tabIndex]].getInventoryContainerFreeSlots() != (long)Bank.interfaceCache[Bank.ITEM_CONTAINERS[tabIndex]].inventoryItemId.length) {
                RSInterface.interfaceCache[Bank.TAB_INTERFACE_IDS[tabIndex]].isMouseoverTriggered = false;
                RSInterface.interfaceCache[Bank.TAB_SPRITE_DISPLAYS[tabIndex]].sprite1 = TAB_WITHOUT_PLUS;
                RSInterface.interfaceCache[Bank.TAB_SPRITE_DISPLAYS[tabIndex]].sprite1.spriteName = "3-banktab/tab";
                continue;
            }
            if (!newTabDisplayed) {
                RSInterface.interfaceCache[Bank.TAB_INTERFACE_IDS[tabIndex]].isMouseoverTriggered = false;
                RSInterface.interfaceCache[Bank.TAB_SPRITE_DISPLAYS[tabIndex]].sprite1 = TAB_WITH_PLUS;
                newTabDisplayed = true;
                continue;
            }
            RSInterface.interfaceCache[Bank.TAB_INTERFACE_IDS[tabIndex]].isMouseoverTriggered = true;
        }
        for (int index = 1; index < BANK_TAB_ITEM_DISPLAYS.length; ++index) {
            Bank.interfaceCache[Bank.BANK_TAB_ITEM_DISPLAYS[index]].inventoryItemId[0] = Bank.interfaceCache[Bank.ITEM_CONTAINERS[index]].inventoryItemId[0];
            Bank.interfaceCache[Bank.BANK_TAB_ITEM_DISPLAYS[index]].inventoryAmounts[0] = Bank.interfaceCache[Bank.ITEM_CONTAINERS[index]].inventoryAmounts[0];
        }
    }

    public static void drawOnBank(RSInterface rsInterface, int x, int y) {
        if (rsInterface.id == 5292) {
            Rasterizer2D.drawPixels(1, 20, 29, 15108608, 16);
        }
    }

    public static void setupMainTab(RSInterface rsInterface, int x, int y) {
        if (rsInterface.id == 41583) {
            Bank.bankUpdates();
            for (int child : mainTabChildren) {
                Bank.bankScrollable.children[child] = 41582;
            }
            Bank.bankScrollable.children[Bank.mainTabChildren[0]] = 41583;
            RSInterface searchContainer = interfaceCache[41583];
            searchContainer.resetItems();
            if (searchingBankString.length() > 0) {
                for (int index = 0; index < ITEM_CONTAINERS.length; ++index) {
                    RSInterface container = interfaceCache[ITEM_CONTAINERS[index]];
                    for (int itemIndex = 0; itemIndex < container.inventoryItemId.length; ++itemIndex) {
                        ItemDefinition definition;
                        if (container.inventoryItemId[itemIndex] <= 0 || (definition = ItemDefinition.lookup(container.inventoryItemId[itemIndex] - 1)) == null || definition.name == null || !definition.name.toLowerCase().contains(searchingBankString.toLowerCase())) continue;
                        searchContainer.addItem(container.inventoryItemId[itemIndex], container.inventoryAmounts[itemIndex]);
                    }
                }
            }
        } else if (rsInterface.id == ITEM_CONTAINERS[Bank.getCurrentBankTab()]) {
            Bank.bankUpdates();
            Bank.interfaceCache[58064].message = "";
            if (Bank.getCurrentBankTab() == 0) {
                for (int index = 0; index < mainTabChildren.length; ++index) {
                    Bank.bankScrollable.children[Bank.mainTabChildren[index]] = 41582;
                }
                int itemContainerIndex = 0;
                for (int index = 0; index < mainTabChildren.length; ++index) {
                    RSInterface container = interfaceCache[ITEM_CONTAINERS[index]];
                    if (index != 0 && container.getInventoryContainerFreeSlots() == (long)container.inventoryItemId.length) continue;
                    Bank.bankScrollable.children[Bank.mainTabChildren[itemContainerIndex++]] = ITEM_CONTAINERS[index];
                }
            } else if (interfaceCache[ITEM_CONTAINERS[Bank.getCurrentBankTab()]].getInventoryContainerFreeSlots() == (long)Bank.interfaceCache[Bank.ITEM_CONTAINERS[Bank.getCurrentBankTab()]].inventoryItemId.length) {
                Bank.openBankTab(0);
            }
            int size = 0;
            for (int container : ITEM_CONTAINERS) {
                size = (int)((long)size + ((long)Bank.interfaceCache[container].inventoryItemId.length - interfaceCache[container].getInventoryContainerFreeSlots()));
            }
            Bank.interfaceCache[58061].message = "<ul>" + size + "</ul>";
            if (Bank.getCurrentBankTab() == 0) {
                int height = 4;
                for (int index = 0; index < ITEM_CONTAINERS.length; ++index) {
                    RSInterface container = interfaceCache[ITEM_CONTAINERS[index]];
                    if (index != 0 && Bank.moreTabsBelow(index - 1)) {
                        Client.instance.bankDivider.drawSprite(x, height + y);
                        height += 10;
                    }
                    Bank.bankScrollable.childY[Bank.mainTabChildren[index]] = height;
                    height += container.getItemContainerHeight();
                }
                Bank.bankScrollable.scrollMax = height > Bank.bankScrollable.height + 1 ? height : Bank.bankScrollable.height + 1;
            } else {
                int height = rsInterface.getItemContainerHeight();
                Bank.bankScrollable.scrollMax = height > Bank.bankScrollable.height + 1 ? height : Bank.bankScrollable.height + 1;
            }
        }
    }

    public static void openBankTab(int tab) {
        if (interfaceCache[ITEM_CONTAINERS[tab]].getInventoryContainerFreeSlots() == (long)Bank.interfaceCache[Bank.ITEM_CONTAINERS[tab]].inventoryItemId.length && tab != 0) {
            return;
        }
        Bank.closeBankSearch();
        Client.instance.variousSettings[1357] = tab;
        for (int tabIndex = 0; tabIndex < ITEM_CONTAINERS.length; ++tabIndex) {
            Client.instance.variousSettings[34 + tabIndex] = tabIndex == 0 ? 1 : 0;
        }
        Client.instance.variousSettings[34 + tab] = tab == 0 ? 0 : 1;
        Bank.bankScrollable.scrollPosition = 0;
        if (tab != 0) {
            for (int child : mainTabChildren) {
                Bank.bankScrollable.children[child] = 41582;
            }
        }
        Bank.bankScrollable.children[Bank.mainTabChildren[0]] = ITEM_CONTAINERS[tab];
    }

    public static void onConfigChanged(int config, int value) {
        if (config == 1357) {
            Bank.closeBankSearch();
            Bank.openBankTab(value);
        }
    }

    private void editBank(TextDrawingArea[] tda) {
        bankScrollable = interfaceCache[5385];
        Bank.bankScrollable.height -= 2;
        RSInterface bank = interfaceCache[5292];
        for (int index = 0; index < bank.children.length; ++index) {
            if (bank.children[index] != Bank.bankScrollable.id) continue;
            int n = index;
            bank.childY[n] = bank.childY[n] + 2;
        }
        if (!RSInterface.deleteChild(5382, bankScrollable)) {
            return;
        }
        Bank.addText(41582, "", tda, 1, 15108608, true, true);
        int newContainersStartIndex = Bank.expandChildren(ITEM_CONTAINERS.length, bankScrollable);
        for (int index = 0; index < ITEM_CONTAINERS.length; ++index) {
            RSInterface container = Bank.addInventoryContainer(ITEM_CONTAINERS[index], 9, 130, 14, 2, true, new String[0]);
            container.actions = new String[]{"Withdraw 1", "Withdraw 5", "Withdraw 10", "Withdraw All", "Withdraw X", "Withdraw All but one"};
            container.contentType = 206;
            Bank.mainTabChildren[index] = newContainersStartIndex;
            bankScrollable.child(newContainersStartIndex++, ITEM_CONTAINERS[index], 38, 0);
        }
        for (int container : ITEM_CONTAINERS) {
            Bank.interfaceCache[container].allowInvDraggingToOtherContainers = true;
        }
        RSInterface container = Bank.addInventoryContainer(41583, 9, 130, 14, 2, true, new String[0]);
        container.actions = new String[]{"Withdraw 1", "Withdraw 5", "Withdraw 10", "Withdraw All", "Withdraw X", "Withdraw All but one"};
    }

    public void bank(TextDrawingArea[] tda) {
        RSInterface rs = Bank.addInterface(5292);
        rs.message = "";
        rs.textChangeListener = (w, s2) -> {
            for (int i = 0; i < 9; ++i) {
                Bank.interfaceCache[58031 + i].active = false;
            }
            int tabId = Integer.parseInt(s2);
            Bank.interfaceCache[58031 + tabId].active = true;
        };
        rs.alignmentPolicy = RSInterface.AlignPolicy.CENTER;
        Bank.addSprite(58001, 100, "banktab/Revamp/SPRITE");
        Bank.addInputField(59000, 25, 16750623, "Search...", 125, 22, false, true, "[A-Za-z0-9 ]");
        Bank.addHoveredButton(59004, "banktab/07/bank", 14, 36, 36, 59005);
        Bank.addHoverButton(5384, "banktab/Revamp/SPRITE", 102, 21, 21, "Close Window", 250, 5380, 3);
        Bank.addHoveredButton(5380, "banktab/Revamp/SPRITE", 25, 21, 21, 5379);
        Bank.addClickableSprites(58002, "Swap Item Movement Mode", "banktab/Revamp/SPRITE", 217, 218, 217);
        Bank.addClickableSprites(58010, "Enable/Disable Noted Withdrawal", "banktab/Revamp/SPRITE", 219, 220, 219);
        Bank.addClickableSprites(58014, "Enable/disable placeholders", "banktab/Revamp/SPRITE", 232, 233, 232);
        Bank.configHoverButton(58018, "Deposit carried items", "banktab/Revamp/SPRITE", 221, 222, 221, 222, false, 58018);
        Bank.configHoverButton(58026, "Deposit worn items", "banktab/Revamp/SPRITE", 223, 224, 223, 224, false, 58026);
        for (int i = 0; i < 9; ++i) {
            Bank.addInterface(58050 + i);
            if (i == 0) {
                Bank.addConfigButton(58031, 5292, 0, 1, "banktab/tab", 48, 38, new String[]{"Price Check", "View"}, 1, 1111);
                Bank.interfaceCache[58031].disabledHover = Bank.imageLoader(1, "banktab/tab");
            } else {
                Bank.addConfigButton(58031 + i, 5292, 4, 3, "banktab/tab", 48, 38, new String[]{"Price check", "Collapse", "View"}, 1, 1111 + i);
                Bank.interfaceCache[58031 + i].disabledHover = Bank.imageLoader(2, "banktab/tab");
            }
            Bank.addToItemGroup(58040 + i, 1, 1, 0, 0, false, "", "", "");
        }
        Bank.configHoverButton(58060, "Open Presets", "banktab/Revamp/SPRITE", 234, 235, 234, 235, false, 58060);
        Bank.addText(58061, "", tda, 0, 15108608, true, true);
        Bank.addText(58062, "", tda, 0, 15108608, true, true);
        Bank.addInputField(58063, 50, 15108608, "", 100, 23, false, true);
        Bank.addText(58064, "Bank Of OblivionPk", tda, 2, 15108608, true, true);
        Bank.addText(59117, "Bank value: 0", tda, 0, 16750623, false, true);
        Bank.addText(58065, "", tda, 1, 16750623, false, true);
        Bank.addConfigButton(58066, 5292, 0, 1, "banktab/Revamp/SPRITE", 25, 2, "", 0, 0, 222);
        Bank.addTextButton(58067, "1", "Default quantity: 1", 16750623, 0xFFFFFF, true, true, tda, 1, 25, 22, 0, 3);
        Bank.addConfigButton(58068, 5292, 0, 1, "banktab/Revamp/SPRITE", 25, 2, "", 1, 0, 222);
        Bank.addTextButton(58069, "5", "Default quantity: 5", 16750623, 0xFFFFFF, true, true, tda, 1, 25, 22, 0, 3);
        Bank.addConfigButton(58070, 5292, 0, 1, "banktab/Revamp/SPRITE", 25, 2, "", 2, 0, 222);
        Bank.addTextButton(58071, "10", "Default quantity: 10", 16750623, 0xFFFFFF, true, true, tda, 1, 25, 22, 0, 3);
        Bank.addConfigButton(58072, 5292, 0, 1, "banktab/Revamp/SPRITE", 25, 2, "", 3, 0, 222);
        Bank.addTextButton(58073, "X", "Default quantity: X", 16750623, 0xFFFFFF, true, true, tda, 1, 25, 22, 0, 3);
        Bank.addConfigButton(58074, 5292, 0, 1, "banktab/Revamp/SPRITE", 25, 2, "", 4, 0, 222);
        Bank.addTextButton(58075, "All", "Default quantity: All", 16750623, 0xFFFFFF, true, true, tda, 1, 25, 22, 0, 3);
        RSInterface Interface = interfaceCache[5385];
        Interface.width += 21;
        Interface.height -= 15;
        Interface.scrollMax = 1444;
        Interface = interfaceCache[5382];
        Interface.contentType = 206;
        Interface.inventoryItemId = new int[800];
        Interface.inventoryAmounts = new int[800];
        Interface.actions = new String[]{"Withdraw 1", "Withdraw 5", "Withdraw 10", "Withdraw All", "Withdraw X", "Withdraw All-but-1"};
        Bank.setChildren(47, rs);
        Bank.setBounds(58001, 12, 2, 0, rs);
        int close_x = 474;
        int close_y = 11;
        Bank.setBounds(5384, close_x, close_y, 1, rs);
        Bank.setBounds(5380, close_x, close_y, 2, rs);
        int spacer_x = 4;
        Bank.setBounds(59000, 325, 9, 5, rs);
        Bank.setBounds(59004, 382 + spacer_x, 290, 6, rs);
        Bank.setBounds(58018, 420, 300, 7, rs);
        Bank.setBounds(58026, 457, 300, 8, rs);
        Bank.setBounds(58014, 309, 300, 9, rs);
        Bank.setBounds(5385, 28, 77, 10, rs);
        int x = 55;
        for (int j = 0; j < 9; ++j) {
            Bank.setBounds(58050 + j, 0, 0, 11 + j, rs);
            RSInterface rsi = interfaceCache[58050 + j];
            Bank.setChildren(2, rsi);
            Bank.setBounds(58031 + j, x, 37, 0, rsi);
            Bank.setBounds(58040 + j, x + 5, 40, 1, rsi);
            x += 41;
        }
        int quantity_y = 305;
        Bank.setBounds(58060, 272, 300, 24, rs);
        Bank.setBounds(58061, 36, 41, 26, rs);
        Bank.setBounds(58062, 36, 53, 27, rs);
        Bank.setBounds(58064, 325, 12, 28, rs);
        Bank.setBounds(58065, 75, 290, 29, rs);
        int subtract_x = 210;
        Bank.setBounds(58066, 235 - subtract_x, quantity_y - 4, 30, rs);
        Bank.setBounds(58067, 235 - subtract_x, quantity_y - 1, 31, rs);
        Bank.setBounds(58068, 263 - subtract_x + 2, quantity_y - 4, 32, rs);
        Bank.setBounds(58069, 263 - subtract_x + 2, quantity_y - 1, 33, rs);
        Bank.setBounds(58070, 292 - subtract_x + 4, quantity_y - 4, 34, rs);
        Bank.setBounds(58071, 292 - subtract_x + 4, quantity_y - 1, 35, rs);
        Bank.setBounds(58072, 321 - subtract_x + 6, quantity_y - 4, 36, rs);
        Bank.setBounds(58073, 321 - subtract_x + 6, quantity_y - 1, 37, rs);
        Bank.setBounds(58074, 350 - subtract_x + 8, quantity_y - 4, 38, rs);
        Bank.setBounds(58075, 350 - subtract_x + 8, quantity_y - 1, 39, rs);
        Bank.setBounds(58002, 346, 300, 20, rs);
        Bank.setBounds(58010, 383, 300, 22, rs);
        Bank.setBounds(59117, 25, 14, 46, rs);
        this.editBank(tda);
    }

    public static void update(String message) {
        searchingBankString = message;
        try {
            Bank.setupMainTab(RSInterface.get(41583), RSInterface.get((int)41583).width, RSInterface.get((int)41583).height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

