/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.definitions.NpcDefinition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;

public class NpcDefinitionDumper {
    public static void dump() {
        HashMap<Integer, Npc> npcs = new HashMap<Integer, Npc>();
        for (int i = 0; i < 100000; ++i) {
            try {
                NpcDefinition def = NpcDefinition.lookup(i);
                if (def == null) continue;
                npcs.put(i, new Npc(def.name, def.combatLevel, def.size));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NpcDefinitionDumper.toJson(npcs, "./temp/npc_definitions.json");
    }

    private static <T> void toJson(T t, String filePath) {
        Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = prettyGson.toJson(t);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(filePath)));
            bw.write(prettyJson);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Npc {
        private final String name;
        private final int combatLevel;
        private final int size;

        public Npc(String name, int combatLevel, int size) {
            this.name = name;
            this.combatLevel = combatLevel;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public int getCombatLevel() {
            return this.combatLevel;
        }

        public int getSize() {
            return this.size;
        }
    }
}

