/*
 * Decompiled with CFR 0.152.
 */
package com.client.audio;

import com.client.Configuration;
import com.client.audio.OpusCodec;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class VoicePlayback {
    private static VoicePlayback instance;
    private static final float SAMPLE_RATE = 16000.0f;
    private static final int SAMPLE_SIZE_BITS = 16;
    private static final int CHANNELS = 1;
    private static final boolean SIGNED = true;
    private static final boolean BIG_ENDIAN = false;
    private AudioFormat audioFormat = new AudioFormat(16000.0f, 16, 1, true, false);
    private SourceDataLine speakers;
    private boolean isPlaying;
    private Thread playbackThread;
    private LinkedBlockingQueue<byte[]> audioQueue = new LinkedBlockingQueue(100);
    private ConcurrentHashMap<String, Long> activeSpeakers = new ConcurrentHashMap();
    private int selectedSpeakerIndex = 0;
    private Mixer.Info[] availableSpeakers;

    private static void debug(String message) {
        if (Configuration.NewDevMode) {
            System.out.println(message);
        }
    }

    private static void debugErr(String message) {
        if (Configuration.NewDevMode) {
            System.err.println(message);
        }
    }

    private VoicePlayback() {
    }

    public static VoicePlayback getInstance() {
        if (instance == null) {
            instance = new VoicePlayback();
        }
        return instance;
    }

    public void initialize() {
        if (this.isPlaying) {
            return;
        }
        try {
            Mixer mixer;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            Mixer.Info[] speakerList = this.getAvailableSpeakers();
            if (speakerList.length == 0) {
                VoicePlayback.debugErr("No speakers detected!");
                return;
            }
            if (this.selectedSpeakerIndex >= speakerList.length) {
                this.selectedSpeakerIndex = 0;
            }
            if (!(mixer = AudioSystem.getMixer(speakerList[this.selectedSpeakerIndex])).isLineSupported(info)) {
                VoicePlayback.debugErr("Selected speaker does not support required format!");
                return;
            }
            this.speakers = (SourceDataLine)mixer.getLine(info);
            Mixer.Info mixerInfo = speakerList[this.selectedSpeakerIndex];
            Line.Info lineInfo = this.speakers.getLineInfo();
            VoicePlayback.debug("[SPEAKER DEBUG] Using Speaker " + (this.selectedSpeakerIndex + 1) + "/" + speakerList.length);
            VoicePlayback.debug("[SPEAKER DEBUG] Speaker device: " + mixerInfo.getName());
            VoicePlayback.debug("[SPEAKER DEBUG] Device description: " + mixerInfo.getDescription());
            VoicePlayback.debug("[SPEAKER DEBUG] Device vendor: " + mixerInfo.getVendor());
            VoicePlayback.debug("[SPEAKER DEBUG] Line info: " + lineInfo.toString());
            int bufferSize = 8192;
            this.speakers.open(this.audioFormat, bufferSize);
            this.speakers.start();
            this.isPlaying = true;
            this.playbackThread = new Thread(this::playbackLoop);
            this.playbackThread.setName("VoiceChat-Playback");
            this.playbackThread.setDaemon(true);
            this.playbackThread.start();
            VoicePlayback.debug("[PLAYBACK DEBUG] Voice chat playback initialized");
            VoicePlayback.debug("[PLAYBACK DEBUG] Audio format: 16000.0Hz, 16bit, 1 channel(s)");
            VoicePlayback.debug("[PLAYBACK DEBUG] Buffer size: " + bufferSize + " bytes (" + (double)bufferSize * 1000.0 / 32000.0 + "ms)");
        }
        catch (LineUnavailableException e) {
            VoicePlayback.debugErr("Failed to open audio output: " + e.getMessage());
        }
    }

    public void shutdown() {
        if (!this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        if (this.playbackThread != null) {
            this.playbackThread.interrupt();
            try {
                this.playbackThread.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.speakers != null) {
            this.speakers.drain();
            this.speakers.stop();
            this.speakers.close();
            this.speakers = null;
        }
        this.audioQueue.clear();
        this.activeSpeakers.clear();
        VoicePlayback.debug("Voice chat playback stopped");
    }

    public void queueAudio(String playerName, byte[] audioData) {
        VoicePlayback.debug("[PLAYBACK DEBUG] Received audio from " + playerName + ": " + audioData.length + " bytes, isPlaying=" + this.isPlaying);
        if (!this.isPlaying || audioData == null || audioData.length == 0) {
            VoicePlayback.debug("[PLAYBACK DEBUG] Audio rejected - isPlaying=" + this.isPlaying + ", audioData=" + (String)(audioData == null ? "null" : audioData.length + " bytes"));
            return;
        }
        try {
            byte[] decompressedAudio = audioData;
            try {
                OpusCodec codec = OpusCodec.getInstance();
                decompressedAudio = codec.decode(audioData);
                VoicePlayback.debug("[OPUS] Decompressed " + audioData.length + " bytes \u2192 " + decompressedAudio.length + " bytes");
            }
            catch (Exception | NoClassDefFoundError e) {
                VoicePlayback.debug("[PLAYBACK DEBUG] Treating as uncompressed PCM (" + audioData.length + " bytes)");
            }
            if (!this.audioQueue.offer(decompressedAudio)) {
                VoicePlayback.debug("[PLAYBACK DEBUG] Audio queue full, dropping oldest packet");
                this.audioQueue.poll();
                this.audioQueue.offer(decompressedAudio);
            }
            this.activeSpeakers.put(playerName, System.currentTimeMillis());
            VoicePlayback.debug("[PLAYBACK DEBUG] Audio queued successfully. Queue size: " + this.audioQueue.size());
        }
        catch (Exception e) {
            VoicePlayback.debugErr("Error queueing audio: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void playbackLoop() {
        VoicePlayback.debug("[PLAYBACK DEBUG] Playback loop started");
        while (this.isPlaying && !Thread.currentThread().isInterrupted()) {
            try {
                byte[] audioData = this.audioQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (audioData == null || this.speakers == null) continue;
                int available = this.speakers.available();
                VoicePlayback.debug("[PLAYBACK DEBUG] Playing audio: " + audioData.length + " bytes (buffer available: " + available + " bytes)");
                int written = this.speakers.write(audioData, 0, audioData.length);
                VoicePlayback.debug("[PLAYBACK DEBUG] Audio played successfully (" + written + " bytes written)");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                VoicePlayback.debugErr("[PLAYBACK DEBUG] Error in playback loop: " + e.getMessage());
                e.printStackTrace();
            }
        }
        VoicePlayback.debug("[PLAYBACK DEBUG] Playback loop stopped");
    }

    public ConcurrentHashMap<String, Long> getActiveSpeakers() {
        long currentTime = System.currentTimeMillis();
        this.activeSpeakers.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 2000L);
        return this.activeSpeakers;
    }

    public boolean isPlayerSpeaking(String playerName) {
        Long lastAudioTime = this.activeSpeakers.get(playerName);
        if (lastAudioTime == null) {
            return false;
        }
        return System.currentTimeMillis() - lastAudioTime < 500L;
    }

    public void clearQueue() {
        this.audioQueue.clear();
    }

    public Mixer.Info[] getAvailableSpeakers() {
        if (this.availableSpeakers == null) {
            Mixer.Info[] allMixers;
            AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, false);
            DataLine.Info sourceInfo = new DataLine.Info(SourceDataLine.class, format);
            ArrayList<Mixer.Info> speakerList = new ArrayList<Mixer.Info>();
            for (Mixer.Info mixerInfo : allMixers = AudioSystem.getMixerInfo()) {
                Mixer mixer = AudioSystem.getMixer(mixerInfo);
                if (!mixer.isLineSupported(sourceInfo)) continue;
                speakerList.add(mixerInfo);
            }
            this.availableSpeakers = speakerList.toArray(new Mixer.Info[0]);
        }
        return this.availableSpeakers;
    }

    public String switchSpeaker() {
        Mixer.Info[] speakers = this.getAvailableSpeakers();
        if (speakers.length == 0) {
            return "No speakers detected!";
        }
        boolean wasPlaying = this.isPlaying;
        if (wasPlaying) {
            this.shutdown();
        }
        this.selectedSpeakerIndex = (this.selectedSpeakerIndex + 1) % speakers.length;
        String result2 = "Speaker " + (this.selectedSpeakerIndex + 1) + "/" + speakers.length + ": " + speakers[this.selectedSpeakerIndex].getName();
        if (wasPlaying) {
            this.initialize();
        }
        return result2;
    }

    public String setSpeaker(int index) {
        Mixer.Info[] speakers = this.getAvailableSpeakers();
        if (speakers.length == 0) {
            return "No speakers detected!";
        }
        if (index < 0 || index >= speakers.length) {
            return "Invalid speaker index!";
        }
        boolean wasPlaying = this.isPlaying;
        if (wasPlaying) {
            this.shutdown();
        }
        this.selectedSpeakerIndex = index;
        String result2 = "Speaker " + (this.selectedSpeakerIndex + 1) + "/" + speakers.length + ": " + speakers[this.selectedSpeakerIndex].getName();
        if (wasPlaying) {
            this.initialize();
        }
        return result2;
    }

    public String getCurrentSpeakerInfo() {
        Mixer.Info[] speakers = this.getAvailableSpeakers();
        if (speakers.length == 0) {
            return "No speakers detected!";
        }
        return "Active: Speaker " + (this.selectedSpeakerIndex + 1) + "/" + speakers.length + ": " + speakers[this.selectedSpeakerIndex].getName();
    }

    public int getSelectedSpeakerIndex() {
        return this.selectedSpeakerIndex;
    }
}

