/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.sign.Signlink;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;

public class CacheDownloader {
    private static final Logger log = Logger.getLogger(CacheDownloader.class.getName());
    private final AtomicInteger totalBytesDownloaded = new AtomicInteger(0);
    private final AtomicInteger totalFileSize = new AtomicInteger(0);
    public static int cacheVersionRemote;
    public static int cacheVersionLocal;
    private Client client;
    private static final int BUFFER = 8192;
    private Path fileLocation;
    private ExecutorService downloadExecutor;
    private ScheduledExecutorService progressUpdater;

    public CacheDownloader(Client client) {
        Objects.requireNonNull(Signlink.getCacheDirectory());
        this.client = client;
        this.fileLocation = Paths.get(Signlink.getCacheDirectory(), this.getArchivedName());
        this.downloadExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.progressUpdater = Executors.newSingleThreadScheduledExecutor();
    }

    private int getLocalVersion() {
        int n;
        BufferedReader fr = new BufferedReader(new FileReader(Signlink.getCacheDirectory() + File.separator + "version.dat"));
        try {
            n = Integer.parseInt(fr.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1;
            }
        }
        fr.close();
        return n;
    }

    public void writeVersion(int version) {
        File versionFile = new File(Signlink.getCacheDirectory() + File.separator + "version.dat");
        if (versionFile.exists()) {
            versionFile.delete();
        }
        try (BufferedWriter br = new BufferedWriter(new FileWriter(versionFile));){
            br.write(Integer.toString(version));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateInstallProgress(int currentEntry, int totalEntries) {
        int progressPercentage = (int)((double)currentEntry / (double)totalEntries * 100.0);
        SwingUtilities.invokeLater(() -> this.client.drawLoadingText(progressPercentage, "Installing Cache: " + progressPercentage + "%"));
    }

    public void deleteZip() {
        try {
            Files.deleteIfExists(this.fileLocation);
        }
        catch (IOException ex) {
            log.severe("Cannot delete cache zip file: " + ex.getMessage());
        }
    }

    public CacheDownloader downloadCache() {
        block6: {
            if (Signlink.usingDevCache()) {
                System.out.println("Using local_cache, skipping cache update.");
                return null;
            }
            try {
                File location = new File(Signlink.getCacheDirectory());
                File version = new File(Signlink.getCacheDirectory() + "/version.dat");
                cacheVersionRemote = 19;
                if (!location.exists() || !version.exists()) {
                    log.info("Cache does not exist, downloading.");
                    this.update();
                    break block6;
                }
                cacheVersionLocal = this.getLocalVersion();
                log.info("Cache version local=" + cacheVersionLocal + ", remote=" + cacheVersionRemote);
                if (cacheVersionRemote != cacheVersionLocal) {
                    this.update();
                    break block6;
                }
                return null;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    private void update() throws IOException {
        try {
            this.downloadFile("http://RuneFuryrsps.com/downloads/.RuneFuryv2.zip", this.getArchivedName());
            this.downloadExecutor.shutdown();
            boolean finished = this.downloadExecutor.awaitTermination(1L, TimeUnit.HOURS);
            if (!finished) {
                throw new IOException("Not all download tasks finished within the time limit.");
            }
            this.updateProgress();
            this.unZip();
            this.writeVersion(cacheVersionRemote);
            this.deleteZip();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.severe("Download tasks interrupted: " + e.getMessage());
        }
        finally {
            if (!this.downloadExecutor.isShutdown()) {
                this.downloadExecutor.shutdownNow();
            }
            if (!this.progressUpdater.isShutdown()) {
                this.progressUpdater.shutdownNow();
            }
        }
    }

    private void downloadFile(String address, String localFileName) throws IOException {
        this.progressUpdater.scheduleAtFixedRate(this::updateProgress, 0L, 100L, TimeUnit.MILLISECONDS);
        this.downloadExecutor.submit(() -> {
            try {
                URL url = new URL(address);
                URLConnection connection = url.openConnection();
                int fileSize = connection.getContentLength();
                if (fileSize <= 0) {
                    log.warning("Could not determine file size. Progress bar may not work correctly.");
                    fileSize = 1;
                }
                this.setTotalFileSize(fileSize);
                log.info("File size to download: " + fileSize + " bytes");
                Path targetPath = Paths.get(Signlink.getCacheDirectory(), localFileName);
                try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                     FileOutputStream fileOutputStream = new FileOutputStream(targetPath.toFile());){
                    int bytesRead;
                    byte[] dataBuffer = new byte[8192];
                    while ((bytesRead = in.read(dataBuffer, 0, 8192)) != -1) {
                        fileOutputStream.write(dataBuffer, 0, bytesRead);
                        this.totalBytesDownloaded.addAndGet(bytesRead);
                    }
                }
                catch (IOException e) {
                    log.severe("Error writing cache data: " + e.getMessage());
                    throw e;
                }
            }
            catch (IOException e) {
                log.severe("Error downloading cache: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    private void updateProgress() {
        Object message;
        int progressPercentage;
        int downloadedBytes = this.totalBytesDownloaded.get();
        int totalBytes = this.totalFileSize.get();
        log.info("Downloaded bytes: " + downloadedBytes + " / Total bytes: " + totalBytes);
        if (totalBytes > 0) {
            progressPercentage = (int)((double)downloadedBytes / (double)totalBytes * 100.0);
            message = "Downloading Cache: " + progressPercentage + "%";
        } else {
            progressPercentage = 0;
            message = "Downloading Cache Please Wait.";
        }
        SwingUtilities.invokeLater(() -> this.lambda$updateProgress$2(progressPercentage, (String)message));
    }

    public void setTotalFileSize(int size) {
        this.totalFileSize.set(size);
    }

    public void shutdownExecutor() {
        this.downloadExecutor.shutdown();
        this.progressUpdater.shutdown();
    }

    private String getArchivedName() {
        int lastSlashIndex = "http://RuneFuryrsps.com/downloads/.RuneFuryv2.zip".lastIndexOf(47);
        if (lastSlashIndex >= 0 && lastSlashIndex < "http://RuneFuryrsps.com/downloads/.RuneFuryv2.zip".length() - 1) {
            String u = "http://RuneFuryrsps.com/downloads/.RuneFuryv2.zip".substring(lastSlashIndex + 1);
            return u.replace("", "");
        }
        System.err.println("Error retrieving archived name.");
        return "";
    }

    private void unZip() throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.fileLocation.toString()));
             ZipInputStream zin = new ZipInputStream(in);){
            ZipEntry e;
            int files = CacheDownloader.countRegularFiles(new ZipFile(this.fileLocation.toString()));
            int numWritten = 0;
            System.out.println("fileLocation: " + this.fileLocation.toAbsolutePath());
            while ((e = zin.getNextEntry()) != null) {
                String fileName = e.getName();
                File newFile = new File(Signlink.getCacheDirectory() + File.separator + fileName);
                if (e.isDirectory()) {
                    new File(Signlink.getCacheDirectory() + e.getName()).mkdir();
                    System.out.println("Created new directory for " + Signlink.getCacheDirectory() + " + " + e.getName());
                } else {
                    if (e.getName().equals(this.fileLocation.toString())) {
                        System.out.println("Unzipping at " + this.fileLocation.toAbsolutePath());
                        this.unzip(zin, this.fileLocation.toString());
                        break;
                    }
                    File parentDir = new File(newFile.getParent());
                    if (!parentDir.exists()) {
                        Preconditions.checkState(parentDir.mkdirs(), "Cannot create file.");
                    }
                    System.out.println("Unzipping below at " + Signlink.getCacheDirectory() + " + " + e.getName());
                    this.unzip(zin, Signlink.getCacheDirectory() + e.getName());
                }
                int percentage = (int)((double)numWritten++ / (double)files * 100.0);
                SwingUtilities.invokeLater(() -> this.client.drawLoadingText(percentage, "OblivionPk - Installing Cache " + percentage + "%"));
            }
        }
    }

    private static int countRegularFiles(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
        int numRegularFiles = 0;
        while (entries2.hasMoreElements()) {
            if (entries2.nextElement().isDirectory()) continue;
            ++numRegularFiles;
        }
        return numRegularFiles;
    }

    private void unzip(ZipInputStream zin, String outputFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = zin.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    private /* synthetic */ void lambda$updateProgress$2(int progressPercentage, String message) {
        this.client.drawLoadingText(progressPercentage, message);
    }
}

