/*
 * Decompiled with CFR 0.152.
 */
package org.launch.download;

import org.launch.download.os.OperatingSystem;

public enum DownloadType {
    MAIN_FILE("CLIENT.jar", "https://scapepulse.com/downloads/launcher/obpk_client.jar", "Client", OperatingSystem.ANY),
    MAC_JAVA("mac.zip", "https://www.scapepulse.com/downloads/launcher/jdk/mac.zip", "Java", OperatingSystem.MAC),
    LINUX_JAVA("mac.zip", "https://www.scapepulse.com/downloads/launcher/jdk/mac.zip", "Java", OperatingSystem.LINUX),
    WINDOWS_JAVA("windows.zip", "https://www.scapepulse.com/downloads/launcher/jdk/windows.zip", "Java", OperatingSystem.WINDOWS);

    private final String fileName;
    private final String url;
    private final String fileDescription;
    private final OperatingSystem operatingSystem;
    public long personalSize;
    public long remoteSize;
    public long personalLastModified;
    public long remoteLastModified;
    public boolean repack;

    public static DownloadType getTypeFromFileName(String name) {
        for (DownloadType type : DownloadType.values()) {
            if (!type.getFileName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFileDescription() {
        return this.fileDescription;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public long getPersonalSize() {
        return this.personalSize;
    }

    public long getRemoteSize() {
        return this.remoteSize;
    }

    public long getPersonalLastModified() {
        return this.personalLastModified;
    }

    public long getRemoteLastModified() {
        return this.remoteLastModified;
    }

    public boolean isRepack() {
        return this.repack;
    }

    private DownloadType(String fileName, String url, String fileDescription, OperatingSystem operatingSystem) {
        this.fileName = fileName;
        this.url = url;
        this.fileDescription = fileDescription;
        this.operatingSystem = operatingSystem;
    }
}

