/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.GlassBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.ArcDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.highlight.GlassHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class CeruleanSkin
extends SubstanceSkin {
    public static final String NAME = "Cerulean";

    public CeruleanSkin() {
        SubstanceSkin.ColorSchemes ceruleanSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/cerulean.colorschemes");
        SubstanceColorScheme activeScheme = ceruleanSchemes.get("Cerulean Active");
        SubstanceColorScheme enabledScheme = ceruleanSchemes.get("Cerulean Enabled");
        SubstanceColorScheme rolloverSelectedScheme = ceruleanSchemes.get("Cerulean Rollover Selected");
        SubstanceColorScheme disabledScheme = ceruleanSchemes.get("Cerulean Disabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Pressed"), ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Disabled Selected"), ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Selected"), ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Rollover Selected"), ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Rollover Unselected"), ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Mark"), SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(ceruleanSchemes.get("Cerulean Border"), SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        ComponentState determinateState = new ComponentState("determinate enabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.DETERMINATE, SubstanceSlices.ComponentStateFacet.SELECTION}, null);
        ComponentState determinateDisabledState = new ComponentState("determinate disabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DETERMINATE, SubstanceSlices.ComponentStateFacet.SELECTION}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE});
        ComponentState indeterminateState = new ComponentState("indeterminate enabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.SELECTION}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DETERMINATE});
        ComponentState indeterminateDisabledState = new ComponentState("indeterminate disabled", null, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DETERMINATE, SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.SELECTION});
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, determinateState, indeterminateState);
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, determinateState, indeterminateState);
        defaultSchemeBundle.registerColorScheme(disabledScheme, determinateDisabledState, indeterminateDisabledState);
        defaultSchemeBundle.registerColorScheme(disabledScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, determinateDisabledState, indeterminateDisabledState);
        ComponentState editable = new ComponentState("editable", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.EDITABLE}, null);
        ComponentState uneditable = new ComponentState("uneditable", editable, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.EDITABLE});
        defaultSchemeBundle.registerColorScheme(defaultSchemeBundle.getColorScheme(editable), SubstanceSlices.ColorSchemeAssociationKind.FILL, uneditable);
        SubstanceSkin.ColorSchemes kitchenSinkSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/kitchen-sink.colorschemes");
        SubstanceColorScheme highlightColorScheme = kitchenSinkSchemes.get("Moderate Highlight");
        defaultSchemeBundle.registerHighlightColorScheme(highlightColorScheme, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme activeHeaderScheme = ceruleanSchemes.get("Cerulean Active Header");
        SubstanceColorScheme headerScheme = ceruleanSchemes.get("Cerulean Header");
        SubstanceColorScheme disabledHeaderScheme = ceruleanSchemes.get("Cerulean Header Disabled");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeHeaderScheme, headerScheme, disabledHeaderScheme);
        headerSchemeBundle.registerColorScheme(activeHeaderScheme, 0.6f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(activeHeaderScheme, 0.6f, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        this.registerAsDecorationArea(ceruleanSchemes.get("Cerulean Footer"), SubstanceSlices.DecorationAreaType.FOOTER, SubstanceSlices.DecorationAreaType.GENERAL);
        this.addOverlayPainter(TopShadowOverlayPainter.getInstance(), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new ClassicFillPainter();
        this.decorationPainter = new ArcDecorationPainter();
        this.highlightPainter = new GlassHighlightPainter();
        this.borderPainter = new GlassBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

