/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.font;

import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.substance.api.font.FontPolicy;
import org.pushingpixels.substance.api.font.FontSet;
import org.pushingpixels.substance.internal.fonts.DefaultGnomeFontPolicy;
import org.pushingpixels.substance.internal.fonts.DefaultKDEFontPolicy;
import org.pushingpixels.substance.internal.fonts.DefaultMacFontPolicy;
import org.pushingpixels.substance.internal.fonts.FontPolicies;
import org.pushingpixels.substance.internal.fonts.ScaledFontSet;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceFontUtilities {
    public static FontPolicy getDefaultFontPolicy() {
        FontPolicy defaultPolicy;
        SubstanceCoreUtilities.Platform platform = SubstanceCoreUtilities.getPlatform();
        switch (platform) {
            case MACOS: {
                defaultPolicy = new DefaultMacFontPolicy();
                break;
            }
            case KDE: {
                defaultPolicy = new DefaultKDEFontPolicy();
                break;
            }
            case GNOME: {
                defaultPolicy = new DefaultGnomeFontPolicy();
                break;
            }
            case WINDOWS: {
                defaultPolicy = FontPolicies.getDefaultWindowsPolicy();
                break;
            }
            default: {
                defaultPolicy = FontPolicies.getDefaultPlasticPolicy();
            }
        }
        SubstanceSizeUtils.resetPointsToPixelsRatio(defaultPolicy);
        final FontPolicy fontPolicy = FontPolicies.customSettingsPolicy(defaultPolicy);
        if (platform == SubstanceCoreUtilities.Platform.MACOS || platform == SubstanceCoreUtilities.Platform.KDE) {
            return fontPolicy;
        }
        return new FontPolicy(){

            @Override
            public FontSet getFontSet(String lafName, UIDefaults table) {
                FontSet baseResult = fontPolicy.getFontSet(lafName, table);
                SubstanceFontSet substanceFontSet = new SubstanceFontSet(baseResult);
                return substanceFontSet;
            }
        };
    }

    public static FontPolicy getScaledFontPolicy(final float scaleFactor) {
        final FontSet substanceCoreFontSet = SubstanceFontUtilities.getDefaultFontPolicy().getFontSet("Substance", null);
        FontPolicy newFontPolicy = new FontPolicy(){

            @Override
            public FontSet getFontSet(String lafName, UIDefaults table) {
                return new ScaledFontSet(substanceCoreFontSet, scaleFactor);
            }
        };
        return newFontPolicy;
    }

    private static class SubstanceFontSet
    implements FontSet {
        private FontSet systemFontSet;

        public SubstanceFontSet(FontSet systemFontSet) {
            this.systemFontSet = systemFontSet;
        }

        private FontUIResource getSubstanceFont(FontUIResource systemFont) {
            return systemFont;
        }

        private FontUIResource getSubstanceFont(FontUIResource systemFont, boolean toBoldify, int extraFontSize) {
            boolean isOrigItalic = systemFont.isItalic();
            int newStyle = systemFont.getStyle();
            if (toBoldify) {
                newStyle = isOrigItalic ? 3 : 1;
            }
            return new FontUIResource(systemFont.deriveFont((float)(systemFont.getSize() + extraFontSize)).deriveFont(newStyle));
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getSubstanceFont(this.systemFontSet.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getSubstanceFont(this.systemFontSet.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getSubstanceFont(this.systemFontSet.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getSubstanceFont(this.systemFontSet.getSmallFont(), false, 1);
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getSubstanceFont(this.systemFontSet.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getSubstanceFont(this.systemFontSet.getWindowTitleFont(), true, 1);
        }
    }
}

