/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Arrays;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Util;

public class RequestOptions {
    protected ResponseMode mode = ResponseMode.GET_ALL;
    protected long timeout;
    protected boolean use_anycasting;
    protected RspFilter rsp_filter;
    protected short flags;
    protected short transient_flags;
    protected Address[] exclusion_list;

    public RequestOptions() {
    }

    public RequestOptions(ResponseMode mode, long timeout2, boolean use_anycasting, RspFilter rsp_filter, Message.Flag ... flags) {
        this(mode, timeout2, use_anycasting, rsp_filter, 0);
        this.flags(flags);
    }

    public RequestOptions(ResponseMode mode, long timeout2, boolean use_anycasting, RspFilter rsp_filter, short flags) {
        this.mode = mode;
        this.timeout = timeout2;
        this.use_anycasting = use_anycasting;
        this.rsp_filter = rsp_filter;
        this.flags = flags;
    }

    public RequestOptions(ResponseMode mode, long timeout2, boolean use_anycasting, RspFilter rsp_filter) {
        this(mode, timeout2, use_anycasting, rsp_filter, null);
    }

    public RequestOptions(ResponseMode mode, long timeout2) {
        this(mode, timeout2, false, null);
    }

    public RequestOptions(ResponseMode mode, long timeout2, boolean use_anycasting) {
        this(mode, timeout2, use_anycasting, null);
    }

    public RequestOptions(RequestOptions opts) {
        this.mode = opts.mode;
        this.timeout = opts.timeout;
        this.use_anycasting = opts.use_anycasting;
        this.rsp_filter = opts.rsp_filter;
        this.flags = opts.flags;
        this.transient_flags = opts.transient_flags;
        this.exclusion_list = opts.exclusion_list;
    }

    public static RequestOptions SYNC() {
        return new RequestOptions(ResponseMode.GET_ALL, 10000L);
    }

    public static RequestOptions ASYNC() {
        return new RequestOptions(ResponseMode.GET_NONE, 10000L);
    }

    public ResponseMode getMode() {
        return this.mode;
    }

    public ResponseMode mode() {
        return this.mode;
    }

    public RequestOptions setMode(ResponseMode mode) {
        this.mode = mode;
        return this;
    }

    public RequestOptions mode(ResponseMode mode) {
        this.mode = mode;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long timeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public RequestOptions timeout(long timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public boolean getAnycasting() {
        return this.use_anycasting;
    }

    public boolean anycasting() {
        return this.use_anycasting;
    }

    public RequestOptions setAnycasting(boolean a) {
        this.use_anycasting = a;
        return this;
    }

    public RequestOptions anycasting(boolean a) {
        this.use_anycasting = a;
        return this;
    }

    public RspFilter getRspFilter() {
        return this.rsp_filter;
    }

    public RspFilter rspFilter() {
        return this.rsp_filter;
    }

    public RequestOptions setRspFilter(RspFilter filter2) {
        this.rsp_filter = filter2;
        return this;
    }

    public RequestOptions rspFilter(RspFilter filter2) {
        this.rsp_filter = filter2;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public short flags() {
        return this.flags;
    }

    public short getTransientFlags() {
        return this.transient_flags;
    }

    public short transientFlags() {
        return this.transient_flags;
    }

    public Address[] getExclusionList() {
        return this.exclusion_list;
    }

    public Address[] exclusionList() {
        return this.exclusion_list;
    }

    public boolean hasExclusionList() {
        return this.exclusion_list != null;
    }

    public boolean isFlagSet(Message.Flag flag) {
        return this.flagSet(flag);
    }

    public boolean flagSet(Message.Flag flag) {
        return flag != null && (this.flags & flag.value()) == flag.value();
    }

    public boolean transientFlagSet(Message.TransientFlag flag) {
        return flag != null && (this.transient_flags & flag.value()) == flag.value();
    }

    public RequestOptions setFlags(Message.Flag ... flags) {
        return this.flags(flags);
    }

    public RequestOptions flags(Message.Flag ... flags) {
        if (flags != null) {
            for (Message.Flag flag : flags) {
                if (flag == null) continue;
                this.flags = (short)(this.flags | flag.value());
            }
        }
        return this;
    }

    public RequestOptions setFlags(short flags) {
        short tmp = this.flags;
        this.flags = tmp = (short)(tmp | flags);
        return this;
    }

    public RequestOptions setTransientFlags(Message.TransientFlag ... flags) {
        return this.transientFlags(flags);
    }

    public RequestOptions transientFlags(Message.TransientFlag ... flags) {
        if (flags != null) {
            for (Message.TransientFlag flag : flags) {
                if (flag == null) continue;
                this.transient_flags = (short)(this.transient_flags | flag.value());
            }
        }
        return this;
    }

    public RequestOptions setTransientFlags(short flags) {
        short tmp = this.transient_flags;
        tmp = (short)(tmp | flags);
        this.transient_flags = (byte)tmp;
        return this;
    }

    public RequestOptions clearFlags(Message.Flag ... flags) {
        if (flags != null) {
            for (Message.Flag flag : flags) {
                if (flag == null) continue;
                this.flags = (short)(this.flags & ~flag.value());
            }
        }
        return this;
    }

    public RequestOptions clearTransientFlags(Message.TransientFlag ... flags) {
        if (flags != null) {
            for (Message.TransientFlag flag : flags) {
                if (flag == null) continue;
                this.transient_flags = (short)(this.transient_flags & ~flag.value());
            }
        }
        return this;
    }

    public RequestOptions exclusionList(Address ... mbrs) {
        if (mbrs == null || mbrs.length == 0) {
            return this;
        }
        this.exclusion_list = mbrs;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mode=" + this.mode).append(", timeout=" + this.timeout);
        if (this.use_anycasting) {
            sb.append(", anycasting=true");
        }
        if (this.flags > 0) {
            sb.append(", flags=" + Util.flagsToString(this.flags));
        }
        if (this.transient_flags > 0) {
            sb.append(", transient_flags=" + Util.transientFlagsToString(this.transient_flags));
        }
        if (this.exclusion_list != null) {
            sb.append(", exclusion list: " + Arrays.toString(this.exclusion_list));
        }
        return sb.toString();
    }
}

