/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.java15;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;

public class ProxyDiagnostics {
    private URI destURI;
    public static final String DEFAULT_DESTINATION = "https://ant.apache.org/";

    public ProxyDiagnostics(String destination) {
        try {
            this.destURI = new URI(destination);
        }
        catch (URISyntaxException e) {
            throw new BuildException(e);
        }
    }

    public ProxyDiagnostics() {
        this(DEFAULT_DESTINATION);
    }

    public String toString() {
        ProxySelector selector = ProxySelector.getDefault();
        StringBuilder result2 = new StringBuilder();
        for (Proxy proxy : selector.select(this.destURI)) {
            SocketAddress address = proxy.address();
            if (address == null) {
                result2.append("Direct connection\n");
                continue;
            }
            result2.append(proxy);
            if (address instanceof InetSocketAddress) {
                InetSocketAddress ina = (InetSocketAddress)address;
                result2.append(' ');
                result2.append(ina.getHostName());
                result2.append(':');
                result2.append(ina.getPort());
                if (ina.isUnresolved()) {
                    result2.append(" [unresolved]");
                } else {
                    InetAddress addr = ina.getAddress();
                    result2.append(" [");
                    result2.append(addr.getHostAddress());
                    result2.append(']');
                }
            }
            result2.append('\n');
        }
        return result2.toString();
    }
}

