/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.pip;

import java.awt.RenderingHints;
import net.runelite.api.Skill;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="pip")
public interface PictureInPictureConfig
extends Config {
    @ConfigSection(name="Size and Position", description="Size, quality, and position settings for the picture in picture window", position=0)
    public static final String sizeAndPosition = "sizeAndPosition";
    @ConfigSection(name="Image Quality", description="Image Quality Settings", position=1)
    public static final String imageQuality = "imageQuality";
    @ConfigSection(name="Status Bars", description="Status Bar settings", position=2)
    public static final String statusBars = "statusBars";

    @ConfigItem(keyName="quadrantID", name="Position", description="Configures the position of the Picture in Picture", position=0, section="sizeAndPosition")
    default public quadrant quadrantID() {
        return quadrant.BOTTOM_RIGHT;
    }

    @ConfigItem(keyName="paddingX", name="Horizontal Padding", description="The horizontal padding (in pixels) from the left/right edge of the screen", position=1, section="sizeAndPosition")
    default public int paddingX() {
        return 40;
    }

    @ConfigItem(keyName="paddingY", name="Vertical Padding", description="The vertical padding (in pixels) from the top/bottom edge of the screen", position=2, section="sizeAndPosition")
    default public int paddingY() {
        return 25;
    }

    @ConfigItem(keyName="targetSize", name="Target Size", description="Specifies the target size of the Picture in Picture", position=3, section="sizeAndPosition")
    default public targetSize targetSize() {
        return targetSize.MEDIUM;
    }

    @ConfigItem(keyName="limitedDimension", name="Limited Dimension", description="Configures which dimension is limited when not 16:9", position=4, section="sizeAndPosition")
    default public limitedDimension limitedDimension() {
        return limitedDimension.HEIGHT;
    }

    @ConfigItem(keyName="borderWidth", name="Border Width", description="Sets the border width of the Picture in Picture window", position=5, section="sizeAndPosition")
    @Range(min=0, max=20)
    default public int borderWidth() {
        return 2;
    }

    @ConfigItem(keyName="clickAction", name="Click Action", description="Action to perform when the Picture in Picture is clicked", position=6, section="sizeAndPosition")
    default public clickAction clickAction() {
        return clickAction.REQUEST_FOCUS;
    }

    @ConfigItem(keyName="shiftClickAction", name="Shift Click Action", description="Action to perform when the Picture in Picture is shift clicked", position=7, section="sizeAndPosition")
    default public clickAction shiftClickAction() {
        return clickAction.DRAG_MODE;
    }

    @ConfigItem(keyName="preserveShiftDrag", name="Preserve Shift+Drag", description="Save the PIP location following Shift+Drag", position=8, section="sizeAndPosition")
    default public boolean preserveShiftDrag() {
        return true;
    }

    @ConfigItem(keyName="redrawRate", name="Redraw Rate", description="Configures the redraw rate of the Picture in Picture", position=0, section="imageQuality")
    default public redrawRate redrawRate() {
        return redrawRate.STANDARD;
    }

    @ConfigItem(keyName="renderQuality", name="Render Quality", description="Configures the render quality of the Picture in Picture", position=1, section="imageQuality")
    default public renderQuality renderQuality() {
        return renderQuality.MEDIUM;
    }

    @ConfigItem(keyName="leftBar", name="Left Bar", description="Configures the left status bar", position=0, section="statusBars")
    default public barType leftBar() {
        return barType.HITPOINTS;
    }

    @ConfigItem(keyName="rightBar", name="Right Bar", description="Configures the right status bar", position=1, section="statusBars")
    default public barType rightBar() {
        return barType.PRAYER;
    }

    @ConfigItem(keyName="barPosition", name="Bar Position", description="Sets the position of the status bars relative to the picture in picture", position=2, section="statusBars")
    default public barPosition barPosition() {
        return barPosition.OUTSIDE;
    }

    @ConfigItem(position=3, keyName="barWidth", name="Bar Width", description="Specify the width of status bars (1-50)", section="statusBars")
    @Range(min=1, max=50)
    default public int getBarWidth() {
        return 20;
    }

    @ConfigItem(keyName="barText", name="Show Bar Text", description="Shows current value of the status on the bar (Bar Width >=15)", position=4, section="statusBars")
    default public boolean barText() {
        return true;
    }

    public static enum quadrant {
        BOTTOM_RIGHT("Bottom Right", 4),
        BOTTOM_LEFT("Bottom Left", 3),
        TOP_LEFT("Top Left", 2),
        TOP_RIGHT("Top Right", 1);

        private final String value;
        private final int id;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public int getId() {
            return this.id;
        }

        private quadrant(String value, int id) {
            this.value = value;
            this.id = id;
        }
    }

    public static enum targetSize {
        SMALL("320 x 180", 320, 180),
        MEDIUM("480 x 270", 480, 270),
        LARGE("640 x 360", 640, 360),
        XLARGE("800 x 450", 800, 450);

        private final String value;
        private final int width;
        private final int height;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        private targetSize(String value, int width, int height) {
            this.value = value;
            this.width = width;
            this.height = height;
        }
    }

    public static enum limitedDimension {
        HEIGHT("Height"),
        WIDTH("Width");

        private final String value;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        private limitedDimension(String value) {
            this.value = value;
        }
    }

    public static enum clickAction {
        REQUEST_FOCUS("Request Focus", 0),
        FORCE_FOCUS("Force Focus", 1),
        DRAG_MODE("Drag Mode", 2),
        DO_NOTHING("Do Nothing", 3);

        private final String value;
        private final int action;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public int getAction() {
            return this.action;
        }

        private clickAction(String value, int action) {
            this.value = value;
            this.action = action;
        }
    }

    public static enum redrawRate {
        FASTEST("Fastest", 2),
        STANDARD("Standard", 4),
        SLOWER("Slower", 8),
        SLOWEST("Slowest", 16);

        private final String value;
        private final int id;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public int getId() {
            return this.id;
        }

        private redrawRate(String value, int id) {
            this.value = value;
            this.id = id;
        }
    }

    public static enum renderQuality {
        LOW("Low", RenderingHints.VALUE_RENDER_SPEED, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, 1),
        MEDIUM("Medium", RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.VALUE_INTERPOLATION_BILINEAR, 1),
        HIGH("High", RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.VALUE_INTERPOLATION_BILINEAR, 2);

        private final String value;
        private final Object quality;
        private final Object hint;
        private final int redraw;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public Object getQuality() {
            return this.quality;
        }

        public Object getHint() {
            return this.hint;
        }

        public int getRedraw() {
            return this.redraw;
        }

        private renderQuality(String value, Object quality, Object hint, int redraw) {
            this.value = value;
            this.quality = quality;
            this.hint = hint;
            this.redraw = redraw;
        }
    }

    public static enum barType {
        HITPOINTS("Hitpoints", Skill.HITPOINTS),
        PRAYER("Prayer", Skill.PRAYER),
        NONE("Disabled", null);

        private final String value;
        private final Skill skill;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public Skill getSkill() {
            return this.skill;
        }

        private barType(String value, Skill skill) {
            this.value = value;
            this.skill = skill;
        }
    }

    public static enum barPosition {
        BEFORE("Before", 0),
        AFTER("After", 1),
        OUTSIDE("Outside", 2);

        private final String value;
        private final int position;

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }

        public int getPosition() {
            return this.position;
        }

        private barPosition(String value, int position) {
            this.value = value;
            this.position = position;
        }
    }
}

