/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.mousehighlight;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.VarClientInt;
import net.runelite.client.plugins.mousehighlight.MouseHighlightConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

class MouseHighlightOverlay
extends Overlay {
    private static final Set<MenuAction> WIDGET_MENU_ACTIONS = ImmutableSet.of(MenuAction.WIDGET_TYPE_1, MenuAction.WIDGET_TYPE_4, MenuAction.WIDGET_TYPE_5, MenuAction.ITEM_FIRST_OPTION, MenuAction.ITEM_SECOND_OPTION, MenuAction.ITEM_THIRD_OPTION, new MenuAction[]{MenuAction.ITEM_FOURTH_OPTION, MenuAction.ITEM_FIFTH_OPTION, MenuAction.ITEM_USE, MenuAction.WIDGET_FIRST_OPTION, MenuAction.WIDGET_SECOND_OPTION, MenuAction.WIDGET_THIRD_OPTION, MenuAction.WIDGET_FOURTH_OPTION, MenuAction.WIDGET_FIFTH_OPTION, MenuAction.EXAMINE_ITEM, MenuAction.CC_OP_LOW_PRIORITY, MenuAction.CC_OP});
    private final TooltipManager tooltipManager;
    private final Client client;
    private final MouseHighlightConfig config;

    @Inject
    MouseHighlightOverlay(Client client, TooltipManager tooltipManager, MouseHighlightConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int last2 = menuEntries.length - 1;
        if (last2 < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last2];
        String target = menuEntry.getTarget();
        String option = menuEntry.getOption();
        MenuAction type2 = menuEntry.getType();
        if (type2 == MenuAction.RUNELITE_OVERLAY || type2 == MenuAction.CC_OP_LOW_PRIORITY) {
            return null;
        }
        if (Strings.isNullOrEmpty(option)) {
            return null;
        }
        switch (option) {
            case "Walk here": 
            case "Cancel": 
            case "Continue": {
                return null;
            }
            case "Move": {
                if (!target.contains("Sliding piece")) break;
                return null;
            }
        }
        int tooltipTimeout = this.client.getVarcIntValue(VarClientInt.TOOLTIP_TIMEOUT.getIndex());
        if (tooltipTimeout > this.client.getGameCycle()) {
            return null;
        }
        int tooltipDisplayed = this.client.getVarcIntValue(VarClientInt.TOOLTIP_VISIBLE.getIndex());
        if (tooltipDisplayed == 1) {
            return null;
        }
        this.tooltipManager.addFront(new Tooltip(option + (String)(Strings.isNullOrEmpty(target) ? "" : " " + target)));
        return null;
    }
}

