/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.loottracker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MessageNode;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.account.AccountSession;
import net.runelite.client.account.SessionManager;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.game.LootManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.plugins.loottracker.LootTrackerConfig;
import net.runelite.client.plugins.loottracker.LootTrackerItem;
import net.runelite.client.plugins.loottracker.LootTrackerPanel;
import net.runelite.client.plugins.loottracker.LootTrackerPriceType;
import net.runelite.client.plugins.loottracker.LootTrackerRecord;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import net.runelite.http.api.loottracker.GameItem;
import net.runelite.http.api.loottracker.LootAggregate;
import net.runelite.http.api.loottracker.LootRecord;
import net.runelite.http.api.loottracker.LootRecordType;
import net.runelite.http.api.loottracker.LootTrackerClient;
import okhttp3.OkHttpClient;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Loot Tracker", description="Tracks loot from monsters and minigames", tags={"drops"}, enabledByDefault=false)
public class LootTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootTrackerPlugin.class);
    private static final Pattern CLUE_SCROLL_PATTERN = Pattern.compile("You have completed [0-9]+ ([a-z]+) Treasure Trails?\\.");
    private static final int THEATRE_OF_BLOOD_REGION = 12867;
    private static final int THEATRE_OF_BLOOD_LOBBY = 14642;
    @VisibleForTesting
    static final String HERBIBOAR_LOOTED_MESSAGE = "You harvest herbs from the herbiboar, whereupon it escapes.";
    private static final String HERBIBOAR_EVENT = "Herbiboar";
    private static final Pattern HERBIBOAR_HERB_SACK_PATTERN = Pattern.compile(".+(Grimy .+?) herb.+");
    private static final String SEEDPACK_EVENT = "Seed pack";
    private static final String HESPORI_LOOTED_MESSAGE = "You have successfully cleared this patch for new crops.";
    private static final String HESPORI_EVENT = "Hespori";
    private static final int HESPORI_REGION = 5021;
    private static final String CHEST_LOOTED_MESSAGE = "You find some treasure in the chest!";
    private static final Pattern ROGUES_CHEST_PATTERN = Pattern.compile("You find (a|some)([a-z\\s]*) inside.");
    private static final Pattern LARRAN_LOOTED_PATTERN = Pattern.compile("You have opened Larran's (big|small) chest .*");
    private static final String OTHER_CHEST_LOOTED_MESSAGE = "You steal some loot from the chest.";
    private static final String DORGESH_KAAN_CHEST_LOOTED_MESSAGE = "You find treasure inside!";
    private static final String GRUBBY_CHEST_LOOTED_MESSAGE = "You have opened the Grubby Chest";
    private static final Pattern HAM_CHEST_LOOTED_PATTERN = Pattern.compile("Your (?<key>[a-z]+) key breaks in the lock.*");
    private static final int HAM_STOREROOM_REGION = 10321;
    private static final Map<Integer, String> CHEST_EVENT_TYPES = new ImmutableMap.Builder<Integer, String>().put(5179, "Brimstone Chest").put(11573, "Crystal Chest").put(12093, "Larran's big chest").put(12127, "The Gauntlet").put(13113, "Larran's small chest").put(13151, "Elven Crystal Chest").put(5277, "Stone chest").put(10835, "Dorgesh-Kaan Chest").put(10834, "Dorgesh-Kaan Chest").put(7323, "Grubby Chest").put(8593, "Isle of Souls Chest").put(7827, "Dark Chest").put(13117, "Rogues' Chest").build();
    private static final Pattern SHADE_CHEST_NO_KEY_PATTERN = Pattern.compile("You need a [a-z]+ key with a [a-z]+ trim to open this chest .*");
    private static final Map<Integer, String> SHADE_CHEST_OBJECTS = new ImmutableMap.Builder<Integer, String>().put(4111, "Bronze key red").put(4112, "Bronze key brown").put(4113, "Bronze key crimson").put(4114, "Bronze key black").put(4115, "Bronze key purple").put(4116, "Steel key red").put(4117, "Steel key brown").put(4118, "Steel key crimson").put(4119, "Steel key black").put(4120, "Steel key purple").put(4121, "Black key red").put(4122, "Black key brown").put(4123, "Black key crimson").put(4124, "Black key black").put(4125, "Black key purple").put(4126, "Silver key red").put(4127, "Silver key brown").put(4128, "Silver key crimson").put(4129, "Silver key black").put(4130, "Silver key purple").put(41212, "Gold key red").put(41213, "Gold key brown").put(41214, "Gold key crimson").put(41215, "Gold key black").put(41216, "Gold key purple").build();
    private static final String COFFIN_LOOTED_MESSAGE = "You push the coffin lid aside.";
    private static final String HALLOWED_SEPULCHRE_COFFIN_EVENT = "Coffin (Hallowed Sepulchre)";
    private static final Set<Integer> HALLOWED_SEPULCHRE_MAP_REGIONS = ImmutableSet.of(Integer.valueOf(8797), Integer.valueOf(10077), Integer.valueOf(9308), Integer.valueOf(10074), Integer.valueOf(9050));
    private static final Set<Integer> LAST_MAN_STANDING_REGIONS = ImmutableSet.of(Integer.valueOf(13658), Integer.valueOf(13659), Integer.valueOf(13660), Integer.valueOf(13914), Integer.valueOf(13915), Integer.valueOf(13916), new Integer[]{13918, 13919, 13920, 14174, 14175, 14176, 14430, 14431, 14432});
    private static final Pattern PICKPOCKET_REGEX = Pattern.compile("You pick (the )?(?<target>.+)'s? pocket.*");
    private static final String BIRDNEST_EVENT = "Bird nest";
    private static final String SLAYER_BOX = "Slayer Box";
    private static final String VOTE_BOX = "Vote Box";
    private static final String CHAMPION_BOX = "Champion Box";
    private static final String PVM_BOX = "PVM Box";
    private static final String PVP_BOX = "PVP Box";
    private static final String LUXURY_BOX = "Luxury Box";
    private static final String MYSTERY_BOX = "Mystery Box";
    private static final String MINI_MYSTERY_BOX = "Mini Mystery Box";
    private static final String SUPER_MYSTERY_BOX = "Super Mystery Box";
    private static final String MINI_SUPER_MYSTERY_BOX = "Mini Super Mystery Box";
    private static final String ULTRA_MYSTERY_BOX = "Ultra Mystery Box";
    private static final String MINI_ULTRA_MYSTERY_BOX = "Mini Ultra Mystery Box";
    private static final String TOB_MYSTERY_BOX = "Theatre Of Blood Box";
    private static final String MINI_TOB_MYSTERY_BOX = "Mini Theatre Of Blood Box";
    private static final String COX_MYSTERY_BOX = "Chambers Box";
    private static final String MINI_COX_MYSTERY_BOX = "Mini Chambers Box";
    private static final String DONO_MYSTERY_BOX = "Donation Box";
    private static final String MINI_DONO_MYSTERY_BOX = "Mini Donation Box";
    private static final String ARBO_MYSTERY_BOX = "Arbograve Box";
    private static final String MINI_ARBO_MYSTERY_BOX = "Mini Arbograve Box";
    private static final String P2P_MYSTERY_BOX = "P2P Division Pass Box";
    private static final String F2P_MYSTERY_BOX = "F2P Division Pass Box";
    private static final String PARTY_MYSTERY_BOX = "Party Box";
    private static final String VOTE_MYSTERY_BOX = "Vote Mystery Box";
    private static final String SEASONAL_BOX = "Seasonal Box";
    private static final Set<Integer> BIRDNEST_IDS = ImmutableSet.of(Integer.valueOf(5070), Integer.valueOf(5071), Integer.valueOf(5072), Integer.valueOf(5073), Integer.valueOf(5074), Integer.valueOf(7413), new Integer[]{13653, 22798, 22800});
    private static final Set<Integer> SLAYER_BOX_IDS = ImmutableSet.of(Integer.valueOf(6831));
    private static final Set<Integer> VOTE_BOX_IDS = ImmutableSet.of(Integer.valueOf(6829));
    private static final Set<Integer> CHAMPION_BOX_IDS = ImmutableSet.of(Integer.valueOf(6199));
    private static final Set<Integer> LUXURY_BOX_IDS = ImmutableSet.of(Integer.valueOf(290));
    private static final Set<Integer> MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6199));
    private static final Set<Integer> MINI_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6679));
    private static final Set<Integer> SUPER_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6828));
    private static final Set<Integer> MINI_SUPER_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6677));
    private static final Set<Integer> ULTRA_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(13346));
    private static final Set<Integer> MINI_ULTRA_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6678));
    private static final Set<Integer> TOB_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(19891));
    private static final Set<Integer> MINI_TOB_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(19895));
    private static final Set<Integer> COX_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(12582));
    private static final Set<Integer> MINI_COX_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(12585));
    private static final Set<Integer> DONO_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(12588));
    private static final Set<Integer> MINI_DONO_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(19887));
    private static final Set<Integer> ARBO_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(12579));
    private static final Set<Integer> MINI_ARBO_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6680));
    private static final Set<Integer> P2P_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6829));
    private static final Set<Integer> F2P_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(6831));
    private static final Set<Integer> PARTY_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(19897));
    private static final Set<Integer> VOTE_MYSTERY_BOXES = ImmutableSet.of(Integer.valueOf(11739));
    private static final Pattern BIRDHOUSE_PATTERN = Pattern.compile("You dismantle and discard the trap, retrieving (?:(?:a|\\d{1,2}) nests?, )?10 dead birds, \\d{1,3} feathers and (\\d,?\\d{1,3}) Hunter XP\\.");
    private static final Map<Integer, String> BIRDHOUSE_XP_TO_TYPE = new ImmutableMap.Builder<Integer, String>().put(280, "Regular Bird House").put(420, "Oak Bird House").put(560, "Willow Bird House").put(700, "Teak Bird House").put(820, "Maple Bird House").put(960, "Mahogany Bird House").put(1020, "Yew Bird House").put(1140, "Magic Bird House").put(1200, "Redwood Bird House").build();
    private static final Multimap<String, String> PICKPOCKET_DISAMBIGUATION_MAP = ImmutableMultimap.of("H.A.M. Member", "Man", "H.A.M. Member", "Woman");
    private static final String CASKET_EVENT = "Casket";
    private static final String WINTERTODT_SUPPLY_CRATE_EVENT = "Supply crate (Wintertodt)";
    private static final String SPOILS_OF_WAR_EVENT = "Spoils of war";
    private static final Set<Integer> SOUL_WARS_REGIONS = ImmutableSet.of(Integer.valueOf(8493), Integer.valueOf(8749), Integer.valueOf(9005));
    private static final String TEMPOROSS_EVENT = "Reward pool (Tempoross)";
    private static final String TEMPOROSS_CASKET_EVENT = "Casket (Tempoross)";
    private static final String TEMPOROSS_LOOT_STRING = "You found some loot: ";
    private static final int TEMPOROSS_REGION = 12588;
    private static final Set<Character> VOWELS = ImmutableSet.of(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'));
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private LootTrackerConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private EventBus eventBus;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private LootManager lootManager;
    private LootTrackerPanel panel;
    private NavigationButton navButton;
    @VisibleForTesting
    String eventType;
    @VisibleForTesting
    LootRecordType lootRecordType;
    private Object metadata;
    private boolean chestLooted;
    private String lastPickpocketTarget;
    private List<String> ignoredItems = new ArrayList<String>();
    private List<String> ignoredEvents = new ArrayList<String>();
    private Multiset<Integer> inventorySnapshot;
    @Inject
    private LootTrackerClient lootTrackerClient;
    private final List<LootRecord> queuedLoots = new ArrayList<LootRecord>();

    private static Collection<ItemStack> stack(Collection<ItemStack> items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            int quantity = 0;
            for (ItemStack i : list) {
                if (i.getId() != item.getId()) continue;
                quantity = i.getQuantity();
                list.remove(i);
                break;
            }
            if (quantity > 0) {
                list.add(new ItemStack(item.getId(), item.getQuantity() + quantity, item.getLocation()));
                continue;
            }
            list.add(item);
        }
        return list;
    }

    @Provides
    LootTrackerClient provideLootTrackerClient(OkHttpClient okHttpClient) {
        return new LootTrackerClient(okHttpClient);
    }

    @Provides
    LootTrackerConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(LootTrackerConfig.class);
    }

    @Subscribe
    public void onSessionOpen(SessionOpen sessionOpen) {
        AccountSession accountSession = this.sessionManager.getAccountSession();
        if (accountSession.getUuid() != null) {
            this.lootTrackerClient.setUuid(accountSession.getUuid());
        } else {
            this.lootTrackerClient.setUuid(null);
        }
    }

    @Subscribe
    public void onSessionClose(SessionClose sessionClose) {
        this.lootTrackerClient.setUuid(null);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("loottracker")) {
            this.ignoredItems = Text.fromCSV(this.config.getIgnoredItems());
            this.ignoredEvents = Text.fromCSV(this.config.getIgnoredEvents());
            SwingUtilities.invokeLater(this.panel::updateIgnoredRecords);
        }
    }

    @Override
    protected void startUp() throws Exception {
        this.ignoredItems = Text.fromCSV(this.config.getIgnoredItems());
        this.ignoredEvents = Text.fromCSV(this.config.getIgnoredEvents());
        this.panel = new LootTrackerPanel(this, this.itemManager, this.config);
        this.spriteManager.getSpriteAsync(777, 0, this.panel::loadHeaderIcon);
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), "panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Loot Tracker").icon(icon).priority(5).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        AccountSession accountSession = this.sessionManager.getAccountSession();
        if (accountSession != null) {
            this.lootTrackerClient.setUuid(accountSession.getUuid());
            this.clientThread.invokeLater(() -> {
                switch (this.client.getGameState()) {
                    case STARTING: 
                    case UNKNOWN: {
                        return false;
                    }
                }
                this.executor.submit(() -> {
                    Collection<LootAggregate> lootRecords;
                    if (!this.config.syncPanel()) {
                        return;
                    }
                    try {
                        lootRecords = this.lootTrackerClient.get();
                    }
                    catch (IOException e) {
                        log.debug("Unable to look up loot", e);
                        return;
                    }
                    log.debug("Loaded {} data entries", (Object)lootRecords.size());
                    this.clientThread.invokeLater(() -> {
                        Collection<LootTrackerRecord> records = this.convertToLootTrackerRecord(lootRecords);
                        SwingUtilities.invokeLater(() -> this.panel.addRecords(records));
                    });
                });
                return true;
            });
        }
    }

    @Override
    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.lootTrackerClient.setUuid(null);
        this.chestLooted = false;
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown event) {
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING && !this.client.isInInstancedRegion()) {
            this.chestLooted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoot(@NonNull String name, int combatLevel, LootRecordType type2, Object metadata2, Collection<ItemStack> items) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        LootTrackerItem[] entries2 = this.buildEntries(LootTrackerPlugin.stack(items));
        SwingUtilities.invokeLater(() -> this.panel.add(name, type2, combatLevel, entries2));
        LootRecord lootRecord = new LootRecord(name, type2, metadata2, LootTrackerPlugin.toGameItems(items), Instant.now(), this.getLootWorldId());
        List<LootRecord> list = this.queuedLoots;
        synchronized (list) {
            this.queuedLoots.add(lootRecord);
        }
        this.eventBus.post(new LootReceived(name, combatLevel, type2, items));
    }

    private Integer getLootWorldId() {
        return this.client.getWorldType().contains((Object)WorldType.SEASONAL) ? Integer.valueOf(this.client.getWorld()) : null;
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        Collection<ItemStack> items = npcLootReceived.getItems();
        String name = npc.getName();
        int combat = npc.getCombatLevel();
        this.addLoot(name, combat, LootRecordType.NPC, npc.getId(), items);
        if (this.config.npcKillChatMessage()) {
            String prefix = VOWELS.contains(Character.valueOf(Character.toLowerCase(name.charAt(0)))) ? "an" : "a";
            this.lootReceivedChatMessage(items, prefix + " " + name);
        }
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        if (this.isPlayerWithinMapRegion(LAST_MAN_STANDING_REGIONS) || this.isPlayerWithinMapRegion(SOUL_WARS_REGIONS)) {
            return;
        }
        Player player = playerLootReceived.getPlayer();
        Collection<ItemStack> items = playerLootReceived.getItems();
        String name = player.getName();
        int combat = player.getCombatLevel();
        this.addLoot(name, combat, LootRecordType.PLAYER, null, items);
        if (this.config.pvpKillChatMessage()) {
            this.lootReceivedChatMessage(items, name);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        ItemContainer container;
        switch (widgetLoaded.getGroupId()) {
            case 100049: {
                this.setEvent(LootRecordType.EVENT, "Barrows");
                container = this.client.getItemContainer(InventoryID.BARROWS_REWARD);
                break;
            }
            case 100061: {
                if (this.chestLooted) {
                    return;
                }
                this.setEvent(LootRecordType.EVENT, "Chambers of Xeric");
                container = this.client.getItemContainer(InventoryID.CHAMBERS_OF_XERIC_CHEST);
                this.chestLooted = true;
                break;
            }
            case 100077: {
                if (this.chestLooted) {
                    return;
                }
                int region = WorldPoint.fromLocalInstance(this.client, this.client.getLocalPlayer().getLocalLocation()).getRegionID();
                if (region != 12867 && region != 14642) {
                    return;
                }
                this.setEvent(LootRecordType.EVENT, "Theatre of Blood");
                container = this.client.getItemContainer(InventoryID.THEATRE_OF_BLOOD_CHEST);
                this.chestLooted = true;
                break;
            }
            case 100048: {
                container = this.client.getItemContainer(InventoryID.BARROWS_REWARD);
                if (this.eventType != null) break;
                log.debug("Clue scroll reward interface with no event!");
                return;
            }
            case 100065: {
                this.setEvent(LootRecordType.EVENT, "Kingdom of Miscellania");
                container = this.client.getItemContainer(InventoryID.KINGDOM_OF_MISCELLANIA);
                break;
            }
            case 100087: {
                this.setEvent(LootRecordType.EVENT, "Fishing Trawler", this.client.getBoostedSkillLevel(Skill.FISHING));
                container = this.client.getItemContainer(InventoryID.FISHING_TRAWLER_REWARD);
                break;
            }
            case 100081: {
                this.setEvent(LootRecordType.EVENT, "Drift Net", this.client.getBoostedSkillLevel(Skill.FISHING));
                container = this.client.getItemContainer(InventoryID.DRIFT_NET_FISHING_REWARD);
                break;
            }
            default: {
                return;
            }
        }
        if (container == null) {
            return;
        }
        Collection items = Arrays.stream(container.getItems()).filter(item -> item.getId() > 0).map(item -> new ItemStack(item.getId(), item.getQuantity(), this.client.getLocalPlayer().getLocalLocation())).collect(Collectors.toList());
        if (this.config.showRaidsLootValue() && (this.eventType.equals("Theatre of Blood") || this.eventType.equals("Chambers of Xeric"))) {
            long totalValue = items.stream().filter(item -> item.getId() > -1).mapToLong(item -> this.config.priceType() == LootTrackerPriceType.GRAND_EXCHANGE ? this.itemManager.getItemPrice(item.getId()) * item.getQuantity() : this.itemManager.getItemComposition(item.getId()).getHaPrice() * item.getQuantity()).sum();
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Your loot is worth around ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber(totalValue)).append(ChatColorType.NORMAL).append(" coins.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(chatMessage).build());
        }
        if (items.isEmpty()) {
            log.debug("No items to find for Event: {} | Container: {}", (Object)this.eventType, (Object)container);
            return;
        }
        this.addLoot(this.eventType, -1, this.lootRecordType, this.metadata, items);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = event.getMessage();
        if (message.equals(CHEST_LOOTED_MESSAGE) || message.equals(OTHER_CHEST_LOOTED_MESSAGE) || message.equals(DORGESH_KAAN_CHEST_LOOTED_MESSAGE) || message.startsWith(GRUBBY_CHEST_LOOTED_MESSAGE) || LARRAN_LOOTED_PATTERN.matcher(message).matches() || ROGUES_CHEST_PATTERN.matcher(message).matches()) {
            int regionID = this.client.getLocalPlayer().getWorldLocation().getRegionID();
            if (!CHEST_EVENT_TYPES.containsKey(regionID)) {
                return;
            }
            this.setEvent(LootRecordType.EVENT, CHEST_EVENT_TYPES.get(regionID));
            this.takeInventorySnapshot();
            return;
        }
        if (message.equals(COFFIN_LOOTED_MESSAGE) && this.isPlayerWithinMapRegion(HALLOWED_SEPULCHRE_MAP_REGIONS)) {
            this.setEvent(LootRecordType.EVENT, HALLOWED_SEPULCHRE_COFFIN_EVENT);
            this.takeInventorySnapshot();
            return;
        }
        if (message.equals(HERBIBOAR_LOOTED_MESSAGE)) {
            if (this.processHerbiboarHerbSackLoot(event.getTimestamp())) {
                return;
            }
            this.setEvent(LootRecordType.EVENT, HERBIBOAR_EVENT, this.client.getBoostedSkillLevel(Skill.HERBLORE));
            this.takeInventorySnapshot();
            return;
        }
        int regionID = this.client.getLocalPlayer().getWorldLocation().getRegionID();
        if (5021 == regionID && message.equals(HESPORI_LOOTED_MESSAGE)) {
            this.setEvent(LootRecordType.EVENT, HESPORI_EVENT);
            this.takeInventorySnapshot();
            return;
        }
        Matcher hamStoreroomMatcher = HAM_CHEST_LOOTED_PATTERN.matcher(message);
        if (hamStoreroomMatcher.matches() && regionID == 10321) {
            String keyType = hamStoreroomMatcher.group("key");
            this.setEvent(LootRecordType.EVENT, String.format("H.A.M. chest (%s)", keyType));
            this.takeInventorySnapshot();
            return;
        }
        Matcher pickpocketMatcher = PICKPOCKET_REGEX.matcher(message);
        if (pickpocketMatcher.matches()) {
            String pickpocketTarget = WordUtils.capitalize(pickpocketMatcher.group("target"));
            if (PICKPOCKET_DISAMBIGUATION_MAP.get(this.lastPickpocketTarget).contains(pickpocketTarget)) {
                this.setEvent(LootRecordType.PICKPOCKET, this.lastPickpocketTarget);
            } else {
                this.setEvent(LootRecordType.PICKPOCKET, pickpocketTarget);
            }
            this.takeInventorySnapshot();
            return;
        }
        Matcher m3 = CLUE_SCROLL_PATTERN.matcher(Text.removeTags(message));
        if (m3.find()) {
            String type2;
            switch (type2 = m3.group(1).toLowerCase()) {
                case "beginner": {
                    this.setEvent(LootRecordType.EVENT, "Clue Scroll (Beginner)");
                    return;
                }
                case "easy": {
                    this.setEvent(LootRecordType.EVENT, "Clue Scroll (Easy)");
                    return;
                }
                case "medium": {
                    this.setEvent(LootRecordType.EVENT, "Clue Scroll (Medium)");
                    return;
                }
                case "hard": {
                    this.setEvent(LootRecordType.EVENT, "Clue Scroll (Hard)");
                    return;
                }
                case "elite": {
                    this.setEvent(LootRecordType.EVENT, "Clue Scroll (Elite)");
                    return;
                }
                case "master": {
                    this.setEvent(LootRecordType.EVENT, "Clue Scroll (Master)");
                    return;
                }
            }
        }
        if (SHADE_CHEST_NO_KEY_PATTERN.matcher(message).matches()) {
            this.resetEvent();
            return;
        }
        Matcher matcher = BIRDHOUSE_PATTERN.matcher(message);
        if (matcher.matches()) {
            int xp = Integer.parseInt(matcher.group(1));
            String type3 = BIRDHOUSE_XP_TO_TYPE.get(xp);
            if (type3 == null) {
                log.debug("Unknown bird house type {}", (Object)xp);
                return;
            }
            this.setEvent(LootRecordType.EVENT, type3, this.client.getBoostedSkillLevel(Skill.HUNTER));
            this.takeInventorySnapshot();
        }
        if (regionID == 12588 && message.startsWith(TEMPOROSS_LOOT_STRING)) {
            this.setEvent(LootRecordType.EVENT, TEMPOROSS_EVENT, this.client.getBoostedSkillLevel(Skill.FISHING));
            this.takeInventorySnapshot();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId() || this.eventType == null) {
            return;
        }
        if (CHEST_EVENT_TYPES.containsValue(this.eventType) || SHADE_CHEST_OBJECTS.containsValue(this.eventType) || HALLOWED_SEPULCHRE_COFFIN_EVENT.equals(this.eventType) || HERBIBOAR_EVENT.equals(this.eventType) || HESPORI_EVENT.equals(this.eventType) || WINTERTODT_SUPPLY_CRATE_EVENT.equals(this.eventType) || this.eventType.endsWith("Bird House") || this.eventType.startsWith("H.A.M. chest") || this.lootRecordType == LootRecordType.PICKPOCKET || this.eventType.endsWith("lockbox")) {
            WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
            Collection<ItemStack> groundItems = this.lootManager.getItemSpawns(playerLocation);
            this.processInventoryLoot(this.eventType, this.lootRecordType, this.metadata, event.getItemContainer(), groundItems);
            this.resetEvent();
        } else if (SEEDPACK_EVENT.equals(this.eventType) || CASKET_EVENT.equals(this.eventType) || BIRDNEST_EVENT.equals(this.eventType) || SLAYER_BOX.equals(this.eventType) || VOTE_BOX.equals(this.eventType) || CHAMPION_BOX.equals(this.eventType) || LUXURY_BOX.equals(this.eventType) || MYSTERY_BOX.equals(this.eventType) || MINI_MYSTERY_BOX.equals(this.eventType) || SUPER_MYSTERY_BOX.equals(this.eventType) || MINI_SUPER_MYSTERY_BOX.equals(this.eventType) || ULTRA_MYSTERY_BOX.equals(this.eventType) || MINI_ULTRA_MYSTERY_BOX.equals(this.eventType) || TOB_MYSTERY_BOX.equals(this.eventType) || MINI_TOB_MYSTERY_BOX.equals(this.eventType) || COX_MYSTERY_BOX.equals(this.eventType) || MINI_COX_MYSTERY_BOX.equals(this.eventType) || DONO_MYSTERY_BOX.equals(this.eventType) || MINI_DONO_MYSTERY_BOX.equals(this.eventType) || ARBO_MYSTERY_BOX.equals(this.eventType) || MINI_ARBO_MYSTERY_BOX.equals(this.eventType) || P2P_MYSTERY_BOX.equals(this.eventType) || F2P_MYSTERY_BOX.equals(this.eventType) || PARTY_MYSTERY_BOX.equals(this.eventType) || VOTE_MYSTERY_BOX.equals(this.eventType) || PVM_BOX.equals(this.eventType) || PVP_BOX.equals(this.eventType) || SEASONAL_BOX.equals(this.eventType) || SPOILS_OF_WAR_EVENT.equals(this.eventType) || TEMPOROSS_EVENT.equals(this.eventType) || TEMPOROSS_CASKET_EVENT.equals(this.eventType)) {
            this.processInventoryLoot(this.eventType, this.lootRecordType, this.metadata, event.getItemContainer(), Collections.emptyList());
            this.resetEvent();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (LootTrackerPlugin.isNPCOp(event.getMenuAction()) && event.getMenuOption().equals("Pickpocket")) {
            this.lastPickpocketTarget = Text.removeTags(event.getMenuTarget());
        } else if (LootTrackerPlugin.isObjectOp(event.getMenuAction()) && event.getMenuOption().equals("Open") && SHADE_CHEST_OBJECTS.containsKey(event.getId())) {
            this.setEvent(LootRecordType.EVENT, SHADE_CHEST_OBJECTS.get(event.getId()));
            this.takeInventorySnapshot();
        } else if (LootTrackerPlugin.isItemOp(event.getMenuAction())) {
            if (event.getMenuOption().equals("Take") && event.getId() == 22993) {
                this.setEvent(LootRecordType.EVENT, SEEDPACK_EVENT);
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Search") && BIRDNEST_IDS.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, BIRDNEST_EVENT, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && VOTE_BOX_IDS.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, VOTE_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && CHAMPION_BOX_IDS.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, CHAMPION_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && LUXURY_BOX_IDS.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, LUXURY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && SUPER_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && SUPER_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, SUPER_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_SUPER_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_SUPER_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_SUPER_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && ULTRA_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && ULTRA_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, ULTRA_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_ULTRA_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_ULTRA_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_ULTRA_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && TOB_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && TOB_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, TOB_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_TOB_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_TOB_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_TOB_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && COX_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && COX_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, COX_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_COX_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_COX_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_COX_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && DONO_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && DONO_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, DONO_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_DONO_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_DONO_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_DONO_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && ARBO_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && ARBO_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, ARBO_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && MINI_ARBO_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && MINI_ARBO_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, MINI_ARBO_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && P2P_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && P2P_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, P2P_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && F2P_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && F2P_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, F2P_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && PARTY_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && PARTY_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, PARTY_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && VOTE_MYSTERY_BOXES.contains(event.getId()) || event.getMenuOption().equalsIgnoreCase("Quick-Open") && VOTE_MYSTERY_BOXES.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, VOTE_MYSTERY_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open") && SLAYER_BOX_IDS.contains(event.getId())) {
                this.setEvent(LootRecordType.EVENT, SLAYER_BOX, event.getId());
                this.takeInventorySnapshot();
            } else if (event.getMenuOption().equals("Open")) {
                switch (event.getId()) {
                    case 405: {
                        this.setEvent(LootRecordType.EVENT, CASKET_EVENT);
                        this.takeInventorySnapshot();
                        break;
                    }
                    case 20703: 
                    case 20791: {
                        this.setEvent(LootRecordType.EVENT, WINTERTODT_SUPPLY_CRATE_EVENT);
                        this.takeInventorySnapshot();
                        break;
                    }
                    case 25342: {
                        this.setEvent(LootRecordType.EVENT, SPOILS_OF_WAR_EVENT);
                        this.takeInventorySnapshot();
                        break;
                    }
                    case 25590: {
                        this.setEvent(LootRecordType.EVENT, TEMPOROSS_CASKET_EVENT);
                        this.takeInventorySnapshot();
                        break;
                    }
                    case 25647: 
                    case 25649: 
                    case 25651: {
                        this.setEvent(LootRecordType.EVENT, this.itemManager.getItemComposition(event.getId()).getName());
                        this.takeInventorySnapshot();
                    }
                }
            }
        }
    }

    private static boolean isItemOp(MenuAction menuAction) {
        int id = menuAction.getId();
        return id >= MenuAction.ITEM_FIRST_OPTION.getId() && id <= MenuAction.ITEM_FIFTH_OPTION.getId();
    }

    private static boolean isNPCOp(MenuAction menuAction) {
        int id = menuAction.getId();
        return id >= MenuAction.NPC_FIRST_OPTION.getId() && id <= MenuAction.NPC_FIFTH_OPTION.getId();
    }

    private static boolean isObjectOp(MenuAction menuAction) {
        int id = menuAction.getId();
        return id >= MenuAction.GAME_OBJECT_FIRST_OPTION.getId() && id <= MenuAction.GAME_OBJECT_FOURTH_OPTION.getId() || id == MenuAction.GAME_OBJECT_FIFTH_OPTION.getId();
    }

    @Schedule(period=5L, unit=ChronoUnit.MINUTES, asynchronous=true)
    public void submitLootTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CompletableFuture<Void> submitLoot() {
        ArrayList<LootRecord> copy2;
        List<LootRecord> list = this.queuedLoots;
        synchronized (list) {
            if (this.queuedLoots.isEmpty()) {
                return null;
            }
            copy2 = new ArrayList<LootRecord>(this.queuedLoots);
            this.queuedLoots.clear();
        }
        if (!this.config.saveLoot()) {
            return null;
        }
        log.debug("Submitting {} loot records", (Object)copy2.size());
        return this.lootTrackerClient.submit(copy2);
    }

    private void setEvent(LootRecordType lootRecordType, String eventType, Object metadata2) {
        this.lootRecordType = lootRecordType;
        this.eventType = eventType;
        this.metadata = metadata2;
    }

    private void setEvent(LootRecordType lootRecordType, String eventType) {
        this.setEvent(lootRecordType, eventType, null);
    }

    private void resetEvent() {
        this.lootRecordType = null;
        this.eventType = null;
        this.metadata = null;
    }

    private void takeInventorySnapshot() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer != null) {
            this.inventorySnapshot = HashMultiset.create();
            Arrays.stream(itemContainer.getItems()).forEach(item -> this.inventorySnapshot.add(item.getId(), item.getQuantity()));
        }
    }

    private void processInventoryLoot(String event, LootRecordType lootRecordType, Object metadata2, ItemContainer inventoryContainer, Collection<ItemStack> groundItems) {
        if (this.inventorySnapshot != null) {
            HashMultiset currentInventory = HashMultiset.create();
            Arrays.stream(inventoryContainer.getItems()).forEach(item -> currentInventory.add(item.getId(), item.getQuantity()));
            groundItems.stream().forEach(item -> currentInventory.add(item.getId(), item.getQuantity()));
            Multiset diff = Multisets.difference(currentInventory, this.inventorySnapshot);
            List<ItemStack> items = diff.entrySet().stream().map(e -> new ItemStack((Integer)e.getElement(), e.getCount(), this.client.getLocalPlayer().getLocalLocation())).collect(Collectors.toList());
            this.addLoot(event, -1, lootRecordType, metadata2, items);
            this.inventorySnapshot = null;
        }
    }

    private boolean processHerbiboarHerbSackLoot(int timestamp) {
        ArrayList<ItemStack> herbs = new ArrayList<ItemStack>();
        for (MessageNode messageNode : this.client.getMessages()) {
            Matcher matcher;
            if (messageNode.getTimestamp() != timestamp || messageNode.getType() != ChatMessageType.SPAM || !(matcher = HERBIBOAR_HERB_SACK_PATTERN.matcher(messageNode.getValue())).matches()) continue;
            herbs.add(new ItemStack(this.itemManager.search(matcher.group(1)).get(0).getId(), 1, this.client.getLocalPlayer().getLocalLocation()));
        }
        if (herbs.isEmpty()) {
            return false;
        }
        int herbloreLevel = this.client.getBoostedSkillLevel(Skill.HERBLORE);
        this.addLoot(HERBIBOAR_EVENT, -1, LootRecordType.EVENT, herbloreLevel, herbs);
        return true;
    }

    void toggleItem(String name, boolean ignore) {
        LinkedHashSet<String> ignoredItemSet = new LinkedHashSet<String>(this.ignoredItems);
        if (ignore) {
            ignoredItemSet.add(name);
        } else {
            ignoredItemSet.remove(name);
        }
        this.config.setIgnoredItems(Text.toCSV(ignoredItemSet));
    }

    boolean isIgnored(String name) {
        return this.ignoredItems.contains(name);
    }

    void toggleEvent(String name, boolean ignore) {
        LinkedHashSet<String> ignoredSet = new LinkedHashSet<String>(this.ignoredEvents);
        if (ignore) {
            ignoredSet.add(name);
        } else {
            ignoredSet.remove(name);
        }
        this.config.setIgnoredEvents(Text.toCSV(ignoredSet));
    }

    boolean isEventIgnored(String name) {
        return this.ignoredEvents.contains(name);
    }

    private LootTrackerItem buildLootTrackerItem(int itemId, int quantity) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        int gePrice = this.itemManager.getItemPrice(itemId);
        int haPrice = itemComposition.getHaPrice();
        boolean ignored = this.ignoredItems.contains(itemComposition.getName());
        return new LootTrackerItem(itemId, itemComposition.getName(), quantity, gePrice, haPrice, ignored);
    }

    private LootTrackerItem[] buildEntries(Collection<ItemStack> itemStacks) {
        return (LootTrackerItem[])itemStacks.stream().map(itemStack -> this.buildLootTrackerItem(itemStack.getId(), itemStack.getQuantity())).toArray(LootTrackerItem[]::new);
    }

    private static Collection<GameItem> toGameItems(Collection<ItemStack> items) {
        return items.stream().map(item -> new GameItem(item.getId(), item.getQuantity())).collect(Collectors.toList());
    }

    private Collection<LootTrackerRecord> convertToLootTrackerRecord(Collection<LootAggregate> records) {
        return records.stream().sorted(Comparator.comparing(LootAggregate::getLast_time)).map(record -> {
            LootTrackerItem[] drops = (LootTrackerItem[])record.getDrops().stream().map(itemStack -> this.buildLootTrackerItem(itemStack.getId(), itemStack.getQty())).toArray(LootTrackerItem[]::new);
            return new LootTrackerRecord(record.getEventId(), "", record.getType(), drops, record.getAmount());
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean isPlayerWithinMapRegion(Set<Integer> definedMapRegions) {
        int[] mapRegions;
        for (int region : mapRegions = this.client.getMapRegions()) {
            if (!definedMapRegions.contains(region)) continue;
            return true;
        }
        return false;
    }

    private long getTotalPrice(Collection<ItemStack> items) {
        long totalPrice = 0L;
        for (ItemStack itemStack : items) {
            totalPrice += (long)this.itemManager.getItemPrice(itemStack.getId()) * (long)itemStack.getQuantity();
        }
        return totalPrice;
    }

    private void lootReceivedChatMessage(Collection<ItemStack> items, String name) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You've killed ").append(name).append(" for ").append(QuantityFormatter.quantityToStackSize(this.getTotalPrice(items))).append(" loot.").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    LootTrackerClient getLootTrackerClient() {
        return this.lootTrackerClient;
    }
}

