/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene;

import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.model.ModelPusher;
import net.runelite.client.plugins.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.hd.utils.AABB;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.ModelHash;
import net.runelite.client.plugins.hd.utils.Props;
import net.runelite.client.plugins.hd.utils.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ModelOverrideManager {
    private static final Logger log = LoggerFactory.getLogger(ModelOverrideManager.class);
    private static final ResourcePath MODEL_OVERRIDES_PATH = Props.getPathOrDefault("rlhd.model-overrides-path", () -> ResourcePath.path(ModelOverrideManager.class, "model_overrides.json"));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private ModelPusher modelPusher;
    private final HashMap<Long, ModelOverride> modelOverrides = new HashMap();
    private final HashMap<Long, AABB[]> modelsToHide = new HashMap();

    public void startUp() {
        MODEL_OVERRIDES_PATH.watch(path -> {
            this.modelOverrides.clear();
            this.modelsToHide.clear();
            try {
                ModelOverride[] entries2 = path.loadJson(this.plugin.getGson(), ModelOverride[].class);
                if (entries2 == null) {
                    throw new IOException("Empty or invalid: " + path);
                }
                for (ModelOverride override : entries2) {
                    override.gsonReallyShouldSupportThis();
                    for (int npcId : override.npcIds) {
                        this.addEntry(ModelHash.packUuid(npcId, 1), override);
                    }
                    for (int objectId : override.objectIds) {
                        this.addEntry(ModelHash.packUuid(objectId, 2), override);
                    }
                }
                this.clientThread.invoke(() -> {
                    this.modelPusher.clearModelCache();
                    if (this.client.getGameState() == GameState.LOGGED_IN) {
                        this.plugin.uploadScene();
                    }
                });
                if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
                    log.debug("Loaded {} model overrides", (Object)this.modelOverrides.size());
                }
            }
            catch (IOException ex) {
                log.error("Failed to load model overrides:", ex);
            }
        });
    }

    private void addEntry(long uuid, ModelOverride entry) {
        ModelOverride old = this.modelOverrides.put(uuid, entry);
        this.modelsToHide.put(uuid, entry.hideInAreas);
        if (Props.DEVELOPMENT && old != null) {
            if (entry.hideInAreas.length > 0) {
                log.warn("Replacing ID {} from '{}' with hideInAreas-override '{}'. This is likely a mistake...", ModelHash.getIdOrIndex(uuid), old.description, entry.description);
            } else if (old.hideInAreas.length == 0) {
                log.warn("Replacing ID {} from '{}' with '{}'. The first-mentioned override should be removed.", ModelHash.getIdOrIndex(uuid), old.description, entry.description);
            }
        }
    }

    public boolean shouldHideModel(long hash, int x, int z) {
        assert (this.client.isClientThread());
        long uuid = ModelHash.getUuid(this.client, hash);
        AABB[] aabbs = this.modelsToHide.get(uuid);
        if (aabbs != null && this.hasNoActions(uuid)) {
            WorldPoint location = HDUtils.cameraSpaceToWorldPoint(this.client, x, z);
            for (AABB aabb : aabbs) {
                if (!aabb.contains(location)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNoActions(long uuid) {
        int id = ModelHash.getIdOrIndex(uuid);
        int type2 = ModelHash.getType(uuid);
        String[] actions = new String[]{};
        switch (type2) {
            case 2: {
                actions = this.client.getObjectDefinition(id).getActions();
                break;
            }
            case 1: {
                actions = this.client.getNpcDefinition(id).getActions();
            }
        }
        for (String action : actions) {
            if (action == null) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public ModelOverride getOverride(long hash) {
        return this.modelOverrides.getOrDefault(ModelHash.getUuid(this.client, hash), ModelOverride.NONE);
    }
}

