/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIDummyUpstreamSurfaceHook;
import jogamp.nativewindow.windows.GDISurface;
import jogamp.nativewindow.windows.RegisteredClassFactory;
import jogamp.opengl.Debug;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WindowsBitmapWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsExternalWGLContext;
import jogamp.opengl.windows.wgl.WindowsExternalWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsOnscreenWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsPbufferWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLDynamicLibraryBundleInfo;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsWGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final boolean DEBUG_SHAREDCTX = DEBUG || GLContext.DEBUG;
    private static final int CPU_AFFINITY_MODE;
    private static DesktopGLDynamicLookupHelper windowsWGLDynamicLookupHelper;
    private final CPUAffinity cpuAffinity;
    private WindowsGraphicsDevice defaultDevice;
    private SharedResourceImplementation sharedResourceImplementation;
    private SharedResourceRunner sharedResourceRunner;
    static final String WGL_ARB_pbuffer = "WGL_ARB_pbuffer";
    static final String WGL_ARB_pixel_format = "WGL_ARB_pixel_format";
    static final String WGL_ARB_multisample = "WGL_ARB_multisample";
    static final String WGL_NV_float_buffer = "WGL_NV_float_buffer";
    static final String WGL_ARB_make_current_read = "WGL_ARB_make_current_read";
    static final String wglMakeContextCurrent = "wglMakeContextCurrent";
    private static final int GAMMA_RAMP_LENGTH = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsWGLDrawableFactory() {
        switch (CPU_AFFINITY_MODE) {
            case 0: {
                this.cpuAffinity = new NopCPUAffinity();
                break;
            }
            default: {
                this.cpuAffinity = new WindowsProcessAffinity();
            }
        }
        Class<WindowsWGLDrawableFactory> clazz = WindowsWGLDrawableFactory.class;
        synchronized (WindowsWGLDrawableFactory.class) {
            if (null == windowsWGLDynamicLookupHelper) {
                windowsWGLDynamicLookupHelper = AccessController.doPrivileged(new PrivilegedAction<DesktopGLDynamicLookupHelper>(){

                    @Override
                    public DesktopGLDynamicLookupHelper run() {
                        DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
                        block3: {
                            try {
                                desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new WindowsWGLDynamicLibraryBundleInfo());
                                if (null != desktopGLDynamicLookupHelper && desktopGLDynamicLookupHelper.isLibComplete()) {
                                    WGL.getWGLProcAddressTable().reset(desktopGLDynamicLookupHelper);
                                }
                            }
                            catch (Exception exception) {
                                desktopGLDynamicLookupHelper = null;
                                if (!DEBUG) break block3;
                                exception.printStackTrace();
                            }
                        }
                        return desktopGLDynamicLookupHelper;
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.defaultDevice = new WindowsGraphicsDevice(0);
            if (null != windowsWGLDynamicLookupHelper) {
                WindowsWGLGraphicsConfigurationFactory.registerFactory();
                if (GLProfile.isAWTAvailable()) {
                    try {
                        ReflectionUtil.callStaticMethod("jogamp.opengl.windows.wgl.awt.WindowsAWTWGLGraphicsConfigurationFactory", "registerFactory", null, null, this.getClass().getClassLoader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sharedResourceImplementation = new SharedResourceImplementation();
                this.sharedResourceRunner = new SharedResourceRunner(this.sharedResourceImplementation);
                this.sharedResourceRunner.start();
            }
            return;
        }
    }

    @Override
    protected final boolean isComplete() {
        return null != windowsWGLDynamicLookupHelper;
    }

    @Override
    protected final void shutdownImpl() {
        if (DEBUG) {
            System.err.println("WindowsWGLDrawableFactory.shutdown");
        }
        if (null != this.sharedResourceRunner) {
            this.sharedResourceRunner.stop();
            this.sharedResourceRunner = null;
        }
        if (null != this.sharedResourceImplementation) {
            this.sharedResourceImplementation.clear();
            this.sharedResourceImplementation = null;
        }
        this.defaultDevice = null;
        windowsWGLDynamicLookupHelper = null;
        RegisteredClassFactory.shutdownSharedClasses();
    }

    @Override
    public final GLDynamicLookupHelper getGLDynamicLookupHelper(int n, int n2) {
        return windowsWGLDynamicLookupHelper;
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enterThreadCriticalZone() {
        CPUAffinity cPUAffinity = this.cpuAffinity;
        synchronized (cPUAffinity) {
            this.cpuAffinity.set(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void leaveThreadCriticalZone() {
        CPUAffinity cPUAffinity = this.cpuAffinity;
        synchronized (cPUAffinity) {
            this.cpuAffinity.reset();
        }
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return null != windowsWGLDynamicLookupHelper && abstractGraphicsDevice instanceof WindowsGraphicsDevice;
    }

    @Override
    protected final Thread getSharedResourceThread() {
        return this.sharedResourceRunner.start();
    }

    @Override
    protected final SharedResource getOrCreateSharedResourceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    protected final WindowsWGLDrawable getOrCreateSharedDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null != sharedResource) {
            return (WindowsWGLDrawable)sharedResource.getDrawable();
        }
        return null;
    }

    @Override
    public final boolean hasOpenGLDesktopSupport() {
        return true;
    }

    @Override
    public final boolean hasOpenGLESSupport() {
        return false;
    }

    @Override
    public final boolean hasMajorMinorCreateContextARB() {
        return true;
    }

    @Override
    protected List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return WindowsWGLGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected final GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new WindowsOnscreenWGLDrawable(this, nativeSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        WindowsPbufferWGLDrawable windowsPbufferWGLDrawable;
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return WindowsBitmapWGLDrawable.create(this, nativeSurface);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null != sharedResource) {
            GLContext gLContext = GLContext.getCurrent();
            if (gLContext != null) {
                gLContext.release();
            }
            sharedResource.context.makeCurrent();
            try {
                windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(this, nativeSurface);
            }
            finally {
                sharedResource.context.release();
                if (gLContext != null) {
                    gLContext.makeCurrent();
                }
            }
        } else {
            windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(this, nativeSurface);
        }
        return windowsPbufferWGLDrawable;
    }

    public final int isReadDrawableAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice);
        if (null != sharedResource) {
            return sharedResource.hasReadDrawable() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public final boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice, GLProfile gLProfile) {
        SharedResource sharedResource = this.getOrCreateSharedResourceImpl(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice);
        if (null != sharedResource) {
            return sharedResource.hasARBPBuffer();
        }
        return false;
    }

    @Override
    protected final ProxySurface createMutableSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        WindowsGraphicsDevice windowsGraphicsDevice = bl || !(abstractGraphicsDevice instanceof WindowsGraphicsDevice) ? new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID()) : (WindowsGraphicsDevice)abstractGraphicsDevice;
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, 0);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen);
        if (null == windowsWGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new WrappedSurface(windowsWGLGraphicsConfiguration, 0L, upstreamSurfaceHook, bl);
    }

    @Override
    public final ProxySurface createDummySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        WindowsGraphicsDevice windowsGraphicsDevice = bl || !(abstractGraphicsDevice instanceof WindowsGraphicsDevice) ? new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID()) : (WindowsGraphicsDevice)abstractGraphicsDevice;
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, 0);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable), gLCapabilitiesImmutable2, gLCapabilitiesChooser, defaultGraphicsScreen);
        if (null == windowsWGLGraphicsConfiguration) {
            throw new GLException("Choosing GraphicsConfiguration failed w/ " + gLCapabilitiesImmutable + " on " + defaultGraphicsScreen);
        }
        return new GDISurface(windowsWGLGraphicsConfiguration, 0L, new GDIDummyUpstreamSurfaceHook(n, n2), bl);
    }

    @Override
    public final ProxySurface createSurfacelessImpl(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOnscreenGLCapabilities(gLCapabilitiesImmutable);
        return this.createMutableSurfaceImpl(abstractGraphicsDevice, bl, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, new GenericUpstreamSurfacelessHook(n, n2));
    }

    @Override
    protected final ProxySurface createProxySurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, int n, long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, UpstreamSurfaceHook upstreamSurfaceHook) {
        WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, n);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, gLCapabilitiesChooser, defaultGraphicsScreen);
        return new GDISurface(windowsWGLGraphicsConfiguration, l, upstreamSurfaceHook, true);
    }

    @Override
    protected final GLContext createExternalGLContextImpl() {
        return WindowsExternalWGLContext.create(this, null);
    }

    @Override
    public final boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    @Override
    protected final GLDrawable createExternalGLDrawableImpl() {
        return WindowsExternalWGLDrawable.create(this, null);
    }

    static String wglGetLastError() {
        long l = GDI.GetLastError();
        String string2 = null;
        switch ((int)l) {
            case 0: {
                string2 = "ERROR_SUCCESS";
                break;
            }
            case 2000: {
                string2 = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string2 = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string2 = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string2 = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string2 = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string2 = "(Unknown error code " + l + ")";
            }
        }
        return string2;
    }

    @Override
    protected final int getGammaRampLength(NativeSurface nativeSurface) {
        return 256;
    }

    @Override
    protected final boolean setGammaRamp(NativeSurface nativeSurface, float[] fArray) {
        short[] sArray = new short[768];
        for (int i = 0; i < 256; ++i) {
            short s2;
            sArray[i] = s2 = (short)(fArray[i] * 65535.0f);
            sArray[i + 256] = s2;
            sArray[i + 512] = s2;
        }
        long l = nativeSurface.getSurfaceHandle();
        if (0L == l) {
            return false;
        }
        boolean bl = GDI.SetDeviceGammaRamp(l, ShortBuffer.wrap(sArray));
        return bl;
    }

    @Override
    protected final Buffer getGammaRamp(NativeSurface nativeSurface) {
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[768]);
        long l = nativeSurface.getSurfaceHandle();
        if (0L == l) {
            return null;
        }
        boolean bl = GDI.GetDeviceGammaRamp(l, shortBuffer);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    @Override
    protected final void resetGammaRamp(NativeSurface nativeSurface, Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = nativeSurface.getSurfaceHandle();
        if (0L == l) {
            return;
        }
        GDI.SetDeviceGammaRamp(l, buffer);
    }

    @Override
    protected final void resetGammaRamp(GLDrawableFactoryImpl.DeviceScreenID deviceScreenID, Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = GDI.GetDC(0L);
        GDI.SetDeviceGammaRamp(l, buffer);
        GDI.ReleaseDC(0L, l);
    }

    static {
        Debug.initSingleton();
        CPU_AFFINITY_MODE = PropertyAccess.getIntProperty("jogl.windows.cpu_affinity_mode", true, 1);
        windowsWGLDynamicLookupHelper = null;
    }

    static final class NopCPUAffinity
    implements CPUAffinity {
        @Override
        public boolean set(int n) {
            if (DEBUG) {
                System.err.println("NopCPUAffinity.set() - " + WindowsWGLDrawableFactory.getThreadName());
            }
            return false;
        }

        @Override
        public boolean reset() {
            if (DEBUG) {
                System.err.println("NopCPUAffinity.reset() - " + WindowsWGLDrawableFactory.getThreadName());
            }
            return false;
        }
    }

    static final class WindowsProcessAffinity
    implements CPUAffinity {
        private long processHandle = 0L;
        private long newAffinity = 0L;
        private final PointerBuffer procMask = PointerBuffer.allocateDirect(1);
        private final PointerBuffer sysMask = PointerBuffer.allocateDirect(1);

        @Override
        public boolean set(int n) {
            boolean bl;
            if (0L != this.processHandle) {
                throw new IllegalStateException("Affinity already set");
            }
            long l = GDI.GetCurrentProcess();
            if (GDI.GetProcessAffinityMask(l, this.procMask, this.sysMask)) {
                if (GDI.SetProcessAffinityMask(l, n)) {
                    this.processHandle = l;
                    this.newAffinity = n;
                    bl = true;
                } else {
                    bl = false;
                }
                if (DEBUG) {
                    System.err.println("WindowsProcessAffinity.set() - pid " + WindowsWGLDrawableFactory.toHexString(l) + " - " + WindowsWGLDrawableFactory.getThreadName() + ": OK " + bl + " (werr " + GDI.GetLastError() + "), Affinity: procMask " + WindowsWGLDrawableFactory.toHexString(this.procMask.get(0)) + ", sysMask " + WindowsWGLDrawableFactory.toHexString(this.sysMask.get(0)) + " -> " + WindowsWGLDrawableFactory.toHexString(n));
                }
            } else {
                if (DEBUG) {
                    System.err.println("WindowsProcessAffinity.set() - pid " + WindowsWGLDrawableFactory.toHexString(l) + " - " + WindowsWGLDrawableFactory.getThreadName() + ": Error, could not GetProcessAffinityMask, werr " + GDI.GetLastError());
                }
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean reset() {
            if (0L == this.processHandle) {
                return true;
            }
            long l = GDI.GetCurrentProcess();
            if (l != this.processHandle) {
                throw new IllegalStateException("PID doesn't match: set PID " + WindowsWGLDrawableFactory.toHexString(this.processHandle) + " this PID " + WindowsWGLDrawableFactory.toHexString(l));
            }
            long l2 = this.procMask.get(0);
            boolean bl = GDI.SetProcessAffinityMask(this.processHandle, l2);
            if (DEBUG) {
                int n = GDI.GetLastError();
                System.err.println("WindowsProcessAffinity.reset() - pid " + WindowsWGLDrawableFactory.toHexString(this.processHandle) + " - " + WindowsWGLDrawableFactory.getThreadName() + ": OK " + bl + " (werr " + n + "), Affinity: " + WindowsWGLDrawableFactory.toHexString(this.newAffinity) + " -> procMask " + WindowsWGLDrawableFactory.toHexString(l2));
            }
            this.processHandle = 0L;
            this.newAffinity = l2;
            return bl;
        }
    }

    static final class WindowsThreadAffinity
    implements CPUAffinity {
        private long threadHandle = 0L;
        private long threadOrigAffinity = 0L;
        private long threadNewAffinity = 0L;

        @Override
        public boolean set(int n) {
            boolean bl;
            long l = GDI.GetCurrentThread();
            if (0L != this.threadHandle) {
                throw new IllegalStateException("Affinity already set");
            }
            long l2 = GDI.SetThreadAffinityMask(l, n);
            int n2 = GDI.GetLastError();
            if (0L != l2) {
                bl = true;
                this.threadHandle = l;
                this.threadNewAffinity = n;
                this.threadOrigAffinity = l2;
            } else {
                bl = false;
            }
            if (DEBUG) {
                System.err.println("WindowsThreadAffinity.set() - tid " + WindowsWGLDrawableFactory.toHexString(l) + " - " + WindowsWGLDrawableFactory.getThreadName() + ": OK " + bl + " (werr " + n2 + "), Affinity: " + WindowsWGLDrawableFactory.toHexString(this.threadOrigAffinity) + " -> " + WindowsWGLDrawableFactory.toHexString(n));
            }
            return bl;
        }

        @Override
        public boolean reset() {
            boolean bl;
            if (0L == this.threadHandle) {
                return true;
            }
            long l = GDI.GetCurrentThread();
            if (l != this.threadHandle) {
                throw new IllegalStateException("TID doesn't match: set TID " + WindowsWGLDrawableFactory.toHexString(this.threadHandle) + " this TID " + WindowsWGLDrawableFactory.toHexString(l));
            }
            long l2 = GDI.SetThreadAffinityMask(this.threadHandle, this.threadOrigAffinity);
            boolean bl2 = bl = 0L != l2;
            if (DEBUG) {
                System.err.println("WindowsThreadAffinity.reset() - tid " + WindowsWGLDrawableFactory.toHexString(this.threadHandle) + " - " + WindowsWGLDrawableFactory.getThreadName() + ": OK " + bl + " (werr " + GDI.GetLastError() + "), Affinity: " + WindowsWGLDrawableFactory.toHexString(this.threadNewAffinity) + " -> orig " + WindowsWGLDrawableFactory.toHexString(this.threadOrigAffinity));
            }
            this.threadHandle = 0L;
            this.threadNewAffinity = this.threadOrigAffinity;
            return bl;
        }
    }

    static interface CPUAffinity {
        public boolean set(int var1);

        public boolean reset();
    }

    class SharedResourceImplementation
    extends SharedResourceRunner.AImplementation {
        SharedResourceImplementation() {
        }

        @Override
        public boolean isDeviceSupported(AbstractGraphicsDevice abstractGraphicsDevice) {
            return true;
        }

        @Override
        public SharedResourceRunner.Resource createSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
            WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID());
            GLContextImpl gLContextImpl = null;
            boolean bl = false;
            windowsGraphicsDevice.lock();
            try {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                boolean bl6;
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(windowsGraphicsDevice, 0);
                GLProfile gLProfile = GLProfile.get(windowsGraphicsDevice, GLProfile.GL_PROFILE_LIST_MIN_DESKTOP, false);
                if (null == gLProfile) {
                    throw new GLException("Couldn't get default GLProfile for device: " + windowsGraphicsDevice);
                }
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                GLDrawableImpl gLDrawableImpl = WindowsWGLDrawableFactory.this.createOnscreenDrawableImpl(WindowsWGLDrawableFactory.this.createDummySurfaceImpl(windowsGraphicsDevice, false, gLCapabilities, gLCapabilities, null, 64, 64));
                gLDrawableImpl.setRealized(true);
                gLContextImpl = (GLContextImpl)gLDrawableImpl.createContext(null);
                if (null == gLContextImpl) {
                    throw new GLException("Couldn't create shared context for drawable: " + gLDrawableImpl);
                }
                boolean bl7 = bl = 0 != gLContextImpl.makeCurrent();
                if (bl) {
                    if (gLContextImpl.getGLVersionNumber().compareTo(GLContext.Version3_0) >= 0) {
                        bl6 = WindowsWGLDrawableFactory.this.probeSurfacelessCtx(gLContextImpl, true);
                    } else {
                        WindowsWGLDrawableFactory.this.setNoSurfacelessCtxQuirk(gLContextImpl);
                        bl6 = false;
                    }
                    bl5 = gLContextImpl.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_pixel_format);
                    bl4 = gLContextImpl.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_multisample);
                    bl3 = gLContextImpl.isExtensionAvailable("GL_ARB_pbuffer");
                    bl2 = gLContextImpl.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_make_current_read) && gLContextImpl.isFunctionAvailable(WindowsWGLDrawableFactory.wglMakeContextCurrent);
                } else {
                    bl6 = false;
                    bl5 = false;
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                }
                if (DEBUG_SHAREDCTX) {
                    System.err.println("SharedDevice:  " + windowsGraphicsDevice);
                    System.err.println("SharedScreen:  " + defaultGraphicsScreen);
                    System.err.println("SharedContext: " + gLContextImpl + ", madeCurrent " + bl);
                    System.err.println("  allowsSurfacelessCtx " + bl6);
                    System.err.println("pixelformat:   " + bl5);
                    System.err.println("multisample:   " + bl4);
                    System.err.println("pbuffer:       " + bl3);
                    System.err.println("readDrawable:  " + bl2);
                }
                SharedResource sharedResource = new SharedResource(windowsGraphicsDevice, defaultGraphicsScreen, gLDrawableImpl, gLContextImpl, bl5, bl4, bl3, bl2);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("WindowsWGLDrawableFactory - Could not initialize shared resources for " + abstractGraphicsDevice, throwable);
            }
            finally {
                if (bl) {
                    gLContextImpl.release();
                }
                windowsGraphicsDevice.unlock();
            }
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG_SHAREDCTX) {
                System.err.println("Shutdown Shared:");
                System.err.println("Device  : " + sharedResource.device);
                System.err.println("Screen  : " + sharedResource.screen);
                System.err.println("Drawable: " + sharedResource.drawable);
                System.err.println("CTX     : " + sharedResource.context);
            }
            if (null != sharedResource.context) {
                sharedResource.context.destroy();
                sharedResource.context = null;
            }
            if (null != sharedResource.drawable) {
                sharedResource.drawable.setRealized(false);
                sharedResource.drawable = null;
            }
            if (null != sharedResource.screen) {
                sharedResource.screen = null;
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private final boolean hasARBPixelFormat;
        private final boolean hasARBMultisample;
        private final boolean hasARBPBuffer;
        private final boolean hasARBReadDrawable;
        private WindowsGraphicsDevice device;
        private AbstractGraphicsScreen screen;
        private GLDrawableImpl drawable;
        private GLContextImpl context;

        SharedResource(WindowsGraphicsDevice windowsGraphicsDevice, AbstractGraphicsScreen abstractGraphicsScreen, GLDrawableImpl gLDrawableImpl, GLContextImpl gLContextImpl, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.device = windowsGraphicsDevice;
            this.screen = abstractGraphicsScreen;
            this.drawable = gLDrawableImpl;
            this.context = gLContextImpl;
            this.hasARBPixelFormat = bl;
            this.hasARBMultisample = bl2;
            this.hasARBPBuffer = bl3;
            this.hasARBReadDrawable = bl4;
        }

        @Override
        public final boolean isAvailable() {
            return null != this.context;
        }

        @Override
        public final AbstractGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public final AbstractGraphicsScreen getScreen() {
            return this.screen;
        }

        @Override
        public final GLDrawableImpl getDrawable() {
            return this.drawable;
        }

        @Override
        public final GLContextImpl getContext() {
            return this.context;
        }

        @Override
        public GLRendererQuirks getRendererQuirks(GLProfile gLProfile) {
            return null != this.context ? this.context.getRendererQuirks() : null;
        }

        final boolean hasARBPixelFormat() {
            return this.hasARBPixelFormat;
        }

        final boolean hasARBMultisample() {
            return this.hasARBMultisample;
        }

        final boolean hasARBPBuffer() {
            return this.hasARBPBuffer;
        }

        final boolean hasReadDrawable() {
            return this.hasARBReadDrawable;
        }
    }
}

