/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.schedulers.SchedulerMultiWorkerSupport;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelRunOn<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;

    public ParallelRunOn(ParallelFlowable<? extends T> parent, Scheduler scheduler, int prefetch) {
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        if (this.scheduler instanceof SchedulerMultiWorkerSupport) {
            SchedulerMultiWorkerSupport multiworker = (SchedulerMultiWorkerSupport)((Object)this.scheduler);
            multiworker.createWorkers(n, new MultiWorkerCallback(subscribers, parents));
        } else {
            for (int i = 0; i < n; ++i) {
                this.createSubscriber(i, subscribers, parents, this.scheduler.createWorker());
            }
        }
        this.source.subscribe(parents);
    }

    void createSubscriber(int i, Subscriber<? super T>[] subscribers, Subscriber<T>[] parents, Scheduler.Worker worker) {
        Subscriber<? super T> a = subscribers[i];
        SpscArrayQueue q = new SpscArrayQueue(this.prefetch);
        parents[i] = a instanceof ConditionalSubscriber ? new RunOnConditionalSubscriber((ConditionalSubscriber)a, this.prefetch, q, worker) : new RunOnSubscriber<T>(a, this.prefetch, q, worker);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class RunOnConditionalSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final ConditionalSubscriber<? super T> downstream;

        RunOnConditionalSubscriber(ConditionalSubscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            super(prefetch, queue, worker);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c = this.consumed;
            SpscArrayQueue q = this.queue;
            ConditionalSubscriber a = this.downstream;
            int lim = this.limit;
            do {
                long r = this.requested.get();
                long e = 0L;
                while (e != r) {
                    int p;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    if (a.tryOnNext(v)) {
                        ++e;
                    }
                    if ((p = ++c) != lim) continue;
                    c = 0;
                    this.upstream.request(p);
                }
                if (e == r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q.clear();
                            a.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q.isEmpty()) {
                            a.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e != 0L) {
                    BackpressureHelper.produced(this.requested, e);
                }
                this.consumed = c;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    static final class RunOnSubscriber<T>
    extends BaseRunOnSubscriber<T> {
        private static final long serialVersionUID = 1075119423897941642L;
        final Subscriber<? super T> downstream;

        RunOnSubscriber(Subscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            super(prefetch, queue, worker);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
                s2.request(this.prefetch);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c = this.consumed;
            SpscArrayQueue q = this.queue;
            Subscriber a = this.downstream;
            int lim = this.limit;
            while (true) {
                int w;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    int p;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if ((p = ++c) != lim) continue;
                    c = 0;
                    this.upstream.request(p);
                }
                if (e == r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q.clear();
                            a.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q.isEmpty()) {
                            a.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    this.consumed = c;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }

    static abstract class BaseRunOnSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 9222303586456402150L;
        final int prefetch;
        final int limit;
        final SpscArrayQueue<T> queue;
        final Scheduler.Worker worker;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        int consumed;

        BaseRunOnSubscriber(int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            this.prefetch = prefetch;
            this.queue = queue;
            this.limit = prefetch - (prefetch >> 2);
            this.worker = worker;
        }

        @Override
        public final void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.queue.offer(t)) {
                this.upstream.cancel();
                this.onError(new MissingBackpressureException("Queue is full?!"));
                return;
            }
            this.schedule();
        }

        @Override
        public final void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.schedule();
        }

        @Override
        public final void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        @Override
        public final void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.schedule();
            }
        }

        @Override
        public final void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.worker.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        final void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }
    }

    final class MultiWorkerCallback
    implements SchedulerMultiWorkerSupport.WorkerCallback {
        final Subscriber<? super T>[] subscribers;
        final Subscriber<T>[] parents;

        MultiWorkerCallback(Subscriber<? super T>[] subscribers, Subscriber<T>[] parents) {
            this.subscribers = subscribers;
            this.parents = parents;
        }

        @Override
        public void onWorker(int i, Scheduler.Worker w) {
            ParallelRunOn.this.createSubscriber(i, this.subscribers, this.parents, w);
        }
    }
}

