/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.FastField;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SerializationMembers
implements Caching {
    private static final Method NO_METHOD = new Object(){

        private void noMethod() {
        }
    }.getClass().getDeclaredMethods()[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_CLASSES = new Class[0];
    private static final Map NO_FIELDS = Collections.EMPTY_MAP;
    private static final int PERSISTENT_FIELDS_MODIFIER = 26;
    private static final FastField[] OBJECT_TYPE_FIELDS = new FastField[]{new FastField(Object.class, "readResolve"), new FastField(Object.class, "writeReplace"), new FastField(Object.class, "readObject"), new FastField(Object.class, "writeObject")};
    private Map declaredCache = Collections.synchronizedMap(new HashMap());
    private Map resRepCache = Collections.synchronizedMap(new HashMap());
    private final Map fieldCache = Collections.synchronizedMap(new HashMap());

    public SerializationMembers() {
        int i;
        for (i = 0; i < OBJECT_TYPE_FIELDS.length; ++i) {
            this.declaredCache.put(OBJECT_TYPE_FIELDS[i], NO_METHOD);
        }
        for (i = 0; i < 2; ++i) {
            this.resRepCache.put(OBJECT_TYPE_FIELDS[i], NO_METHOD);
        }
    }

    public Object callReadResolve(Object result2) {
        if (result2 == null) {
            return null;
        }
        Class<?> resultType = result2.getClass();
        Method readResolveMethod = this.getRRMethod(resultType, "readResolve");
        if (readResolveMethod != null) {
            ErrorWritingException ex = null;
            try {
                return readResolveMethod.invoke(result2, EMPTY_ARGS);
            }
            catch (IllegalAccessException e) {
                ex = new ObjectAccessException("Cannot access method", e);
            }
            catch (InvocationTargetException e) {
                ex = new ConversionException("Failed calling method", e.getTargetException());
            }
            ex.add("method", resultType.getName() + ".readResolve()");
            throw ex;
        }
        return result2;
    }

    public Object callWriteReplace(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> objectType = object.getClass();
        Method writeReplaceMethod = this.getRRMethod(objectType, "writeReplace");
        if (writeReplaceMethod != null) {
            ErrorWritingException ex = null;
            try {
                Object replaced = writeReplaceMethod.invoke(object, EMPTY_ARGS);
                if (replaced != null && !object.getClass().equals(replaced.getClass())) {
                    replaced = this.callWriteReplace(replaced);
                }
                return replaced;
            }
            catch (IllegalAccessException e) {
                ex = new ObjectAccessException("Cannot access method", e);
            }
            catch (InvocationTargetException e) {
                ex = new ConversionException("Failed calling method", e.getTargetException());
            }
            catch (ErrorWritingException e) {
                ex = e;
            }
            ex.add("method", objectType.getName() + ".writeReplace()");
            throw ex;
        }
        return object;
    }

    public boolean supportsReadObject(Class type2, boolean includeBaseClasses) {
        return this.getMethod(type2, "readObject", new Class[]{ObjectInputStream.class}, includeBaseClasses) != null;
    }

    public void callReadObject(Class type2, Object object, ObjectInputStream stream) {
        ErrorWritingException ex = null;
        try {
            Method readObjectMethod = this.getMethod(type2, "readObject", new Class[]{ObjectInputStream.class}, false);
            readObjectMethod.invoke(object, stream);
        }
        catch (IllegalAccessException e) {
            ex = new ObjectAccessException("Cannot access method", e);
        }
        catch (InvocationTargetException e) {
            ex = new ConversionException("Failed calling method", e.getTargetException());
        }
        if (ex != null) {
            ex.add("method", object.getClass().getName() + ".readObject()");
            throw ex;
        }
    }

    public boolean supportsWriteObject(Class type2, boolean includeBaseClasses) {
        return this.getMethod(type2, "writeObject", new Class[]{ObjectOutputStream.class}, includeBaseClasses) != null;
    }

    public void callWriteObject(Class type2, Object instance, ObjectOutputStream stream) {
        ErrorWritingException ex = null;
        try {
            Method readObjectMethod = this.getMethod(type2, "writeObject", new Class[]{ObjectOutputStream.class}, false);
            readObjectMethod.invoke(instance, stream);
        }
        catch (IllegalAccessException e) {
            ex = new ObjectAccessException("Cannot access method", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof ConversionException) {
                throw (ConversionException)cause;
            }
            ex = new ConversionException("Failed calling method", e.getTargetException());
        }
        if (ex != null) {
            ex.add("method", instance.getClass().getName() + ".writeObject()");
            throw ex;
        }
    }

    private Method getMethod(Class type2, String name, Class[] parameterTypes, boolean includeBaseclasses) {
        Method method = this.getMethod(type2, name, parameterTypes);
        return method == NO_METHOD || !includeBaseclasses && !method.getDeclaringClass().equals(type2) ? null : method;
    }

    private Method getMethod(Class type2, String name, Class[] parameterTypes) {
        if (type2 == null) {
            return null;
        }
        FastField method = new FastField(type2, name);
        Method result2 = (Method)this.declaredCache.get(method);
        if (result2 == null) {
            try {
                result2 = type2.getDeclaredMethod(name, parameterTypes);
                if (!result2.isAccessible()) {
                    result2.setAccessible(true);
                }
            }
            catch (NoSuchMethodException e) {
                result2 = this.getMethod(type2.getSuperclass(), name, parameterTypes);
            }
            this.declaredCache.put(method, result2);
        }
        return result2;
    }

    private Method getRRMethod(Class type2, String name) {
        FastField method = new FastField(type2, name);
        Method result2 = (Method)this.resRepCache.get(method);
        if (result2 == null) {
            result2 = this.getMethod(type2, name, EMPTY_CLASSES, true);
            if (result2 != null && result2.getDeclaringClass() != type2) {
                if ((result2.getModifiers() & 5) == 0 && ((result2.getModifiers() & 2) > 0 || type2.getPackage() != result2.getDeclaringClass().getPackage())) {
                    result2 = NO_METHOD;
                }
            } else if (result2 == null) {
                result2 = NO_METHOD;
            }
            this.resRepCache.put(method, result2);
        }
        return result2 == NO_METHOD ? null : result2;
    }

    public Map getSerializablePersistentFields(Class type2) {
        if (type2 == null) {
            return null;
        }
        HashMap<String, ObjectStreamField> result2 = (HashMap<String, ObjectStreamField>)this.fieldCache.get(type2.getName());
        if (result2 == null) {
            ErrorWritingException ex = null;
            try {
                Field field = type2.getDeclaredField("serialPersistentFields");
                if ((field.getModifiers() & 0x1A) == 26) {
                    field.setAccessible(true);
                    ObjectStreamField[] fields2 = (ObjectStreamField[])field.get(null);
                    if (fields2 != null) {
                        result2 = new HashMap<String, ObjectStreamField>();
                        for (int i = 0; i < fields2.length; ++i) {
                            result2.put(fields2[i].getName(), fields2[i]);
                        }
                    }
                }
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                ex = new ObjectAccessException("Cannot get field", e);
            }
            catch (ClassCastException e) {
                ex = new ConversionException("Incompatible field type", e);
            }
            if (ex != null) {
                ex.add("field", type2.getName() + ".serialPersistentFields");
                throw ex;
            }
            if (result2 == null) {
                result2 = NO_FIELDS;
            }
            this.fieldCache.put(type2.getName(), result2);
        }
        return result2 == NO_FIELDS ? null : result2;
    }

    public void flushCache() {
        this.declaredCache.keySet().retainAll(Arrays.asList(OBJECT_TYPE_FIELDS));
        this.resRepCache.keySet().retainAll(Arrays.asList(OBJECT_TYPE_FIELDS));
    }
}

