/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ProcAddressTable {
    private static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    private static final int PROCADDRESS_VAR_PREFIX_LEN = "_addressof_".length();
    protected static boolean DEBUG;
    protected static String DEBUG_PREFIX;
    protected static int debugNum;
    private final FunctionAddressResolver resolver;

    public ProcAddressTable() {
        this(new One2OneResolver());
    }

    public ProcAddressTable(FunctionAddressResolver functionAddressResolver) {
        this.resolver = functionAddressResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(DynamicLookupHelper dynamicLookupHelper) throws SecurityException, RuntimeException {
        PrintStream printStream;
        if (null == dynamicLookupHelper) {
            throw new RuntimeException("Passed null DynamicLookupHelper");
        }
        AccessibleObject[] accessibleObjectArray = this.getClass().getDeclaredFields();
        if (DEBUG) {
            printStream = ProcAddressTable.getDebugOutStream();
            printStream.println(this.getClass().getName() + ".reset() (w/ " + accessibleObjectArray.length + " prospective fields)");
        } else {
            printStream = null;
        }
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        dynamicLookupHelper.claimAllLinkPermission();
        try {
            for (int i = 0; i < accessibleObjectArray.length; ++i) {
                String string2 = ((Field)accessibleObjectArray[i]).getName();
                if (!this.isAddressField(string2)) continue;
                String string3 = this.fieldToFunctionName(string2);
                this.setEntry((Field)accessibleObjectArray[i], string3, dynamicLookupHelper);
            }
        }
        finally {
            dynamicLookupHelper.releaseAllLinkPermission();
        }
        if (DEBUG) {
            printStream.flush();
            if (DEBUG_PREFIX != null) {
                printStream.close();
            }
        }
    }

    public void initEntry(String string2, DynamicLookupHelper dynamicLookupHelper) throws SecurityException, IllegalArgumentException {
        Field field = this.fieldForFunction(string2);
        field.setAccessible(true);
        this.setEntry(field, string2, dynamicLookupHelper);
    }

    private final void setEntry(Field field, String string2, DynamicLookupHelper dynamicLookupHelper) throws SecurityException {
        try {
            assert (field.getType() == Long.TYPE);
            long l = this.resolver.resolve(string2, dynamicLookupHelper);
            field.setLong(this, l);
            if (DEBUG) {
                ProcAddressTable.getDebugOutStream().println("  " + field.getName() + " -> 0x" + Long.toHexString(l));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not get proc address for method \"" + string2 + "\": Couldn't set value of field \"" + field, exception);
        }
    }

    private final String fieldToFunctionName(String string2) {
        return string2.substring(PROCADDRESS_VAR_PREFIX_LEN);
    }

    private final Field fieldForFunction(String string2) throws IllegalArgumentException {
        try {
            return this.getClass().getDeclaredField(PROCADDRESS_VAR_PREFIX + string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(this.getClass().getName() + " has no entry for the function '" + string2 + "'.", noSuchFieldException);
        }
    }

    private final Field fieldForFunctionInSec(final String string2) throws IllegalArgumentException {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = ProcAddressTable.this.getClass().getDeclaredField(ProcAddressTable.PROCADDRESS_VAR_PREFIX + string2);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalArgumentException(this.getClass().getName() + " has no entry for the function '" + string2 + "'.", noSuchFieldException);
                }
            }
        });
    }

    private final boolean isAddressField(String string2) {
        return string2.startsWith(PROCADDRESS_VAR_PREFIX);
    }

    private static final PrintStream getDebugOutStream() {
        PrintStream printStream = null;
        if (DEBUG) {
            if (DEBUG_PREFIX != null) {
                try {
                    printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(DEBUG_PREFIX + File.separatorChar + "procaddresstable-" + ++debugNum + ".txt")));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    printStream = System.err;
                }
            } else {
                printStream = System.err;
            }
        }
        return printStream;
    }

    private final Map<String, Long> toMap() {
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
        Field[] fieldArray = this.getClass().getFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                String string2 = fieldArray[i].getName();
                if (!this.isAddressField(string2)) continue;
                treeMap.put(this.fieldToFunctionName(string2), (Long)fieldArray[i].get(this));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return treeMap;
    }

    public final boolean isFunctionAvailable(String string2) {
        try {
            return this.isFunctionAvailableImpl(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    protected boolean isFunctionAvailableImpl(String string2) throws IllegalArgumentException {
        Field field = this.fieldForFunctionInSec(string2);
        try {
            return 0L != field.getLong(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public long getAddressFor(String string2) throws SecurityException, IllegalArgumentException {
        SecurityUtil.checkAllLinkPermission();
        Field field = this.fieldForFunctionInSec(string2);
        try {
            return field.getLong(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public final Set<String> getNullPointerFunctions() {
        Map<String, Long> map2 = this.toMap();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Long> entry : map2.entrySet()) {
            long l = entry.getValue();
            if (l != 0L) continue;
            linkedHashSet.add(entry.getKey());
        }
        return linkedHashSet;
    }

    public final String toString() {
        return this.getClass().getName() + "" + this.toMap();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean bl = DEBUG = System.getProperty("jogamp.debug.ProcAddressHelper") != null;
                if (DEBUG) {
                    DEBUG_PREFIX = System.getProperty("jogamp.debug.ProcAddressHelper.prefix");
                }
                return null;
            }
        });
    }

    private static class One2OneResolver
    implements FunctionAddressResolver {
        private One2OneResolver() {
        }

        @Override
        public long resolve(String string2, DynamicLookupHelper dynamicLookupHelper) throws SecurityException {
            return dynamicLookupHelper.dynamicLookupFunction(string2);
        }
    }
}

