/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.textures;

import com.client.Buffer1;
import com.client.Client;
import com.client.FileArchive;
import com.client.IndexedImage;
import com.client.Linkable;
import com.client.Rasterizer3D;
import net.runelite.rs.api.RSTexture;

public class Texture
extends Linkable
implements RSTexture {
    private static int[] animatedPixels;
    public int averageRGB;
    public boolean isTransparent = false;
    private int[] fileIds;
    private int[] field2301;
    private int[] field2296;
    private int[] field2295;
    public int animationDirection;
    private int animationSpeed;
    public int id;
    public int[] pixels;
    public boolean isLoaded = false;
    private float textureU;
    private float textureV;

    Texture(Buffer1 buffer) {
        int opcode;
        int count2 = 0;
        while ((opcode = buffer.readUnsignedByte()) != 0) {
            int index;
            if (opcode == 1) {
                this.id = buffer.readShort();
                continue;
            }
            if (opcode == 2) {
                this.isTransparent = buffer.readUnsignedByte() == 1;
                continue;
            }
            if (opcode == 3) {
                count2 = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 4) {
                this.fileIds = new int[count2];
                for (index = 0; index < count2; ++index) {
                    this.fileIds[index] = buffer.readShort();
                }
                continue;
            }
            if (opcode == 5 && count2 > 1) {
                this.field2301 = new int[count2 - 1];
                for (index = 0; index < count2 - 1; ++index) {
                    this.field2301[index] = buffer.readUnsignedByte();
                }
                continue;
            }
            if (opcode == 6 && count2 > 1) {
                this.field2296 = new int[count2 - 1];
                for (index = 0; index < count2 - 1; ++index) {
                    this.field2296[index] = buffer.readUnsignedByte();
                }
                continue;
            }
            if (opcode == 7) {
                this.field2295 = new int[count2];
                for (index = 0; index < count2; ++index) {
                    this.field2295[index] = buffer.readInt();
                }
                continue;
            }
            if (opcode == 8) {
                this.animationSpeed = buffer.readShort();
                continue;
            }
            if (opcode == 9) {
                this.animationDirection = buffer.readShort();
                continue;
            }
            if (opcode != 10) continue;
            this.averageRGB = buffer.read24Int();
        }
        this.pixels = null;
    }

    Texture(Texture originalTexture, int newID) {
        int index;
        int count2 = 0;
        this.id = newID;
        this.isTransparent = originalTexture.isTransparent;
        count2 = originalTexture.fileIds.length;
        this.fileIds = new int[count2];
        for (index = 0; index < count2; ++index) {
            this.fileIds[index] = newID;
        }
        this.field2301 = new int[count2 - 1];
        for (index = 0; index < count2 - 1; ++index) {
            this.field2301[index] = newID;
        }
        this.field2296 = new int[count2 - 1];
        for (index = 0; index < count2 - 1; ++index) {
            this.field2296[index] = newID;
        }
        this.field2295 = new int[count2];
        for (index = 0; index < count2; ++index) {
            this.field2295[index] = newID;
        }
        if (newID >= 126) {
            this.animationSpeed = originalTexture.animationSpeed;
            this.animationDirection = originalTexture.animationDirection;
        } else {
            this.animationSpeed = 0;
            this.animationDirection = 0;
        }
        this.averageRGB = originalTexture.averageRGB;
        this.pixels = null;
    }

    boolean load(double brightness, int textureSize, FileArchive textureArchive) {
        for (int fileId : this.fileIds) {
            if (textureArchive.readFile(fileId + ".dat") != null) continue;
            return false;
        }
        int pixelCount = textureSize * textureSize;
        this.pixels = new int[pixelCount];
        for (int index = 0; index < this.fileIds.length; ++index) {
            int var14;
            int var13;
            int var12;
            int var11;
            IndexedImage image = new IndexedImage(textureArchive, String.valueOf(this.fileIds[index]), 0);
            image.setTransparency(255, 0, 255);
            image.normalize();
            byte[] palettePixels = image.palettePixels;
            int[] palette = image.palette;
            int var10 = this.field2295[index];
            if ((var10 & 0xFF000000) == 0x3000000) {
                var11 = var10 & 0xFF00FF;
                var12 = var10 >> 8 & 0xFF;
                for (var13 = 0; var13 < palette.length; ++var13) {
                    var14 = palette[var13];
                    if (var14 >> 8 != (var14 & 0xFFFF)) continue;
                    palette[var13] = var11 * (var14 &= 0xFF) >> 8 & 0xFF00FF | var12 * var14 & 0xFF00;
                }
            }
            for (var11 = 0; var11 < palette.length; ++var11) {
                palette[var11] = Rasterizer3D.adjustBrightness(palette[var11], brightness);
            }
            var11 = index == 0 ? 0 : this.field2301[index - 1];
            if (var11 != 0) continue;
            if (textureSize == image.subWidth) {
                for (var12 = 0; var12 < pixelCount; ++var12) {
                    this.pixels[var12] = palette[palettePixels[var12] & 0xFF];
                }
                continue;
            }
            if (image.subWidth == 64 && textureSize == 128) {
                var12 = 0;
                for (var13 = 0; var13 < textureSize; ++var13) {
                    for (var14 = 0; var14 < textureSize; ++var14) {
                        this.pixels[var12++] = palette[palettePixels[(var13 >> 1 << 6) + (var14 >> 1)] & 0xFF];
                    }
                }
                continue;
            }
            if (image.subWidth != 128 || textureSize != 64) {
                throw new RuntimeException();
            }
            var12 = 0;
            for (var13 = 0; var13 < textureSize; ++var13) {
                for (var14 = 0; var14 < textureSize; ++var14) {
                    this.pixels[var12++] = palette[palettePixels[(var14 << 1) + (var13 << 1 << 7)] & 0xFF];
                }
            }
        }
        return true;
    }

    void reset() {
        this.pixels = null;
    }

    void animate(int var1) {
        if (Client.instance.isGpu()) {
            Client.instance.getDrawCallbacks().animate(this, var1);
            return;
        }
        if (this.pixels != null) {
            int[] var10;
            int var7;
            int var6;
            int var5;
            int var4;
            int var3;
            int var2;
            if (this.animationDirection == 1 || this.animationDirection == 3) {
                if (animatedPixels == null || animatedPixels.length < this.pixels.length) {
                    animatedPixels = new int[this.pixels.length];
                }
                var2 = this.pixels.length == 4096 ? 64 : 128;
                var3 = this.pixels.length;
                var4 = var2 * this.animationSpeed * var1;
                var5 = var3 - 1;
                if (this.animationDirection == 1) {
                    var4 = -var4;
                }
                for (var6 = 0; var6 < var3; ++var6) {
                    var7 = var6 + var4 & var5;
                    Texture.animatedPixels[var6] = this.pixels[var7];
                }
                var10 = this.pixels;
                this.pixels = animatedPixels;
                animatedPixels = var10;
            }
            if (this.animationDirection == 2 || this.animationDirection == 4) {
                if (animatedPixels == null || animatedPixels.length < this.pixels.length) {
                    animatedPixels = new int[this.pixels.length];
                }
                var2 = this.pixels.length == 4096 ? 64 : 128;
                var3 = this.pixels.length;
                var4 = this.animationSpeed * var1;
                var5 = var2 - 1;
                if (this.animationDirection == 2) {
                    var4 = -var4;
                }
                for (var6 = 0; var6 < var3; var6 += var2) {
                    for (var7 = 0; var7 < var2; ++var7) {
                        int var8 = var6 + var7;
                        int var9 = var6 + (var7 + var4 & var5);
                        Texture.animatedPixels[var8] = this.pixels[var9];
                    }
                }
                var10 = this.pixels;
                this.pixels = animatedPixels;
                animatedPixels = var10;
            }
        }
    }

    @Override
    public float getU() {
        return this.textureU;
    }

    @Override
    public void setU(float u) {
        this.textureU = u;
    }

    @Override
    public float getV() {
        return this.textureV;
    }

    @Override
    public void setV(float v) {
        this.textureV = v;
    }

    @Override
    public int[] getPixels() {
        return this.pixels;
    }

    @Override
    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public int getAnimationDirection() {
        return this.animationDirection;
    }
}

