/*
 * Decompiled with CFR 0.152.
 */
package com.client.audio;

import com.client.Client;
import com.client.audio.VoicePlayback;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

public class VoiceWebSocketClient
extends WebSocketClient {
    private static VoiceWebSocketClient instance;
    private String username;
    private boolean connected = false;
    private boolean authenticated = false;

    private VoiceWebSocketClient(URI serverUri, String username) {
        super(serverUri);
        this.username = username;
    }

    public static void connect(String voiceServerUrl, String username) {
        try {
            System.out.println("[Voice WS] connect() called with URL: " + voiceServerUrl + ", username: " + username);
            if (instance != null && instance.isOpen()) {
                System.out.println("[Voice WS] Already connected");
                return;
            }
            if (instance != null) {
                System.out.println("[Voice WS] Closing existing instance (state: " + instance.getReadyState() + ")");
                instance.close();
            }
            URI serverUri = new URI(voiceServerUrl);
            System.out.println("[Voice WS] Creating new WebSocket client to: " + serverUri);
            instance = new VoiceWebSocketClient(serverUri, username);
            instance.setConnectionLostTimeout(10);
            new Thread(() -> {
                try {
                    System.out.println("[Voice WS] Calling connectBlocking() with 10 second timeout...");
                    boolean connected = instance.connectBlocking(10L, TimeUnit.SECONDS);
                    if (connected) {
                        System.out.println("[Voice WS] connectBlocking() succeeded - connection established");
                        System.out.println("[Voice WS] Ready state: " + instance.getReadyState());
                    } else {
                        System.err.println("[Voice WS] connectBlocking() failed - connection timeout after 10 seconds");
                        System.err.println("[Voice WS] Ready state: " + instance.getReadyState());
                    }
                }
                catch (InterruptedException e) {
                    System.err.println("[Voice WS] Connection interrupted: " + e.getMessage());
                }
            }, "VoiceWS-Connect").start();
            System.out.println("[Voice WS] Connection initiated in background thread");
        }
        catch (Exception e) {
            System.err.println("[Voice WS] Connection error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static VoiceWebSocketClient getInstance() {
        return instance;
    }

    @Override
    public void onOpen(ServerHandshake handshake2) {
        System.out.println("[Voice WS] *** onOpen() called ***");
        System.out.println("[Voice WS] HTTP Status: " + handshake2.getHttpStatus());
        System.out.println("[Voice WS] HTTP Status Message: " + handshake2.getHttpStatusMessage());
        System.out.println("[Voice WS] Connection established, waiting for authentication...");
        try {
            JSONObject registerMsg = new JSONObject();
            registerMsg.put("type", "register_client");
            registerMsg.put("username", this.username);
            String msgStr = registerMsg.toString();
            System.out.println("[Voice WS] Sending registration message: " + msgStr);
            this.send(msgStr);
            System.out.println("[Voice WS] Registration message sent for: " + this.username);
            System.out.println("[Voice WS] Waiting for 'registered' response from server...");
        }
        catch (Exception e) {
            System.err.println("[Voice WS] Registration error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onMessage(String message) {
        try {
            System.out.println("[Voice WS] *** onMessage(String) called ***");
            System.out.println("[Voice WS] Raw message: " + message);
            JSONObject msg = new JSONObject(message);
            String type2 = msg.getString("type");
            System.out.println("[Voice WS] Message type: " + type2);
            switch (type2) {
                case "registered": {
                    this.connected = true;
                    this.authenticated = true;
                    System.out.println("[Voice WS] *** AUTHENTICATED = TRUE ***");
                    System.out.println("[Voice WS] *** CONNECTED = TRUE ***");
                    System.out.println("[Voice WS] Registration confirmed - can now send audio");
                    System.out.println("[Voice WS] isConnectedAndAuthenticated(): " + this.isConnectedAndAuthenticated());
                    if (msg.has("config")) {
                        JSONObject config = msg.getJSONObject("config");
                        System.out.println("[Voice WS] Config: " + config.toString());
                    }
                    break;
                }
                case "error": {
                    String errorMsg = msg.optString("message", "Unknown error");
                    System.err.println("[Voice WS] Error from server: " + errorMsg);
                    break;
                }
                default: {
                    System.out.println("[Voice WS] Unknown message type: " + type2);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Voice WS] Error processing message: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onMessage(ByteBuffer bytes) {
        try {
            int speakerNameLength;
            byte[] data2 = new byte[bytes.remaining()];
            bytes.get(data2);
            if (data2.length < 3) {
                System.err.println("[Voice WS] Invalid audio frame (too short)");
                return;
            }
            int offset = 0;
            if ((offset += 2) + (speakerNameLength = (data2[offset] & 0xFF) << 8 | data2[offset + 1] & 0xFF) + 1 > data2.length) {
                System.err.println("[Voice WS] Invalid audio frame (name length mismatch)");
                return;
            }
            byte[] speakerNameBytes = new byte[speakerNameLength];
            System.arraycopy(data2, offset, speakerNameBytes, 0, speakerNameLength);
            String speakerName = new String(speakerNameBytes, "UTF-8");
            int volume = data2[offset += speakerNameLength] & 0xFF;
            int audioLength = data2.length - ++offset;
            byte[] audioData = new byte[audioLength];
            System.arraycopy(data2, offset, audioData, 0, audioLength);
            System.out.println("[Voice WS] Received audio from " + speakerName + ": " + audioLength + " bytes (volume: " + volume + "%)");
            try {
                if (Client.instance != null && Client.instance.isPlayerIgnored(speakerName)) {
                    System.out.println("[Voice WS] Player " + speakerName + " is ignored, skipping audio");
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("[Voice WS] Error checking ignore list: " + e.getMessage());
            }
            VoicePlayback playback = VoicePlayback.getInstance();
            if (playback != null) {
                playback.queueAudio(speakerName, audioData);
                System.out.println("[Voice WS] Queued audio for playback");
            } else {
                System.err.println("[Voice WS] VoicePlayback not initialized!");
            }
        }
        catch (Exception e) {
            System.err.println("[Voice WS] Error processing audio: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.connected = false;
        this.authenticated = false;
        System.out.println("[Voice WS] Disconnected: " + reason + " (code: " + code + ")");
    }

    @Override
    public void onError(Exception ex) {
        System.err.println("[Voice WS] *** onError() called ***");
        System.err.println("[Voice WS] Error: " + ex.getMessage());
        System.err.println("[Voice WS] Error class: " + ex.getClass().getName());
        ex.printStackTrace();
    }

    public void sendAudio(byte[] audioData) {
        System.out.println("[Voice WS] sendAudio() called - connected=" + this.connected + ", authenticated=" + this.authenticated + ", dataLength=" + (audioData != null ? audioData.length : 0));
        if (!this.connected || !this.authenticated) {
            System.out.println("[Voice WS] Not connected/authenticated - cannot send audio (connected=" + this.connected + ", authenticated=" + this.authenticated + ")");
            return;
        }
        if (audioData == null || audioData.length == 0) {
            System.out.println("[Voice WS] No audio data to send");
            return;
        }
        try {
            this.send(audioData);
            System.out.println("[Voice WS] Sent " + audioData.length + " bytes of audio");
        }
        catch (Exception e) {
            System.err.println("[Voice WS] Error sending audio: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isConnectedAndAuthenticated() {
        return this.connected && this.authenticated;
    }

    public void disconnect() {
        if (this.connected) {
            System.out.println("[Voice WS] Disconnecting...");
            this.close();
        }
    }
}

