/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Constructable;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MethodCall
implements Streamable,
Constructable<MethodCall> {
    protected String method_name;
    protected short method_id = (short)-1;
    protected Object[] args;
    protected Class<?>[] types;
    protected Method method;

    public MethodCall() {
    }

    public MethodCall(Method m3, Object ... arguments) {
        this.setMethod(m3);
        if (arguments != null) {
            this.args = arguments;
        }
    }

    public MethodCall(short method_id, Object ... args2) {
        this.method_id = MethodCall.assertNotNegative(method_id);
        this.args = args2;
    }

    public MethodCall(String method_name, Object[] args2, Class<?>[] types) {
        this.method_name = method_name;
        this.args = args2;
        this.types = types;
    }

    @Override
    public Supplier<? extends MethodCall> create() {
        return MethodCall::new;
    }

    public boolean useIds() {
        return this.method_id >= 0;
    }

    public String getMethodName() {
        return this.method_name != null ? this.method_name : String.valueOf(this.method_id);
    }

    public short getMethodId() {
        return this.method_id;
    }

    public MethodCall setMethodId(short id) {
        this.method_id = id;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public MethodCall setArgs(Object ... args2) {
        this.args = args2;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodCall setMethod(Method m3) {
        this.method = Objects.requireNonNull(m3);
        this.method_name = m3.getName();
        this.types = m3.getParameterTypes();
        return this;
    }

    public Object invoke(Object target) throws Exception {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        Method meth = this.method;
        if (!this.useIds()) {
            Method method = meth = this.method != null ? this.method : Util.findMethod(target.getClass(), this.method_name, this.types);
        }
        if (meth != null) {
            try {
                if (!Modifier.isPublic(meth.getModifiers())) {
                    meth.setAccessible(true);
                }
                return meth.invoke(target, this.args);
            }
            catch (InvocationTargetException target_ex) {
                Throwable exception = target_ex.getTargetException();
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Exception) {
                    throw (Exception)exception;
                }
                throw new RuntimeException(exception);
            }
        }
        throw new NoSuchMethodException(this.method_name);
    }

    public Object invoke(Object target, Object[] args2) throws Exception {
        if (args2 != null) {
            this.args = args2;
        }
        return this.invoke(target);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        if (this.method_name != null) {
            ret.append(this.method_name);
        } else {
            ret.append(this.method_id);
        }
        ret.append('(');
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    ret.append(", ");
                }
                ret.append(this.args[i]);
            }
        }
        ret.append(')');
        return ret.toString();
    }

    public String toStringDetails() {
        StringBuilder ret = new StringBuilder();
        ret.append("MethodCall ");
        if (this.method_name != null) {
            ret.append("name=").append(this.method_name);
        } else {
            ret.append("id=").append(this.method_id);
        }
        ret.append(", number of args=").append(this.args != null ? this.args.length : 0).append(')');
        if (this.args != null) {
            ret.append("\nArgs:");
            for (int i = 0; i < this.args.length; ++i) {
                ret.append("\n[").append(this.args[i]).append(" (").append(this.args[i] != null ? this.args[i].getClass().getName() : "null").append(")]");
            }
        }
        return ret.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeBoolean(this.useIds());
        if (this.useIds()) {
            out.writeShort(this.method_id);
        } else {
            Bits.writeString(this.method_name, out);
            this.writeTypes(out);
        }
        this.writeArgs(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.method_id = in.readShort();
        } else {
            this.method_name = Bits.readString(in);
            this.readTypes(in);
        }
        this.readArgs(in);
    }

    protected void writeArgs(DataOutput out) throws IOException {
        int args_len = this.args != null ? this.args.length : 0;
        out.writeByte(args_len);
        if (args_len == 0) {
            return;
        }
        for (Object obj : this.args) {
            this.writeArg(out, obj);
        }
    }

    protected void writeArg(DataOutput out, Object obj) throws IOException {
        Util.objectToStream(obj, out);
    }

    protected void readArgs(DataInput in) throws IOException, ClassNotFoundException {
        int args_len = in.readByte();
        if (args_len == 0) {
            return;
        }
        this.args = new Object[args_len];
        for (int i = 0; i < args_len; ++i) {
            this.args[i] = this.readArg(in);
        }
    }

    protected Object readArg(DataInput in) throws IOException, ClassNotFoundException {
        return Util.objectFromStream(in);
    }

    protected void writeTypes(DataOutput out) throws IOException {
        int types_len = this.types != null ? this.types.length : 0;
        out.writeByte(types_len);
        if (types_len > 0) {
            for (Class<?> type : this.types) {
                Util.objectToStream(type, out);
            }
        }
    }

    protected void readTypes(DataInput in) throws IOException, ClassNotFoundException {
        int types_len = in.readByte();
        if (types_len > 0) {
            this.types = new Class[types_len];
            for (int i = 0; i < types_len; ++i) {
                this.types[i] = (Class)Util.objectFromStream(in);
            }
        }
    }

    protected void writeMethod(DataOutput out) throws IOException {
        if (this.method != null) {
            out.writeByte(1);
            Util.objectToStream(this.method.getParameterTypes(), out);
            Util.objectToStream(this.method.getDeclaringClass(), out);
        } else {
            out.writeByte(0);
        }
    }

    protected static short assertNotNegative(short num) {
        if (num < 0) {
            throw new IllegalArgumentException(String.format("value (%d) has to be positive", num));
        }
        return num;
    }
}

