/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.events.NavigationButtonAdded;
import net.runelite.client.events.NavigationButtonRemoved;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.NavigationButton;

@Singleton
public class ClientToolbar {
    private final EventBus eventBus;
    private final ClientUI clientUI;
    private final Set<NavigationButton> buttons = new HashSet<NavigationButton>();

    @Inject
    private ClientToolbar(EventBus eventBus, ClientUI clientUI) {
        this.eventBus = eventBus;
        this.clientUI = clientUI;
    }

    public void addNavigation(NavigationButton button) {
        if (this.buttons.contains(button)) {
            return;
        }
        if (this.buttons.add(button)) {
            this.eventBus.post(new NavigationButtonAdded(button));
        }
    }

    public void removeNavigation(NavigationButton button) {
        if (this.buttons.remove(button)) {
            this.eventBus.post(new NavigationButtonRemoved(button));
        }
    }

    public void openPanel(NavigationButton button) {
        assert (SwingUtilities.isEventDispatchThread()) : "must be on EDT";
        this.clientUI.openPanel(button);
    }
}

