/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.parallel;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.jdk8.ParallelCollector;
import io.reactivex.rxjava3.internal.jdk8.ParallelFlatMapStream;
import io.reactivex.rxjava3.internal.jdk8.ParallelMapOptional;
import io.reactivex.rxjava3.internal.jdk8.ParallelMapTryOptional;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelCollect;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelConcatMap;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelDoOnNextTry;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelFilter;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelFilterTry;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelFlatMap;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelFlatMapIterable;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelFromArray;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelFromPublisher;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelJoin;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelMap;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelMapTry;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelPeek;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelReduce;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelReduceFull;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelRunOn;
import io.reactivex.rxjava3.internal.operators.parallel.ParallelSortedJoin;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.ListAddBiConsumer;
import io.reactivex.rxjava3.internal.util.MergerBiFunction;
import io.reactivex.rxjava3.internal.util.SorterFunction;
import io.reactivex.rxjava3.parallel.ParallelFailureHandling;
import io.reactivex.rxjava3.parallel.ParallelFlowableConverter;
import io.reactivex.rxjava3.parallel.ParallelTransformer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class ParallelFlowable<@NonNull T> {
    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public abstract void subscribe(@NonNull Subscriber<? super T>[] var1);

    @CheckReturnValue
    public abstract int parallelism();

    protected final boolean validate(@NonNull @NonNull Subscriber<@NonNull ?>[] subscribers) {
        Objects.requireNonNull(subscribers, "subscribers is null");
        int p = this.parallelism();
        if (subscribers.length != p) {
            IllegalArgumentException iae = new IllegalArgumentException("parallelism = " + p + ", subscribers = " + subscribers.length);
            for (Subscriber<?> s2 : subscribers) {
                EmptySubscription.error(iae, s2);
            }
            return false;
        }
        return true;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T> ParallelFlowable<T> from(@NonNull Publisher<? extends T> source2) {
        return ParallelFlowable.from(source2, Runtime.getRuntime().availableProcessors(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T> ParallelFlowable<T> from(@NonNull Publisher<? extends T> source2, int parallelism) {
        return ParallelFlowable.from(source2, parallelism, Flowable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T> ParallelFlowable<T> from(@NonNull Publisher<? extends T> source2, int parallelism, int prefetch) {
        Objects.requireNonNull(source2, "source is null");
        ObjectHelper.verifyPositive(parallelism, "parallelism");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelFromPublisher<T>(source2, parallelism, prefetch));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> ParallelFlowable<R> map(@NonNull Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ParallelMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> ParallelFlowable<R> map(@NonNull Function<? super T, ? extends R> mapper, @NonNull ParallelFailureHandling errorHandler) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelMapTry<T, R>(this, mapper, errorHandler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> ParallelFlowable<R> map(@NonNull Function<? super T, ? extends R> mapper, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelMapTry<T, R>(this, mapper, errorHandler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final ParallelFlowable<T> filter(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ParallelFilter<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final ParallelFlowable<T> filter(@NonNull Predicate<? super T> predicate, @NonNull ParallelFailureHandling errorHandler) {
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelFilterTry<T>(this, predicate, errorHandler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final ParallelFlowable<T> filter(@NonNull Predicate<? super T> predicate, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelFilterTry<T>(this, predicate, errorHandler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final ParallelFlowable<T> runOn(@NonNull Scheduler scheduler) {
        return this.runOn(scheduler, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    @NonNull
    public final ParallelFlowable<T> runOn(@NonNull Scheduler scheduler, int prefetch) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelRunOn(this, scheduler, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> reduce(@NonNull BiFunction<T, T, T> reducer) {
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new ParallelReduceFull<T>(this, reducer));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> reduce(@NonNull Supplier<R> initialSupplier, @NonNull BiFunction<R, ? super T, R> reducer) {
        Objects.requireNonNull(initialSupplier, "initialSupplier is null");
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new ParallelReduce<T, R>(this, initialSupplier, reducer));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final Flowable<T> sequential() {
        return this.sequential(Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final Flowable<T> sequential(int prefetch) {
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelJoin(this, prefetch, false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final Flowable<T> sequentialDelayError() {
        return this.sequentialDelayError(Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final Flowable<T> sequentialDelayError(int prefetch) {
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelJoin(this, prefetch, true));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> sorted(@NonNull Comparator<? super T> comparator) {
        return this.sorted(comparator, 16);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> sorted(@NonNull Comparator<? super T> comparator, int capacityHint) {
        Objects.requireNonNull(comparator, "comparator is null");
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        int ch = capacityHint / this.parallelism() + 1;
        ParallelFlowable railReduced = this.reduce(Functions.createArrayList(ch), ListAddBiConsumer.instance());
        ParallelFlowable railSorted = railReduced.map(new SorterFunction<T>(comparator));
        return RxJavaPlugins.onAssembly(new ParallelSortedJoin<T>(railSorted, comparator));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<List<T>> toSortedList(@NonNull Comparator<? super T> comparator) {
        return this.toSortedList(comparator, 16);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Flowable<@NonNull List<T>> toSortedList(@NonNull Comparator<? super T> comparator, int capacityHint) {
        Objects.requireNonNull(comparator, "comparator is null");
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        int ch = capacityHint / this.parallelism() + 1;
        ParallelFlowable railReduced = this.reduce(Functions.createArrayList(ch), ListAddBiConsumer.instance());
        ParallelFlowable railSorted = railReduced.map(new SorterFunction<T>(comparator));
        Flowable merged = railSorted.reduce(new MergerBiFunction<T>(comparator));
        return RxJavaPlugins.onAssembly(merged);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnNext(@NonNull Consumer<? super T> onNext) {
        Objects.requireNonNull(onNext, "onNext is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek<T>(this, onNext, Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnNext(@NonNull Consumer<? super T> onNext, @NonNull ParallelFailureHandling errorHandler) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelDoOnNextTry<T>(this, onNext, errorHandler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnNext(@NonNull Consumer<? super T> onNext, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelDoOnNextTry<T>(this, onNext, errorHandler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doAfterNext(@NonNull Consumer<? super T> onAfterNext) {
        Objects.requireNonNull(onAfterNext, "onAfterNext is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek<T>(this, Functions.emptyConsumer(), onAfterNext, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnError(@NonNull Consumer<? super Throwable> onError) {
        Objects.requireNonNull(onError, "onError is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnComplete(@NonNull Action onComplete) {
        Objects.requireNonNull(onComplete, "onComplete is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION, Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doAfterTerminated(@NonNull Action onAfterTerminate) {
        Objects.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, onAfterTerminate, Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnSubscribe(@NonNull Consumer<? super Subscription> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, onSubscribe, Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final ParallelFlowable<T> doOnRequest(@NonNull LongConsumer onRequest) {
        Objects.requireNonNull(onRequest, "onRequest is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.emptyConsumer(), onRequest, Functions.EMPTY_ACTION));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public final ParallelFlowable<T> doOnCancel(@NonNull Action onCancel) {
        Objects.requireNonNull(onCancel, "onCancel is null");
        return RxJavaPlugins.onAssembly(new ParallelPeek(this, Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION, Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, onCancel));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <C> ParallelFlowable<C> collect(@NonNull Supplier<? extends C> collectionSupplier, @NonNull BiConsumer<? super C, ? super T> collector) {
        Objects.requireNonNull(collectionSupplier, "collectionSupplier is null");
        Objects.requireNonNull(collector, "collector is null");
        return RxJavaPlugins.onAssembly(new ParallelCollect<T, C>(this, collectionSupplier, collector));
    }

    @CheckReturnValue
    @SafeVarargs
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> ParallelFlowable<T> fromArray(Publisher<T> ... publishers) {
        Objects.requireNonNull(publishers, "publishers is null");
        if (publishers.length == 0) {
            throw new IllegalArgumentException("Zero publishers not supported");
        }
        return RxJavaPlugins.onAssembly(new ParallelFromArray<T>(publishers));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> R to(@NonNull ParallelFlowableConverter<T, R> converter) {
        return Objects.requireNonNull(converter, "converter is null").apply(this);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> ParallelFlowable<U> compose(@NonNull ParallelTransformer<T, U> composer) {
        return RxJavaPlugins.onAssembly(Objects.requireNonNull(composer, "composer is null").apply(this));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper) {
        return this.flatMap(mapper, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper, boolean delayError) {
        return this.flatMap(mapper, delayError, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency) {
        return this.flatMap(mapper, delayError, maxConcurrency, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> flatMap(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelFlatMap(this, mapper, delayError, maxConcurrency, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> concatMap(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> concatMap(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelConcatMap(this, mapper, prefetch, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> concatMapDelayError(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapDelayError(mapper, 2, tillTheEnd);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> concatMapDelayError(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper, int prefetch, boolean tillTheEnd) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelConcatMap(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> ParallelFlowable<U> flatMapIterable(@NonNull @NonNull Function<? super T, @NonNull ? extends Iterable<? extends U>> mapper) {
        return this.flatMapIterable(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> ParallelFlowable<U> flatMapIterable(@NonNull @NonNull Function<? super T, @NonNull ? extends Iterable<? extends U>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ParallelFlatMapIterable(this, mapper, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> ParallelFlowable<R> mapOptional(@NonNull @NonNull Function<? super T, @NonNull Optional<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ParallelMapOptional<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> ParallelFlowable<R> mapOptional(@NonNull @NonNull Function<? super T, @NonNull Optional<? extends R>> mapper, @NonNull ParallelFailureHandling errorHandler) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelMapTryOptional<T, R>(this, mapper, errorHandler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public final <R> ParallelFlowable<R> mapOptional(@NonNull @NonNull Function<? super T, @NonNull Optional<? extends R>> mapper, @NonNull BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(errorHandler, "errorHandler is null");
        return RxJavaPlugins.onAssembly(new ParallelMapTryOptional<T, R>(this, mapper, errorHandler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> flatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<? extends R>> mapper) {
        return this.flatMapStream(mapper, Flowable.bufferSize());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> ParallelFlowable<R> flatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<? extends R>> mapper, int prefetch) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new ParallelFlatMapStream(this, mapper, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @NonNull
    public final <A, R> Flowable<R> collect(@NonNull Collector<T, A, R> collector) {
        Objects.requireNonNull(collector, "collector is null");
        return RxJavaPlugins.onAssembly(new ParallelCollector<T, A, R>(this, collector));
    }
}

