/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableDistinctUntilChanged<T, K>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;

    public FlowableDistinctUntilChanged(Flowable<T> source2, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(source2);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            ConditionalSubscriber cs = (ConditionalSubscriber)s2;
            this.source.subscribe(new DistinctUntilChangedConditionalSubscriber<T, K>(cs, this.keySelector, this.comparer));
        } else {
            this.source.subscribe(new DistinctUntilChangedSubscriber<T, K>(s2, this.keySelector, this.comparer));
        }
    }

    static final class DistinctUntilChangedConditionalSubscriber<T, K>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedConditionalSubscriber(ConditionalSubscriber<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.downstream.tryOnNext(t);
            }
            try {
                K key = this.keySelector.apply(t);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return false;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            this.downstream.onNext(t);
            return true;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qs.poll()) != null) {
                K key = this.keySelector.apply(v);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return v;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return v;
                }
                this.last = key;
                if (this.sourceMode == 1) continue;
                this.upstream.request(1L);
            }
            return null;
        }
    }

    static final class DistinctUntilChangedSubscriber<T, K>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedSubscriber(Subscriber<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(t);
                return true;
            }
            try {
                K key = this.keySelector.apply(t);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return false;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            this.downstream.onNext(t);
            return true;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qs.poll()) != null) {
                K key = this.keySelector.apply(v);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return v;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return v;
                }
                this.last = key;
                if (this.sourceMode == 1) continue;
                this.upstream.request(1L);
            }
            return null;
        }
    }
}

