/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper.options;

import com.zulrahhelper.options.AttackSource;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Attack {
    NONE(AttackSource.NORMAL, 0),
    NORMAL_2(AttackSource.NORMAL, 2),
    NORMAL_4(AttackSource.NORMAL, 4),
    NORMAL_5(AttackSource.NORMAL, 5),
    NORMAL_6(AttackSource.NORMAL, 6),
    NORMAL_8(AttackSource.NORMAL, 8),
    NORMAL_10(AttackSource.NORMAL, 10),
    VENOM_2(AttackSource.VENOM, 2),
    VENOM_3(AttackSource.VENOM, 3),
    VENOM_4(AttackSource.VENOM, 4),
    SNAKELING_3(AttackSource.SNAKELING, 2),
    SNAKELING_4(AttackSource.SNAKELING, 2),
    SNAKELING_6(AttackSource.SNAKELING, 2);

    private static final Logger log;
    private static final int SIZE = 70;
    private static final int PADDING = 5;
    private final AttackSource source;
    private final BufferedImage darkImg;
    private final BufferedImage lightImg;

    private Attack(AttackSource source2, int hits) {
        this.source = source2;
        this.darkImg = this.generateImage(hits, true);
        this.lightImg = this.generateImage(hits, false);
    }

    public AttackSource getSource() {
        return this.source;
    }

    public BufferedImage getImage(boolean darkMode) {
        return darkMode ? this.darkImg : this.lightImg;
    }

    private BufferedImage generateImage(int hits, boolean darkMode) {
        BufferedImage out = new BufferedImage(70, 70, 2);
        BufferedImage splat = this.source.getImage();
        BufferedImage hit = this.createHit(hits, darkMode);
        Graphics2D g2 = out.createGraphics();
        int splatX = 0;
        int splatY = 0;
        int splatSize = 70;
        if (this.source == AttackSource.SNAKELING) {
            splatX -= 10;
            splatY += 10;
            splatSize = (int)((double)splatSize / 1.5);
        }
        g2.drawImage(splat, splatX, splatY, splatSize, splatSize, null);
        g2.drawImage((Image)hit, 0, 0, null);
        return out;
    }

    public BufferedImage applyToPhase(BufferedImage phaseImg, boolean darkMode) {
        if (this == NONE) {
            return phaseImg;
        }
        Graphics g2 = phaseImg.getGraphics();
        g2.drawImage(this.getImage(darkMode), Attack.getX(phaseImg.getWidth(), this.source), Attack.getY(phaseImg.getHeight()), 70, 70, null);
        return phaseImg;
    }

    private BufferedImage createHit(int hits, boolean darkMode) {
        BufferedImage hit = new BufferedImage(70, 70, 2);
        float fontSize = 35.0f;
        Graphics g2 = hit.getGraphics();
        g2.setFont(FontManager.getDefaultFont().deriveFont(35.0f));
        FontMetrics metrics = g2.getFontMetrics();
        String text = String.valueOf(hits);
        int x = (hit.getWidth() - metrics.stringWidth(text)) / 2;
        int y = (hit.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
        if (this.source == AttackSource.SNAKELING) {
            x += 2;
            y += 5;
        }
        g2.setColor(Color.BLACK);
        g2.drawString(text, x + 1, y + 1);
        if (this.source == AttackSource.SNAKELING && !darkMode) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(Color.WHITE);
        }
        g2.drawString(text, x, y);
        return hit;
    }

    private static int getX(int phaseImgWidth, AttackSource source2) {
        int offset = phaseImgWidth / 3;
        switch (source2) {
            case NORMAL: {
                offset *= 0;
                break;
            }
            case VENOM: {
                offset *= 1;
                break;
            }
            case SNAKELING: {
                offset *= 2;
            }
        }
        return 15 + offset;
    }

    private static int getY(int phaseImgHeight) {
        return phaseImgHeight - 70 - 5;
    }

    static {
        log = LoggerFactory.getLogger(Attack.class);
    }
}

