/*
 * Decompiled with CFR 0.152.
 */
package com.radiusmarkers;

import com.radiusmarkers.AttackType;
import com.radiusmarkers.ColourRadiusMarker;
import com.radiusmarkers.RadiusMarkerConfig;
import com.radiusmarkers.RadiusMarkerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.TitleCaseListCellRenderer;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

class RadiusMarkerPanel
extends JPanel {
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    private static final ImageIcon BORDER_COLOR_ICON;
    private static final ImageIcon BORDER_COLOR_HOVER_ICON;
    private static final ImageIcon NO_BORDER_COLOR_ICON;
    private static final ImageIcon NO_BORDER_COLOR_HOVER_ICON;
    private static final ImageIcon VISIBLE_ICON;
    private static final ImageIcon VISIBLE_HOVER_ICON;
    private static final ImageIcon INVISIBLE_ICON;
    private static final ImageIcon INVISIBLE_HOVER_ICON;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon COLLAPSE_ICON;
    private static final ImageIcon COLLAPSE_HOVER_ICON;
    private static final ImageIcon EXPAND_ICON;
    private static final ImageIcon EXPAND_HOVER_ICON;
    private final RadiusMarkerPlugin plugin;
    private final RadiusMarkerConfig config;
    private final ColourRadiusMarker marker;
    private final JPanel containerSpawn = new JPanel(new BorderLayout());
    private final JPanel containerWander = new JPanel(new BorderLayout());
    private final JPanel containerMax = new JPanel(new BorderLayout());
    private final JPanel containerAggression = new JPanel(new BorderLayout());
    private final JPanel containerRetreatInteraction = new JPanel(new BorderLayout());
    private final JPanel containerNpcId = new JPanel(new BorderLayout());
    private final JPanel containerAttack = new JPanel(new BorderLayout());
    private final JPanel containerHunt = new JPanel(new BorderLayout());
    private final JPanel containerInteraction = new JPanel(new BorderLayout());
    private final JLabel colourSpawn = new JLabel();
    private final JLabel colourWander = new JLabel();
    private final JLabel colourMax = new JLabel();
    private final JLabel colourAggression = new JLabel();
    private final JLabel colourRetreatInteraction = new JLabel();
    private final JLabel colourAttack = new JLabel();
    private final JLabel colourHunt = new JLabel();
    private final JLabel colourInteraction = new JLabel();
    private final JLabel visibilityMarker = new JLabel();
    private final JLabel visibilitySpawn = new JLabel();
    private final JLabel visibilityWander = new JLabel();
    private final JLabel visibilityMax = new JLabel();
    private final JLabel visibilityAggression = new JLabel();
    private final JLabel visibilityRetreatInteraction = new JLabel();
    private final JLabel visibilityAttack = new JLabel();
    private final JLabel visibilityHunt = new JLabel();
    private final JLabel visibilityInteraction = new JLabel();
    private final JLabel deleteLabel = new JLabel();
    private final JButton expandToggle;
    private final FlatTextField nameInput = new FlatTextField();
    private final JLabel save = new JLabel("Save");
    private final JLabel cancel = new JLabel("Cancel");
    private final JLabel rename = new JLabel("Rename");
    private final JSpinner spinnerX = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerY = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerRadiusWander = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerRadiusMax = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerNpcId = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerRadiusAttack = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerRadiusHunt = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));
    private final JSpinner spinnerRadiusInteraction = new JSpinner(new SpinnerNumberModel(5, 0, Integer.MAX_VALUE, 1));

    RadiusMarkerPanel(final RadiusMarkerPlugin plugin, final RadiusMarkerConfig config, final ColourRadiusMarker marker) {
        JLabel[] labels;
        JSpinner[] spinners;
        JPanel[] containers;
        this.plugin = plugin;
        this.config = config;
        this.marker = marker;
        marker.setPanel(this);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel(new FlowLayout(2, 3, 3));
        nameActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.save.setVisible(false);
        this.save.setFont(FontManager.getRunescapeSmallFont());
        this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.save.setBorder(new EmptyBorder(3, 0, 0, 3));
        this.save.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.save();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            }
        });
        this.cancel.setVisible(false);
        this.cancel.setFont(FontManager.getRunescapeSmallFont());
        this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancel.setBorder(new EmptyBorder(3, 0, 0, 3));
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.cancel();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.rename.setFont(FontManager.getRunescapeSmallFont());
        this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.rename.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.nameInput.setEditable(true);
                RadiusMarkerPanel.this.updateNameActions(true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        this.nameInput.setText(marker.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setPreferredSize(new Dimension(0, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBorder(new EmptyBorder(0, 5, 0, 0));
        this.nameInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RadiusMarkerPanel.this.save();
                } else if (e.getKeyCode() == 27) {
                    RadiusMarkerPanel.this.cancel();
                }
            }
        });
        this.nameInput.getTextField().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    boolean open = RadiusMarkerPanel.this.containerSpawn.isVisible();
                    marker.setCollapsed(open);
                    RadiusMarkerPanel.this.updateCollapsed();
                    plugin.saveMarkers();
                }
            }
        });
        for (JPanel container : containers = new JPanel[]{this.containerSpawn, this.containerWander, this.containerMax, this.containerAggression, this.containerRetreatInteraction, this.containerNpcId, this.containerAttack, this.containerHunt, this.containerInteraction}) {
            container.setBorder(new EmptyBorder(5, 0, 5, 0));
            container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
        this.containerNpcId.setBorder(new EmptyBorder(5, 26, 5, 26));
        JPanel leftActionsSpawn = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsWander = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsMax = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsAggression = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsRetreatInteraction = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsNpcId = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsAttack = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsHunt = new JPanel(new FlowLayout(0, 8, 0));
        JPanel leftActionsInteraction = new JPanel(new FlowLayout(0, 8, 0));
        leftActionsSpawn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsWander.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsMax.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsAggression.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsRetreatInteraction.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsNpcId.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsAttack.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsHunt.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActionsInteraction.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.colourSpawn.setToolTipText("Edit spawn point colour");
        this.colourSpawn.setForeground(marker.getSpawnColour() == null ? config.defaultColourSpawn() : marker.getSpawnColour());
        this.colourSpawn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerSpawn();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourSpawn.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourSpawn.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourWander.setToolTipText("Edit wander range colour");
        this.colourWander.setForeground(marker.getWanderColour() == null ? config.defaultColourWander() : marker.getWanderColour());
        this.colourWander.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerWander();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourWander.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourWander.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourMax.setToolTipText("Edit max range colour");
        this.colourMax.setForeground(marker.getMaxColour() == null ? config.defaultColourMax() : marker.getMaxColour());
        this.colourMax.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerMax();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourMax.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourMax.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourAggression.setToolTipText("Edit aggression range colour");
        this.colourAggression.setForeground(marker.getAggressionColour() == null ? config.defaultColourAggression() : marker.getAggressionColour());
        this.colourAggression.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerAggression();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourAggression.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourAggression.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourRetreatInteraction.setToolTipText("Edit retreat interaction range colour");
        this.colourRetreatInteraction.setForeground(marker.getRetreatInteractionColour() == null ? config.defaultColourRetreatInteraction() : marker.getRetreatInteractionColour());
        this.colourRetreatInteraction.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerRetreatInteraction();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourRetreatInteraction.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourRetreatInteraction.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourAttack.setToolTipText("Edit attack range colour");
        this.colourAttack.setForeground(marker.getAttackColour() == null ? config.defaultColourAttack() : marker.getAttackColour());
        this.colourAttack.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerAttack();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourAttack.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourAttack.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourHunt.setToolTipText("Edit hunt range colour");
        this.colourHunt.setForeground(marker.getHuntColour() == null ? config.defaultColourHunt() : marker.getHuntColour());
        this.colourHunt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerHunt();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourHunt.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourHunt.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.colourInteraction.setToolTipText("Edit interaction range colour");
        this.colourInteraction.setForeground(marker.getInteractionColour() == null ? config.defaultColourInteraction() : marker.getInteractionColour());
        this.colourInteraction.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.openColourPickerInteraction();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourInteraction.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_HOVER_ICON : BORDER_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.colourInteraction.setIcon(config.borderWidth() == 0 ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
            }
        });
        this.spinnerX.setValue(marker.getSpawnX());
        this.spinnerY.setValue(marker.getSpawnY());
        this.spinnerRadiusWander.setValue(marker.getWanderRadius());
        this.spinnerRadiusMax.setValue(marker.getMaxRadius());
        this.spinnerNpcId.setValue(marker.getNpcId());
        this.spinnerRadiusAttack.setValue(marker.getAttackRadius());
        this.spinnerRadiusHunt.setValue(marker.getHuntRadius());
        this.spinnerRadiusInteraction.setValue(marker.getInteractionRadius());
        for (JSpinner spinner : spinners = new JSpinner[]{this.spinnerX, this.spinnerY, this.spinnerRadiusWander, this.spinnerRadiusMax, this.spinnerNpcId, this.spinnerRadiusAttack, this.spinnerRadiusHunt, this.spinnerRadiusInteraction}) {
            spinner.setPreferredSize(new Dimension(53, 20));
            spinner.addChangeListener(ce -> this.updateMarker());
        }
        this.spinnerX.setPreferredSize(new Dimension(70, 20));
        this.spinnerY.setPreferredSize(new Dimension(70, 20));
        this.spinnerRadiusWander.setPreferredSize(new Dimension(62, 20));
        this.spinnerRadiusMax.setPreferredSize(new Dimension(62, 20));
        this.spinnerNpcId.setPreferredSize(new Dimension(80, 20));
        JLabel labelWander = new JLabel("Wander range");
        JLabel labelMax = new JLabel("Max range");
        JLabel labelAggression = new JLabel("Aggression range");
        JLabel labelRetreatInteraction = new JLabel("Retreat interaction range");
        JLabel labelNpcId = new JLabel("NPC ID");
        JLabel labelHunt = new JLabel("Hunt range");
        JLabel labelInteraction = new JLabel("Interaction range");
        for (JLabel label : labels = new JLabel[]{labelWander, labelMax, labelAggression, labelRetreatInteraction, labelNpcId, labelHunt, labelInteraction}) {
            label.setFont(FontManager.getRunescapeSmallFont());
            label.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        }
        labelNpcId.setPreferredSize(new Dimension(58, 21));
        JComboBox<AttackType> selectionAttackType = new JComboBox<AttackType>(AttackType.values());
        selectionAttackType.setRenderer(new TitleCaseListCellRenderer());
        selectionAttackType.setPreferredSize(new Dimension(84, 20));
        selectionAttackType.setSelectedIndex(marker.getAttackType() == null ? 0 : marker.getAttackType().ordinal());
        selectionAttackType.setToolTipText("Attack range type");
        selectionAttackType.addActionListener(e -> {
            marker.setAttackType((AttackType)((Object)((Object)selectionAttackType.getSelectedItem())));
            plugin.saveMarkers();
        });
        leftActionsSpawn.add(this.colourSpawn);
        leftActionsSpawn.add(this.spinnerX);
        leftActionsWander.add(this.colourWander);
        leftActionsWander.add(labelWander);
        leftActionsMax.add(this.colourMax);
        leftActionsMax.add(labelMax);
        leftActionsAggression.add(this.colourAggression);
        leftActionsAggression.add(labelAggression);
        leftActionsRetreatInteraction.add(this.colourRetreatInteraction);
        leftActionsRetreatInteraction.add(labelRetreatInteraction);
        leftActionsNpcId.add(labelNpcId);
        leftActionsAttack.add(this.colourAttack);
        leftActionsAttack.add(selectionAttackType);
        leftActionsHunt.add(this.colourHunt);
        leftActionsHunt.add(labelHunt);
        leftActionsInteraction.add(this.colourInteraction);
        leftActionsInteraction.add(labelInteraction);
        JPanel rightActionsSpawn = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsWander = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsMax = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsAggression = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsRetreatInteraction = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsNpcId = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsAttack = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsHunt = new JPanel(new FlowLayout(2, 8, 0));
        JPanel rightActionsInteraction = new JPanel(new FlowLayout(2, 8, 0));
        rightActionsSpawn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsWander.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsMax.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsAggression.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsRetreatInteraction.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsNpcId.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsAttack.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsHunt.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActionsInteraction.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.expandToggle = new JButton(marker.isCollapsed() ? COLLAPSE_ICON : EXPAND_ICON);
        this.expandToggle.setRolloverIcon(marker.isCollapsed() ? COLLAPSE_HOVER_ICON : EXPAND_HOVER_ICON);
        this.expandToggle.setPreferredSize(new Dimension(15, 0));
        this.expandToggle.setBorder(new EmptyBorder(0, 6, 1, 0));
        this.expandToggle.setToolTipText((marker.isCollapsed() ? "Expand" : "Collapse") + " marker");
        SwingUtil.removeButtonDecorations(this.expandToggle);
        this.expandToggle.addActionListener(actionEvent -> {
            boolean open = this.containerSpawn.isVisible();
            marker.setCollapsed(open);
            this.updateCollapsed();
            plugin.saveMarkers();
        });
        this.visibilityMarker.setToolTipText((marker.isVisible() ? "Hide" : "Show") + " marker");
        this.visibilityMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setVisible(!marker.isVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityMarker.setIcon(marker.isVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.deleteLabel.setIcon(DELETE_ICON);
        this.deleteLabel.setToolTipText("Delete marker");
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm = JOptionPane.showConfirmDialog(RadiusMarkerPanel.this, "Are you sure you want to permanently delete this radius marker?", "Warning", 2);
                if (confirm == 0) {
                    plugin.removeMarker(marker);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.deleteLabel.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.deleteLabel.setIcon(DELETE_ICON);
            }
        });
        this.visibilitySpawn.setToolTipText((marker.isSpawnVisible() ? "Hide" : "Show") + " spawn point");
        this.visibilitySpawn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setSpawnVisible(!marker.isSpawnVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilitySpawn.setIcon(marker.isSpawnVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityWander.setToolTipText((marker.isWanderVisible() ? "Hide" : "Show") + " wander range");
        this.visibilityWander.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setWanderVisible(!marker.isWanderVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityWander.setIcon(marker.isWanderVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityMax.setToolTipText((marker.isMaxVisible() ? "Hide" : "Show") + " max range");
        this.visibilityMax.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setMaxVisible(!marker.isMaxVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityMax.setIcon(marker.isMaxVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityAggression.setToolTipText((marker.isAggressionVisible() ? "Hide" : "Show") + " aggression range");
        this.visibilityAggression.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setAggressionVisible(!marker.isAggressionVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityAggression.setIcon(marker.isAggressionVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityRetreatInteraction.setToolTipText((marker.isRetreatInteractionVisible() ? "Hide" : "Show") + " retreat interaction range");
        this.visibilityRetreatInteraction.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setRetreatInteractionVisible(!marker.isRetreatInteractionVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityRetreatInteraction.setIcon(marker.isRetreatInteractionVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityAttack.setToolTipText((marker.isAttackVisible() ? "Hide" : "Show") + " attack range");
        this.visibilityAttack.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setAttackVisible(!marker.isAttackVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityAttack.setIcon(marker.isAttackVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityHunt.setToolTipText((marker.isHuntVisible() ? "Hide" : "Show") + " hunt range");
        this.visibilityHunt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setHuntVisible(!marker.isHuntVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityHunt.setIcon(marker.isHuntVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        this.visibilityInteraction.setToolTipText((marker.isInteractionVisible() ? "Hide" : "Show") + " interaction range");
        this.visibilityInteraction.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                marker.setInteractionVisible(!marker.isInteractionVisible());
                RadiusMarkerPanel.this.updateVisibility();
                plugin.saveMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.visibilityInteraction.setIcon(marker.isInteractionVisible() ? VISIBLE_HOVER_ICON : INVISIBLE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPanel.this.updateVisibility();
            }
        });
        nameActions.add(this.rename);
        nameActions.add(this.cancel);
        nameActions.add(this.save);
        nameActions.add(this.visibilityMarker);
        nameActions.add(this.deleteLabel);
        nameWrapper.add((Component)this.expandToggle, "West");
        nameWrapper.add((Component)this.nameInput, "Center");
        nameWrapper.add((Component)nameActions, "East");
        rightActionsSpawn.add(this.spinnerY);
        rightActionsSpawn.add(this.visibilitySpawn);
        rightActionsWander.add(this.spinnerRadiusWander);
        rightActionsWander.add(this.visibilityWander);
        rightActionsMax.add(this.spinnerRadiusMax);
        rightActionsMax.add(this.visibilityMax);
        rightActionsAggression.add(this.visibilityAggression);
        rightActionsRetreatInteraction.add(this.visibilityRetreatInteraction);
        rightActionsNpcId.add(this.spinnerNpcId);
        rightActionsAttack.add(this.spinnerRadiusAttack);
        rightActionsAttack.add(this.visibilityAttack);
        rightActionsHunt.add(this.spinnerRadiusHunt);
        rightActionsHunt.add(this.visibilityHunt);
        rightActionsInteraction.add(this.spinnerRadiusInteraction);
        rightActionsInteraction.add(this.visibilityInteraction);
        this.containerSpawn.add((Component)leftActionsSpawn, "West");
        this.containerSpawn.add((Component)rightActionsSpawn, "East");
        this.containerWander.add((Component)leftActionsWander, "West");
        this.containerWander.add((Component)rightActionsWander, "East");
        this.containerMax.add((Component)leftActionsMax, "West");
        this.containerMax.add((Component)rightActionsMax, "East");
        this.containerAggression.add((Component)leftActionsAggression, "West");
        this.containerAggression.add((Component)rightActionsAggression, "East");
        this.containerRetreatInteraction.add((Component)leftActionsRetreatInteraction, "West");
        this.containerRetreatInteraction.add((Component)rightActionsRetreatInteraction, "East");
        this.containerNpcId.add((Component)leftActionsNpcId, "West");
        this.containerNpcId.add((Component)rightActionsNpcId, "East");
        this.containerAttack.add((Component)leftActionsAttack, "West");
        this.containerAttack.add((Component)rightActionsAttack, "East");
        this.containerHunt.add((Component)leftActionsHunt, "West");
        this.containerHunt.add((Component)rightActionsHunt, "East");
        this.containerInteraction.add((Component)leftActionsInteraction, "West");
        this.containerInteraction.add((Component)rightActionsInteraction, "East");
        JPanel markerContainer = new JPanel();
        markerContainer.setLayout(new BoxLayout(markerContainer, 1));
        markerContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        markerContainer.add(nameWrapper);
        markerContainer.add(this.containerSpawn);
        if (config.includeWanderRange()) {
            markerContainer.add(this.containerWander);
        }
        if (config.includeMaxRange()) {
            markerContainer.add(this.containerMax);
        }
        if (config.includeAggressionRange()) {
            markerContainer.add(this.containerAggression);
        }
        if (config.includeRetreatInteractionRange()) {
            markerContainer.add(this.containerRetreatInteraction);
        }
        if (config.includeAttackRange() || config.includeHuntRange() || config.includeInteractionRange()) {
            markerContainer.add(this.containerNpcId);
        }
        if (config.includeAttackRange()) {
            markerContainer.add(this.containerAttack);
        }
        if (config.includeHuntRange()) {
            markerContainer.add(this.containerHunt);
        }
        if (config.includeInteractionRange()) {
            markerContainer.add(this.containerInteraction);
        }
        this.add(markerContainer);
        this.updateVisibility();
        this.updateColourIndicators();
        this.updateCollapsed();
    }

    public void setMarkerText(String text) {
        this.nameInput.setText(text);
    }

    public void setNpcId(int npcId) {
        this.spinnerNpcId.setValue(npcId);
    }

    private void save() {
        this.marker.setName(this.nameInput.getText());
        this.plugin.saveMarkers();
        this.nameInput.setEditable(false);
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void cancel() {
        this.nameInput.setEditable(false);
        this.nameInput.setText(this.marker.getName());
        this.updateNameActions(false);
        this.requestFocusInWindow();
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.save.setVisible(saveAndCancel);
        this.cancel.setVisible(saveAndCancel);
        this.rename.setVisible(!saveAndCancel);
        this.expandToggle.setVisible(!saveAndCancel);
        this.visibilityMarker.setVisible(!saveAndCancel);
        this.deleteLabel.setVisible(!saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
            this.plugin.setRenameMarker(this.marker);
        } else {
            this.plugin.setRenameMarker(null);
        }
    }

    private void updateMarker() {
        this.marker.setSpawnX((Integer)this.spinnerX.getValue());
        this.marker.setSpawnY((Integer)this.spinnerY.getValue());
        this.marker.setWanderRadius((Integer)this.spinnerRadiusWander.getValue());
        this.marker.setMaxRadius((Integer)this.spinnerRadiusMax.getValue());
        this.marker.setNpcId((Integer)this.spinnerNpcId.getValue());
        this.marker.setAttackRadius((Integer)this.spinnerRadiusAttack.getValue());
        this.marker.setHuntRadius((Integer)this.spinnerRadiusHunt.getValue());
        this.marker.setInteractionRadius((Integer)this.spinnerRadiusInteraction.getValue());
        this.updateVisibility();
        this.plugin.saveMarkers();
    }

    private void updateVisibility() {
        this.visibilityMarker.setIcon(this.marker.isVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilitySpawn.setIcon(this.marker.isSpawnVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityWander.setIcon(this.marker.isWanderVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityMax.setIcon(this.marker.isMaxVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityAggression.setIcon(this.marker.isAggressionVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityRetreatInteraction.setIcon(this.marker.isRetreatInteractionVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityAttack.setIcon(this.marker.isAttackVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityHunt.setIcon(this.marker.isHuntVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
        this.visibilityInteraction.setIcon(this.marker.isInteractionVisible() ? VISIBLE_ICON : INVISIBLE_ICON);
    }

    private void updateCollapsed() {
        boolean open = !this.marker.isCollapsed();
        this.rename.setVisible(open);
        this.containerSpawn.setVisible(open);
        this.containerWander.setVisible(open);
        this.containerMax.setVisible(open);
        this.containerAggression.setVisible(open);
        this.containerRetreatInteraction.setVisible(open);
        this.containerNpcId.setVisible(open);
        this.containerAttack.setVisible(open);
        this.containerHunt.setVisible(open);
        this.containerInteraction.setVisible(open);
        this.expandToggle.setIcon(open ? COLLAPSE_ICON : EXPAND_ICON);
        this.expandToggle.setRolloverIcon(open ? COLLAPSE_HOVER_ICON : EXPAND_HOVER_ICON);
        this.expandToggle.setToolTipText((open ? "Collapse" : "Expand") + " marker");
    }

    private void updateColourIndicators() {
        boolean borderless = this.config.borderWidth() == 0;
        this.colourSpawn.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getSpawnColour()));
        this.colourWander.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getWanderColour()));
        this.colourMax.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getMaxColour()));
        this.colourAggression.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getAggressionColour()));
        this.colourRetreatInteraction.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getRetreatInteractionColour()));
        this.colourAttack.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getAttackColour()));
        this.colourHunt.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getHuntColour()));
        this.colourInteraction.setBorder(borderless ? null : new MatteBorder(0, 0, 3, 0, this.marker.getInteractionColour()));
        this.colourSpawn.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourWander.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourMax.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourAggression.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourRetreatInteraction.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourAttack.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourHunt.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
        this.colourInteraction.setIcon(borderless ? NO_BORDER_COLOR_ICON : BORDER_COLOR_ICON);
    }

    private void openColourPickerSpawn() {
        Color color = this.marker.getSpawnColour() == null ? this.config.defaultColourSpawn() : this.marker.getSpawnColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Spawn point colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setSpawnColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerWander() {
        Color color = this.marker.getWanderColour() == null ? this.config.defaultColourWander() : this.marker.getWanderColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Wander range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setWanderColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerMax() {
        Color color = this.marker.getMaxColour() == null ? this.config.defaultColourMax() : this.marker.getMaxColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Max range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setMaxColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerAggression() {
        Color color = this.marker.getAggressionColour() == null ? this.config.defaultColourAggression() : this.marker.getAggressionColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Aggression range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setAggressionColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerRetreatInteraction() {
        Color color = this.marker.getRetreatInteractionColour() == null ? this.config.defaultColourRetreatInteraction() : this.marker.getRetreatInteractionColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Retreat interaction range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setRetreatInteractionColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerAttack() {
        Color color = this.marker.getAttackColour() == null ? this.config.defaultColourAttack() : this.marker.getAttackColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Attack range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setAttackColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerHunt() {
        Color color = this.marker.getHuntColour() == null ? this.config.defaultColourHunt() : this.marker.getHuntColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Hunt range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setHuntColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private void openColourPickerInteraction() {
        Color color = this.marker.getInteractionColour() == null ? this.config.defaultColourInteraction() : this.marker.getInteractionColour();
        RuneliteColorPicker colourPicker = this.getColourPicker(color, " - Interaction range colour");
        colourPicker.setOnColorChange(c -> {
            this.marker.setInteractionColour((Color)c);
            this.updateColourIndicators();
        });
        colourPicker.setVisible(true);
    }

    private RuneliteColorPicker getColourPicker(Color colour, String text) {
        RuneliteColorPicker colourPicker = this.plugin.getColourPickerManager().create(SwingUtilities.windowForComponent(this), colour, this.marker.getName() + text, false);
        colourPicker.setLocationRelativeTo(this);
        colourPicker.setOnClose(c -> this.plugin.saveMarkers());
        return colourPicker;
    }

    static {
        BufferedImage borderImg = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "border_color_icon.png");
        BufferedImage borderImgHover = ImageUtil.luminanceOffset(borderImg, -150);
        BORDER_COLOR_ICON = new ImageIcon(borderImg);
        BORDER_COLOR_HOVER_ICON = new ImageIcon(borderImgHover);
        NO_BORDER_COLOR_ICON = new ImageIcon(borderImgHover);
        NO_BORDER_COLOR_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)borderImgHover, -100));
        BufferedImage visibleImg = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "visible_icon.png");
        VISIBLE_ICON = new ImageIcon(visibleImg);
        VISIBLE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)visibleImg, -100));
        BufferedImage invisibleImg = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "invisible_icon.png");
        INVISIBLE_ICON = new ImageIcon(invisibleImg);
        INVISIBLE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)invisibleImg, -100));
        BufferedImage deleteImg = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, -100));
        BufferedImage retractIcon = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "arrow_right.png");
        retractIcon = ImageUtil.luminanceOffset(retractIcon, -121);
        EXPAND_ICON = new ImageIcon(retractIcon);
        EXPAND_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)retractIcon, -100));
        BufferedImage expandIcon = ImageUtil.rotateImage(retractIcon, 1.5707963267948966);
        COLLAPSE_ICON = new ImageIcon(expandIcon);
        COLLAPSE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)expandIcon, -100));
    }
}

