/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.maze;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.TheGauntletPlugin;
import ca.gauntlet.module.maze.Resource;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ResourceManager {
    private static final Logger log = LoggerFactory.getLogger(ResourceManager.class);
    private static final Pattern PATTERN_RESOURCE_DROP = Pattern.compile("^.+ drop:\\s+((?<quantity>\\d+) x )?(?<name>.+)$");
    private static final int SHARD_COUNT_BREAK_DOWN = 80;
    private final EnumMap<Resource, ResourceCounter> counterByResource = new EnumMap(Resource.class);
    @Inject
    private Client client;
    @Inject
    private TheGauntletPlugin plugin;
    @Inject
    private TheGauntletConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    private Region region = Region.UNKNOWN;

    ResourceManager() {
    }

    void init() {
        int type = this.client.getVarbitValue(9292);
        this.region = type == 1 ? Region.CORRUPTED : Region.NORMAL;
        if (this.config.resourceTracker()) {
            this.createResourceCountersFromConfig();
        }
    }

    void reset() {
        this.region = Region.UNKNOWN;
        this.counterByResource.clear();
        this.infoBoxManager.removeIf(ResourceCounter.class::isInstance);
    }

    void parseChatMessage(String chatMessage) {
        if (!this.config.resourceTracker() || this.region == Region.UNKNOWN) {
            return;
        }
        if (chatMessage.charAt(0) == '<') {
            this.parseNpcChatMessage(chatMessage);
        } else {
            this.parseSkillChatMessage(chatMessage);
        }
    }

    boolean hasAcquired(Resource resource) {
        ResourceCounter resourceCounter = this.counterByResource.get((Object)resource);
        return resourceCounter == null ? this.config.resourceRemoveAcquired() : resourceCounter.hasAcquiredTarget();
    }

    private void parseNpcChatMessage(String message) {
        String noTagsMessage = Text.removeTags(message);
        Matcher matcher = PATTERN_RESOURCE_DROP.matcher(noTagsMessage);
        if (!matcher.matches()) {
            return;
        }
        String name = matcher.group("name");
        if (name == null) {
            return;
        }
        Resource resource = Resource.fromName(name, this.region == Region.CORRUPTED);
        if (resource == null) {
            return;
        }
        String quantity = matcher.group("quantity");
        int count = quantity != null ? Integer.parseInt(quantity) : 1;
        this.updateResourceCounter(resource, count);
    }

    private void parseSkillChatMessage(String message) {
        if (message.startsWith("break down", 4)) {
            Resource resource = this.region == Region.CORRUPTED ? Resource.CORRUPTED_SHARDS : Resource.CRYSTAL_SHARDS;
            this.updateResourceCounter(resource, 80);
            return;
        }
        Map.Entry<Resource, Integer> mapping = Resource.fromPattern(message, this.region == Region.CORRUPTED);
        if (mapping == null) {
            return;
        }
        this.updateResourceCounter(mapping.getKey(), mapping.getValue());
    }

    private void updateResourceCounter(Resource resource, int count) {
        ResourceCounter resourceCounter = this.counterByResource.get((Object)resource);
        if (resourceCounter == null) {
            return;
        }
        resourceCounter.updateCount(count);
        if (this.config.resourceRemoveAcquired() && resourceCounter.hasAcquiredTarget()) {
            this.counterByResource.remove((Object)resource);
            this.infoBoxManager.removeInfoBox(resourceCounter);
        }
    }

    private void createResourceCounter(Resource resource, int count) {
        if (count <= 0) {
            return;
        }
        boolean decrement = this.config.resourceTrackingMode() == TheGauntletConfig.TrackingMode.DECREMENT;
        ResourceCounter resourceCounter = new ResourceCounter(this.itemManager.getImage(resource.getItemId()), this.plugin, resource, decrement ? count : 0, decrement ? 0 : count);
        this.counterByResource.put(resource, resourceCounter);
        this.infoBoxManager.addInfoBox(resourceCounter);
    }

    private void createResourceCountersFromConfig() {
        boolean corrupted = this.region == Region.CORRUPTED;
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_ORE : Resource.CRYSTAL_ORE, this.config.resourceOre());
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_PHREN_BARK : Resource.PHREN_BARK, this.config.resourceBark());
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_LINUM_TIRINUM : Resource.LINUM_TIRINUM, this.config.resourceTirinum());
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_GRYM_LEAF : Resource.GRYM_LEAF, this.config.resourceGrym());
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_WEAPON_FRAME : Resource.WEAPON_FRAME, this.config.resourceFrame());
        this.createResourceCounter(Resource.RAW_PADDLEFISH, this.config.resourcePaddlefish());
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_SHARDS : Resource.CRYSTAL_SHARDS, this.config.resourceShard());
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_BOWSTRING : Resource.CRYSTALLINE_BOWSTRING, this.config.resourceBowstring() ? 1 : 0);
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_SPIKE : Resource.CRYSTAL_SPIKE, this.config.resourceSpike() ? 1 : 0);
        this.createResourceCounter(corrupted ? Resource.CORRUPTED_ORB : Resource.CRYSTAL_ORB, this.config.resourceOrb() ? 1 : 0);
    }

    private static class ResourceCounter
    extends InfoBox {
        private final int target;
        private int count;
        private String text;
        private Color color = Color.WHITE;

        private ResourceCounter(BufferedImage bufferedImage, TheGauntletPlugin plugin, Resource resource, int count, int target) {
            super(bufferedImage, plugin);
            this.setPriority(ResourceCounter.getPriority(resource));
            this.count = count;
            this.target = Math.max(0, target);
            this.text = String.valueOf(count);
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public Color getTextColor() {
            return this.color;
        }

        private void updateCount(int count) {
            this.count = this.target == 0 ? Math.max(0, this.count - count) : (this.count += count);
            if (this.hasAcquiredTarget()) {
                this.color = Color.GRAY;
            }
            this.text = String.valueOf(this.count);
        }

        private boolean hasAcquiredTarget() {
            return this.target == 0 ? this.count <= this.target : this.count >= this.target;
        }

        private static InfoBoxPriority getPriority(Resource resource) {
            switch (resource) {
                case CRYSTAL_ORE: 
                case CORRUPTED_ORE: 
                case PHREN_BARK: 
                case CORRUPTED_PHREN_BARK: 
                case LINUM_TIRINUM: 
                case CORRUPTED_LINUM_TIRINUM: {
                    return InfoBoxPriority.HIGH;
                }
                case GRYM_LEAF: 
                case CORRUPTED_GRYM_LEAF: {
                    return InfoBoxPriority.MED;
                }
                case CRYSTAL_SHARDS: 
                case CORRUPTED_SHARDS: 
                case RAW_PADDLEFISH: {
                    return InfoBoxPriority.NONE;
                }
            }
            return InfoBoxPriority.LOW;
        }
    }

    private static enum Region {
        NORMAL,
        CORRUPTED,
        UNKNOWN;


        private static Region fromId(int id) {
            switch (id) {
                case 7512: {
                    return NORMAL;
                }
                case 7768: {
                    return CORRUPTED;
                }
            }
            return UNKNOWN;
        }
    }
}

